/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v140;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.CreateDatabaseService;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.schema.type.PartitionColumnDetails;
import org.openmetadata.schema.type.PartitionIntervalTypes;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TablePartition;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.util.JsonUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final String MYSQL_QUERY_TABLES_WITH_PARTITION = "SELECT json FROM table_entity WHERE JSON_EXTRACT(json, '$.tablePartition') IS NOT NULL";
    private static final String POSTGRES_QUERY_TABLES_WITH_PARTITION = "SELECT json FROM table_entity WHERE json->'tablePartition' IS NOT NULL";
    private static final String TEST_CASE_RESOLUTION_QUERY = "SELECT json FROM test_case_resolution_status_time_series";
    private static final String MYSQL_TEST_CASE_RESOLUTION_UPDATE_QUERY = "UPDATE test_case_resolution_status_time_series SET json = :json WHERE id = :id";
    private static final String POSTGRES_TEST_CASE_RESOLUTION_UPDATE_QUERY = "UPDATE test_case_resolution_status_time_series SET json = :json::jsonb WHERE id = :id";

    private MigrationUtil() {
    }

    public static void migrateGenericToWebhook(CollectionDAO collectionDAO) {
        try {
            List<String> jsonEventSubscription = collectionDAO.eventSubscriptionDAO().listAllEventsSubscriptions();
            for (String eventSubscription : jsonEventSubscription) {
                JSONObject jsonObj = new JSONObject(eventSubscription);
                JSONArray destination = jsonObj.getJSONArray("destinations");
                if (destination == null || destination.isEmpty()) continue;
                for (Object value : destination) {
                    JSONObject destinationObj = (JSONObject)value;
                    if (!destinationObj.getString("type").equals("Generic")) continue;
                    destinationObj.put("type", (Object)"Webhook");
                    collectionDAO.eventSubscriptionDAO().update((EntityInterface)JsonUtils.readValue(jsonObj.toString(), EventSubscription.class));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Error running the Generic to Webhook migration ", (Throwable)ex);
        }
    }

    public static void migrateTestCaseResolution(Handle handle, CollectionDAO collectionDAO) {
        try {
            handle.createQuery(TEST_CASE_RESOLUTION_QUERY).mapToMap().forEach(row -> {
                try {
                    TestCaseResolutionStatus testCaseResolutionStatus = JsonUtils.readValue(row.get("json").toString(), TestCaseResolutionStatus.class);
                    UUID fromId = testCaseResolutionStatus.getTestCaseReference().getId();
                    UUID toId = testCaseResolutionStatus.getId();
                    collectionDAO.relationshipDAO().insert(fromId, toId, "testCase", "testCaseResolutionStatus", Relationship.PARENT_OF.ordinal(), null);
                    testCaseResolutionStatus.setTestCaseReference(null);
                    String json = JsonUtils.pojoToJson(testCaseResolutionStatus);
                    String updateQuery = MYSQL_TEST_CASE_RESOLUTION_UPDATE_QUERY;
                    if (Boolean.FALSE.equals(DatasourceConfig.getInstance().isMySQL())) {
                        updateQuery = POSTGRES_TEST_CASE_RESOLUTION_UPDATE_QUERY;
                    }
                    ((Update)((Update)handle.createUpdate(updateQuery).bind("json", json)).bind("id", toId.toString())).execute();
                }
                catch (Exception ex) {
                    LOG.warn("Error during the test case resolution migration due to ", (Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            LOG.warn("Error running the test case resolution migration ", (Throwable)ex);
        }
    }

    public static void migrateTablePartition(Handle handle, CollectionDAO collectionDAO) {
        try {
            if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
                handle.createQuery(MYSQL_QUERY_TABLES_WITH_PARTITION).mapToMap().forEach(row -> {
                    String jsonRow = (String)row.get("json");
                    MigrationUtil.handleTablePartitionMigration(jsonRow, collectionDAO);
                });
                return;
            }
            handle.createQuery(POSTGRES_QUERY_TABLES_WITH_PARTITION).mapToMap().forEach(row -> {
                PGobject pgObject = (PGobject)row.get("json");
                String jsonRow = pgObject.getValue();
                MigrationUtil.handleTablePartitionMigration(jsonRow, collectionDAO);
            });
        }
        catch (Exception ex) {
            LOG.warn("Error running the query migration ", (Throwable)ex);
        }
    }

    private static void handleTablePartitionMigration(String jsonRow, CollectionDAO collectionDAO) {
        try {
            JsonObject jsonObj = JsonUtils.readJson(jsonRow).asJsonObject();
            JsonObject tablePartition = jsonObj.getJsonObject("tablePartition");
            HashMap jsonMap = JsonUtils.readValue(jsonObj.toString(), HashMap.class);
            jsonMap.remove("tablePartition");
            jsonObj = JsonUtils.readJson(JsonUtils.pojoToJson(jsonMap)).asJsonObject();
            Table table = JsonUtils.readValue(jsonObj.toString(), Table.class);
            if (!tablePartition.isEmpty()) {
                String interval;
                JsonArray partitionColumns = tablePartition.getJsonArray("columns");
                ArrayList<PartitionColumnDetails> partitionColumnDetails = new ArrayList<PartitionColumnDetails>();
                if ((partitionColumns == null || partitionColumns.isEmpty()) && table.getServiceType() == CreateDatabaseService.DatabaseServiceType.BigQuery && (interval = tablePartition.getString("interval", null)) != null) {
                    JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                    switch (interval) {
                        case "HOUR": {
                            partitionColumns = jsonArrayBuilder.add("_PARTITIONTIME").build();
                            break;
                        }
                        case "DAY": {
                            partitionColumns = jsonArrayBuilder.add("_PARTITIONDATE").build();
                        }
                    }
                }
                if (partitionColumns != null && !partitionColumns.isEmpty()) {
                    for (JsonValue column : partitionColumns) {
                        PartitionColumnDetails partitionColumnDetail = new PartitionColumnDetails();
                        partitionColumnDetail.setColumnName(((JsonString)column).getString());
                        String intervalType = tablePartition.getString("intervalType", null);
                        if (intervalType != null) {
                            partitionColumnDetail.setIntervalType(PartitionIntervalTypes.fromValue((String)intervalType));
                        }
                        partitionColumnDetail.setInterval(tablePartition.getString("interval", null));
                        partitionColumnDetails.add(partitionColumnDetail);
                    }
                    table.withTablePartition(new TablePartition().withColumns(partitionColumnDetails));
                    collectionDAO.tableDAO().update((EntityInterface)table);
                }
            } else {
                LOG.debug("Table {} does not have partition details", (Object)table.getId());
            }
        }
        catch (Exception exc) {
            LOG.warn("Fail to migrate table partition. The partition detail may have been migrated already.");
            LOG.debug(String.format("Table JSON %s\n", jsonRow), (Throwable)exc);
        }
    }
}

