/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.search.SearchListFilter;
import org.openmetadata.service.search.SearchSortFilter;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.CreateResourceContext;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityResource<T extends EntityInterface, K extends EntityRepository<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    protected final Class<T> entityClass;
    protected final String entityType;
    protected final Set<String> allowedFields;
    protected final K repository;
    protected final Authorizer authorizer;
    protected final Map<String, MetadataOperation> fieldsToViewOperations = new HashMap<String, MetadataOperation>();
    protected static final MetadataOperation[] VIEW_ALL_OPERATIONS = new MetadataOperation[]{MetadataOperation.VIEW_ALL};
    protected static final MetadataOperation[] VIEW_BASIC_OPERATIONS = new MetadataOperation[]{MetadataOperation.VIEW_BASIC};

    protected EntityResource(String entityType, Authorizer authorizer) {
        this.entityType = entityType;
        this.repository = Entity.getEntityRepository(entityType);
        this.entityClass = Entity.getEntityClassFromType(entityType);
        this.allowedFields = ((EntityRepository)this.repository).getAllowedFields();
        this.authorizer = authorizer;
        this.addViewOperation("owner,followers,votes,tags,extension,domain,dataProducts,experts", MetadataOperation.VIEW_BASIC);
        Entity.registerResourcePermissions(entityType, this.getEntitySpecificOperations());
    }

    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
    }

    public void upgrade() {
    }

    public final EntityUtil.Fields getFields(String fields) {
        return ((EntityRepository)this.repository).getFields(fields);
    }

    protected T addHref(UriInfo uriInfo, T entity) {
        Entity.withHref(uriInfo, entity.getOwner());
        Entity.withHref(uriInfo, entity.getFollowers());
        Entity.withHref(uriInfo, entity.getExperts());
        Entity.withHref(uriInfo, entity.getReviewers());
        Entity.withHref(uriInfo, entity.getChildren());
        Entity.withHref(uriInfo, entity.getDomain());
        Entity.withHref(uriInfo, entity.getDataProducts());
        return entity;
    }

    protected List<MetadataOperation> getEntitySpecificOperations() {
        return null;
    }

    public final ResultList<T> addHref(UriInfo uriInfo, ResultList<T> list) {
        CommonUtil.listOrEmpty(list.getData()).forEach(i -> this.addHref(uriInfo, i));
        return list;
    }

    public ResultList<T> listInternal(UriInfo uriInfo, SecurityContext securityContext, String fieldsParam, ListFilter filter, int limitParam, String before, String after) {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext listOperationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.listInternal(uriInfo, securityContext, fields, filter, limitParam, before, after, listOperationContext, this.getResourceContext());
    }

    public ResultList<T> listInternal(UriInfo uriInfo, SecurityContext securityContext, EntityUtil.Fields fields, ListFilter filter, int limitParam, String before, String after, OperationContext operationContext, ResourceContextInterface resourceContext) {
        RestUtil.validateCursors(before, after);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        ResultList resultList = before != null ? ((EntityRepository)this.repository).listBefore(uriInfo, fields, filter, limitParam, before) : ((EntityRepository)this.repository).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, resultList);
    }

    public ResultList<T> listInternalFromSearch(UriInfo uriInfo, SecurityContext securityContext, EntityUtil.Fields fields, SearchListFilter searchListFilter, int limit, int offset, SearchSortFilter searchSortFilter, String q, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((EntityRepository)this.repository).listFromSearchWithOffset(uriInfo, fields, searchListFilter, limit, offset, searchSortFilter, q);
    }

    public T getInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, String fieldsParam, Include include) {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.getInternal(uriInfo, securityContext, id, fields, include, operationContext, this.getResourceContextById(id));
    }

    public T getInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, EntityUtil.Fields fields, Include include, OperationContext operationContext, ResourceContextInterface resourceContext) {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.addHref(uriInfo, ((EntityRepository)this.repository).get(uriInfo, id, fields, include, false));
    }

    public T getVersionInternal(SecurityContext securityContext, UUID id, String version) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_BASIC);
        return this.getVersionInternal(securityContext, id, version, operationContext, this.getResourceContextById(id));
    }

    public T getVersionInternal(SecurityContext securityContext, UUID id, String version, OperationContext operationContext, ResourceContextInterface resourceContext) {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((EntityRepository)this.repository).getVersion(id, version);
    }

    protected EntityHistory listVersionsInternal(SecurityContext securityContext, UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_BASIC);
        return this.listVersionsInternal(securityContext, id, operationContext, this.getResourceContextById(id));
    }

    protected EntityHistory listVersionsInternal(SecurityContext securityContext, UUID id, OperationContext operationContext, ResourceContextInterface resourceContext) {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((EntityRepository)this.repository).listVersions(id);
    }

    public T getByNameInternal(UriInfo uriInfo, SecurityContext securityContext, String name, String fieldsParam, Include include) {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.getByNameInternal(uriInfo, securityContext, name, fields, include, operationContext, this.getResourceContextByName(name));
    }

    public T getByNameInternal(UriInfo uriInfo, SecurityContext securityContext, String name, EntityUtil.Fields fields, Include include, OperationContext operationContext, ResourceContextInterface resourceContext) {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.addHref(uriInfo, ((EntityRepository)this.repository).getByName(uriInfo, name, fields, include, false));
    }

    public Response create(UriInfo uriInfo, SecurityContext securityContext, T entity) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        CreateResourceContext<T> createResourceContext = new CreateResourceContext<T>(this.entityType, entity);
        this.authorizer.authorize(securityContext, operationContext, createResourceContext);
        entity = this.addHref(uriInfo, ((EntityRepository)this.repository).create(uriInfo, entity));
        return Response.created((URI)entity.getHref()).entity(entity).build();
    }

    public Response createOrUpdate(UriInfo uriInfo, SecurityContext securityContext, T entity) {
        ((EntityRepository)this.repository).prepareInternal(entity, true);
        ResourceContext<T> resourceContext = this.getResourceContextByName(entity.getFullyQualifiedName());
        MetadataOperation operation = EntityUtil.createOrUpdateOperation(resourceContext);
        OperationContext operationContext = new OperationContext(this.entityType, operation);
        if (operation == MetadataOperation.CREATE) {
            CreateResourceContext<T> createResourceContext = new CreateResourceContext<T>(this.entityType, entity);
            this.authorizer.authorize(securityContext, operationContext, createResourceContext);
            entity = this.addHref(uriInfo, ((EntityRepository)this.repository).create(uriInfo, entity));
            return new RestUtil.PutResponse<T>(Response.Status.CREATED, entity, EventType.ENTITY_CREATED).toResponse();
        }
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        RestUtil.PutResponse<T> response = ((EntityRepository)this.repository).createOrUpdate(uriInfo, entity);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        return response.toResponse();
    }

    public Response patchInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, JsonPatch patch) {
        OperationContext operationContext = new OperationContext(this.entityType, patch);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.PatchResponse response = ((EntityRepository)this.repository).patch(uriInfo, id, securityContext.getUserPrincipal().getName(), patch);
        this.addHref(uriInfo, (EntityInterface)response.entity());
        return response.toResponse();
    }

    public Response delete(UriInfo uriInfo, SecurityContext securityContext, UUID id, boolean recursive, boolean hardDelete) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.DeleteResponse<UUID> response = ((EntityRepository)this.repository).delete(securityContext.getUserPrincipal().getName(), (UUID)id, recursive, hardDelete);
        ((EntityRepository)this.repository).deleteFromSearch((EntityInterface)((EntityInterface)response.entity()), response.changeType());
        this.addHref(uriInfo, (EntityInterface)response.entity());
        return response.toResponse();
    }

    public Response deleteByName(UriInfo uriInfo, SecurityContext securityContext, String name, boolean recursive, boolean hardDelete) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        RestUtil.DeleteResponse response = ((EntityRepository)this.repository).deleteByName(securityContext.getUserPrincipal().getName(), name, recursive, hardDelete);
        ((EntityRepository)this.repository).deleteFromSearch((EntityInterface)((EntityInterface)response.entity()), response.changeType());
        this.addHref(uriInfo, (EntityInterface)response.entity());
        return response.toResponse();
    }

    public Response restoreEntity(UriInfo uriInfo, SecurityContext securityContext, UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.PutResponse response = ((EntityRepository)this.repository).restoreEntity(securityContext.getUserPrincipal().getName(), this.entityType, id);
        ((EntityRepository)this.repository).restoreFromSearch((EntityInterface)((EntityInterface)response.getEntity()));
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        LOG.info("Restored {}:{}", (Object)Entity.getEntityTypeFromObject(response.getEntity()), (Object)((EntityInterface)response.getEntity()).getId());
        return response.toResponse();
    }

    public String exportCsvInternal(SecurityContext securityContext, String name) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        return ((EntityRepository)this.repository).exportToCsv(name, securityContext.getUserPrincipal().getName());
    }

    protected CsvImportResult importCsvInternal(SecurityContext securityContext, String name, String csv, boolean dryRun) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        return ((EntityRepository)this.repository).importFromCsv(name, csv, dryRun, securityContext.getUserPrincipal().getName());
    }

    protected ResourceContext<T> getResourceContext() {
        return new ResourceContext(this.entityType);
    }

    protected ResourceContext<T> getResourceContextById(UUID id) {
        return new ResourceContext(this.entityType, id, null);
    }

    protected ResourceContext<T> getResourceContextByName(String name) {
        return new ResourceContext(this.entityType, null, name);
    }

    private MetadataOperation[] getViewOperations(EntityUtil.Fields fields) {
        if (fields.getFieldList().isEmpty()) {
            return VIEW_BASIC_OPERATIONS;
        }
        TreeSet<MetadataOperation> viewOperations = new TreeSet<MetadataOperation>();
        for (String field : fields.getFieldList()) {
            MetadataOperation operation = this.fieldsToViewOperations.get(field);
            if (operation == null) {
                return VIEW_ALL_OPERATIONS;
            }
            viewOperations.add(operation);
        }
        return viewOperations.toArray(new MetadataOperation[0]);
    }

    protected EntityReference getEntityReference(String entityType, String fqn) {
        return EntityUtil.getEntityReference(entityType, fqn);
    }

    protected static List<EntityReference> getEntityReferences(String entityType, List<String> fqns) {
        if (CommonUtil.nullOrEmpty(fqns)) {
            return null;
        }
        return EntityUtil.getEntityReferences(entityType, fqns);
    }

    protected void addViewOperation(String fieldsParam, MetadataOperation operation) {
        String[] fields;
        for (String field : fields = fieldsParam.replace(" ", "").split(",")) {
            if (this.allowedFields.contains(field)) {
                this.fieldsToViewOperations.put(field, operation);
                continue;
            }
            if ("owner,followers,votes,tags,extension,domain,dataProducts,experts".contains(field)) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
        }
    }

    public K getRepository() {
        return this.repository;
    }
}

