/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.databases;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.ColumnConstraint;
import org.openmetadata.schema.type.ColumnDataType;
import org.openmetadata.schema.type.PartitionColumnDetails;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TablePartition;
import org.openmetadata.schema.type.TableType;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static boolean validateSinglePrimaryColumn(List<Column> columns) {
        int primaryKeyColumns = 0;
        for (Column c : columns) {
            if (c.getConstraint() != ColumnConstraint.PRIMARY_KEY || ++primaryKeyColumns <= 1) continue;
            throw new IllegalArgumentException("Multiple columns tagged with primary key constraints");
        }
        return primaryKeyColumns == 1;
    }

    public static void validateConstraints(List<Column> columns, List<TableConstraint> tableConstraints) {
        boolean primaryColumnExists = DatabaseUtil.validateSinglePrimaryColumn(columns);
        if (tableConstraints == null) {
            return;
        }
        ArrayList columnNames = new ArrayList();
        columns.forEach(c -> columnNames.add(c.getName()));
        for (TableConstraint t : tableConstraints) {
            if (t.getConstraintType() == TableConstraint.ConstraintType.PRIMARY_KEY && primaryColumnExists) {
                throw new IllegalArgumentException("A column already tagged as a primary key and table constraint also includes primary key");
            }
            for (String columnName : t.getColumns()) {
                if (columnNames.contains(columnName)) continue;
                throw new IllegalArgumentException("Invalid column name found in table constraint");
            }
        }
    }

    public static void validateTablePartition(List<Column> columns, TablePartition tablePartition) {
        if (tablePartition == null || CommonUtil.nullOrEmpty((List)tablePartition.getColumns())) {
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        columns.forEach(c -> columnNames.add(c.getName()));
        columnNames.add("_PARTITIONDATE");
        columnNames.add("_PARTITIONTIME");
        for (PartitionColumnDetails partitionColumnDetails : tablePartition.getColumns()) {
            if (columnNames.contains(partitionColumnDetails.getColumnName())) continue;
            throw new IllegalArgumentException("Invalid column name found in table partition");
        }
    }

    public static void validateViewDefinition(TableType tableType, String viewDefinition) {
        if ((tableType == null || tableType.equals((Object)TableType.Regular) || tableType.equals((Object)TableType.External)) && viewDefinition != null && !viewDefinition.isEmpty()) {
            throw new IllegalArgumentException("ViewDefinition can only be set on TableType View, SecureView or MaterializedView");
        }
    }

    public static void validateColumns(List<Column> columns) {
        DatabaseUtil.validateColumnNames(columns);
        for (Column c : columns) {
            DatabaseUtil.validateColumnDataTypeDisplay(c);
            DatabaseUtil.validateColumnDataLength(c);
            DatabaseUtil.validateArrayColumn(c);
            DatabaseUtil.validateStructColumn(c);
            DatabaseUtil.validatePrecisionAndScale(c);
        }
    }

    public static void validateColumnNames(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column c : columns) {
            if (columnNames.contains(c.getName())) {
                throw new IllegalArgumentException(String.format("Column name %s is repeated", c.getName()));
            }
            columnNames.add(c.getName());
        }
    }

    public static void validateColumnDataTypeDisplay(Column column) {
        if (column.getDataTypeDisplay() == null) {
            column.setDataTypeDisplay(column.getDataType().value().toLowerCase(Locale.ROOT));
        }
        String dataTypeDisplay = column.getDataTypeDisplay().toLowerCase(Locale.ROOT);
        column.setDataTypeDisplay(dataTypeDisplay);
    }

    public static void validateColumnDataLength(Column column) {
        ColumnDataType dataType = column.getDataType();
        if ((dataType == ColumnDataType.CHAR || dataType == ColumnDataType.VARCHAR || dataType == ColumnDataType.BINARY || dataType == ColumnDataType.VARBINARY) && column.getDataLength() == null) {
            throw new IllegalArgumentException("For column data types char, varchar, binary, varbinary dataLength must not be null");
        }
    }

    public static void validateArrayColumn(Column column) {
        ColumnDataType dataType = column.getDataType();
        if (column.getArrayDataType() != null && dataType != ColumnDataType.ARRAY) {
            column.setArrayDataType(null);
        }
        if (dataType == ColumnDataType.ARRAY && column.getArrayDataType() == null) {
            throw new IllegalArgumentException("For column data type array, arrayDataType must not be null");
        }
    }

    public static void validateStructColumn(Column column) {
        ColumnDataType dataType = column.getDataType();
        if (dataType == ColumnDataType.STRUCT) {
            if (column.getChildren() == null) {
                throw new IllegalArgumentException("For column data type struct, children must not be null");
            }
            DatabaseUtil.validateColumnNames(column.getChildren());
        }
    }

    public static void validatePrecisionAndScale(Column column) {
        if (column.getScale() == null && column.getPrecision() == null) {
            return;
        }
        if (column.getScale() != null) {
            if (column.getPrecision() == null) {
                throw new IllegalArgumentException("Scale is set but precision is not set for the column " + column.getName());
            }
            if (column.getScale() > column.getPrecision()) {
                throw new IllegalArgumentException("Scale can't be greater than the precision for the column " + column.getName());
            }
        }
    }
}

