/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.classification.CreateTag;
import org.openmetadata.schema.api.classification.LoadTags;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.ClassificationRepository;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TagRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.tags.ClassificationResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/tags")
@Tag(name="Classifications", description="These APIs are related to `Classification` and `Tags`. A `Classification` entity contains hierarchical terms called `Tags` used for categorizing and classifying data assets and other entities.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="tags", order=5)
public class TagResource
extends EntityResource<org.openmetadata.schema.entity.classification.Tag, TagRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TagResource.class);
    public static final String TAG_COLLECTION_PATH = "/v1/tags/";
    static final String FIELDS = "children,usageCount";

    public TagResource(Authorizer authorizer) {
        super("tag", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation(FIELDS, MetadataOperation.VIEW_BASIC);
        return null;
    }

    private void migrateTags() {
        if (((TagRepository)this.repository).getDaoCollection().relationshipDAO().findIfAnyRelationExist("classification", "tag") <= 0) {
            ClassificationRepository classificationRepository = (ClassificationRepository)Entity.getEntityRepository("classification");
            try {
                List classificationList = classificationRepository.listAll(classificationRepository.getFields("*"), new ListFilter(Include.ALL));
                List<String> jsons = ((TagRepository)this.repository).getDao().listAfter(new ListFilter(Include.ALL), Integer.MAX_VALUE, "");
                List<org.openmetadata.schema.entity.classification.Tag> storedTags = JsonUtils.readObjects(jsons, org.openmetadata.schema.entity.classification.Tag.class);
                block6: for (org.openmetadata.schema.entity.classification.Tag tag : storedTags) {
                    if (!tag.getFullyQualifiedName().contains(".")) continue;
                    String[] tokens = tag.getFullyQualifiedName().split("\\.", 2);
                    String classificationName = tokens[0];
                    String remainingPart = tokens[1];
                    for (Classification classification : classificationList) {
                        if (!classification.getName().equals(classificationName)) continue;
                        try {
                            ((TagRepository)this.repository).addRelationship(classification.getId(), tag.getId(), "classification", "tag", Relationship.CONTAINS);
                            break;
                        }
                        catch (Exception ex) {
                            LOG.info("Classification Relation already exists");
                        }
                    }
                    if (!remainingPart.contains(".")) continue;
                    String parentTagName = tag.getFullyQualifiedName().substring(0, tag.getFullyQualifiedName().lastIndexOf("."));
                    for (org.openmetadata.schema.entity.classification.Tag parentTag : storedTags) {
                        if (!parentTag.getFullyQualifiedName().equals(parentTagName)) continue;
                        try {
                            ((TagRepository)this.repository).addRelationship(parentTag.getId(), tag.getId(), "tag", "tag", Relationship.CONTAINS);
                            continue block6;
                        }
                        catch (Exception ex) {
                            LOG.info("Parent Tag Ownership already exists");
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Failed in Listing all the Stored Tags.");
            }
        }
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        super.initialize(config);
        this.migrateTags();
        ClassificationRepository classificationRepository = (ClassificationRepository)Entity.getEntityRepository("classification");
        List<LoadTags> loadTagsList = EntityRepository.getEntitiesFromSeedData("classification", ".*json/data/tags/.*\\.json$", LoadTags.class);
        for (LoadTags loadTags : loadTagsList) {
            Classification classification = ClassificationResource.getClassification(classificationRepository, loadTags.getCreateClassification(), "admin");
            classificationRepository.initializeEntity(classification);
            ArrayList<org.openmetadata.schema.entity.classification.Tag> tagsToCreate = new ArrayList<org.openmetadata.schema.entity.classification.Tag>();
            for (CreateTag createTag : loadTags.getCreateTags()) {
                createTag.withClassification(classification.getName());
                createTag.withProvider(classification.getProvider());
                org.openmetadata.schema.entity.classification.Tag tag = this.getTag(createTag, "admin");
                ((TagRepository)this.repository).setFullyQualifiedName(tag);
                tagsToCreate.add(tag);
            }
            EntityUtil.sortByFQN(tagsToCreate);
            for (org.openmetadata.schema.entity.classification.Tag tag : tagsToCreate) {
                ((TagRepository)this.repository).initializeEntity(tag);
            }
        }
    }

    @GET
    @Valid
    @Operation(operationId="listTags", summary="List tags", description="Get a list of tags. Use `fields` parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of tags", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagList.class))})})
    public ResultList<org.openmetadata.schema.entity.classification.Tag> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="List tags filtered by children of tag identified by fqn given in `parent` parameter. The fqn can either be classificationName or fqn of a parent tag", schema=@Schema(type="string", example="children,usageCount")) @QueryParam(value="parent") String parent, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter Disabled Classifications", schema=@Schema(type="string", example="children,usageCount")) @QueryParam(value="disabled") @DefaultValue(value="false") Boolean disabled, @Parameter(description="Limit the number tags returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tags before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tags after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)((ListFilter)new ListFilter(include).addQueryParam("parent", parent)).addQueryParam("classification.disabled", disabled);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getTagByID", summary="Get a tag by id", description="Get a tag by `id`.", responses={@ApiResponse(responseCode="200", description="The tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))}), @ApiResponse(responseCode="404", description="Tag for instance {id} is not found")})
    public org.openmetadata.schema.entity.classification.Tag get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the tag", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (org.openmetadata.schema.entity.classification.Tag)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getTagByFQN", summary="Get a tag by fully qualified name", description="Get a tag by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))}), @ApiResponse(responseCode="404", description="Tag for instance {fqn} is not found")})
    public org.openmetadata.schema.entity.classification.Tag getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the tag", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (org.openmetadata.schema.entity.classification.Tag)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTagVersion", summary="List tag versions", description="Get a list of all the versions of a tag identified by `id`", responses={@ApiResponse(responseCode="200", description="List of tag versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the tag", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTagVersion", summary="Get a version of the tags", description="Get a version of the tag by given `id`", responses={@ApiResponse(responseCode="200", description="tags", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))}), @ApiResponse(responseCode="404", description="Tag for instance {id} and version {version} is not found")})
    public org.openmetadata.schema.entity.classification.Tag getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the tag", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="tag version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (org.openmetadata.schema.entity.classification.Tag)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createTag", summary="Create a tag", description="Create a new tag.", responses={@ApiResponse(responseCode="200", description="The tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTag create) {
        org.openmetadata.schema.entity.classification.Tag tag = this.getTag(securityContext, create);
        return this.create(uriInfo, securityContext, tag);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTag", summary="Update a tag", description="Update an existing tag using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the tag", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTag", summary="Create or update a tag", description="Create a new tag, if it does not exist or update an existing tag.", responses={@ApiResponse(responseCode="200", description="The tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTag create) {
        org.openmetadata.schema.entity.classification.Tag tag = this.getTag(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, tag);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTag", summary="Delete a tag by id", description="Delete a tag by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="tag for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the tag", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteTagByName", summary="Delete a tag by fully qualified name", description="Delete a tag by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="tag for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the tag", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restoreTag", summary="Restore a soft deleted tag.", description="Restore a soft deleted tag.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Tag ", content={@Content(mediaType="application/json", schema=@Schema(implementation=org.openmetadata.schema.entity.classification.Tag.class))})})
    public Response restore(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @Override
    public org.openmetadata.schema.entity.classification.Tag addHref(UriInfo uriInfo, org.openmetadata.schema.entity.classification.Tag tag) {
        super.addHref(uriInfo, tag);
        Entity.withHref(uriInfo, tag.getClassification());
        Entity.withHref(uriInfo, tag.getParent());
        return tag;
    }

    private org.openmetadata.schema.entity.classification.Tag getTag(SecurityContext securityContext, CreateTag create) {
        return this.getTag(create, securityContext.getUserPrincipal().getName());
    }

    private org.openmetadata.schema.entity.classification.Tag getTag(CreateTag create, String updateBy) {
        return ((TagRepository)this.repository).copy(new org.openmetadata.schema.entity.classification.Tag(), (CreateEntity)create, updateBy).withStyle(create.getStyle()).withParent(this.getEntityReference("tag", create.getParent())).withClassification(this.getEntityReference("classification", create.getClassification())).withProvider(create.getProvider()).withMutuallyExclusive(create.getMutuallyExclusive());
    }

    static class TagList
    extends ResultList<org.openmetadata.schema.entity.classification.Tag> {
        TagList() {
        }
    }
}

