/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.jdbi3.Filter;

public class SearchListFilter
extends Filter<SearchListFilter> {
    static final String SEARCH_LIST_FILTER_EXCLUDE = "fqnParts,entityType,suggest";

    public SearchListFilter() {
        this(Include.NON_DELETED);
    }

    public SearchListFilter(Include include) {
        this.include = include;
    }

    @Override
    public String getCondition(String entityType) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(this.getIncludeCondition());
        conditions.add(this.getDomainCondition());
        conditions.add(this.getOwnerCondition());
        if (entityType != null) {
            conditions.add(entityType.equals("testCase") ? this.getTestCaseCondition() : null);
            conditions.add(entityType.equals("testSuite") ? this.getTestSuiteCondition() : null);
        }
        String conditionFilter = this.addCondition(conditions);
        String sourceFilter = this.getExcludeIncludeFields();
        return this.buildQueryFilter(conditionFilter, sourceFilter);
    }

    @Override
    protected String addCondition(List<String> conditions) {
        StringBuffer condition = new StringBuffer();
        for (String c : conditions) {
            if (CommonUtil.nullOrEmpty((String)c)) continue;
            if (!CommonUtil.nullOrEmpty((Object)condition)) {
                condition.append(",\n");
            }
            condition.append(c);
        }
        return condition.toString();
    }

    private String getTimestampFilter(String conditionAlias, Long value) {
        return this.getTimestampFilter("timestamp", conditionAlias, value);
    }

    private String getTimestampFilter(String timestampField, String conditionAlias, Long value) {
        return String.format("{\"range\": {\"%s\": {\"%s\": %d}}}", timestampField, conditionAlias, value);
    }

    private String getExcludeIncludeFields() {
        ArrayList<String> conditions = new ArrayList<String>();
        StringBuffer excludeCondition = new StringBuffer();
        excludeCondition.append(SEARCH_LIST_FILTER_EXCLUDE);
        String excludeFields = (String)this.queryParams.get("excludeFields");
        String includeFields = (String)this.queryParams.get("includeFields");
        if (!CommonUtil.nullOrEmpty((Object)excludeCondition)) {
            if (!CommonUtil.nullOrEmpty((String)excludeFields)) {
                excludeCondition.append(",").append(excludeFields);
            }
            String[] excludes = excludeCondition.toString().split(",");
            String excludesStr = Arrays.stream(excludes).collect(Collectors.joining("\",\"", "\"", "\""));
            conditions.add(String.format("\"exclude\": [%s]", excludesStr));
        }
        if (!CommonUtil.nullOrEmpty((String)includeFields)) {
            String[] includes = includeFields.split(",");
            String includesStr = Arrays.stream(includes).collect(Collectors.joining("\",\"", "\"", "\""));
            conditions.add(String.format("\"include\": [%s]", includesStr));
        }
        return String.format("\"_source\": {%s}", this.addCondition(conditions));
    }

    private String getIncludeCondition() {
        String domain = this.getQueryParam("domain");
        if (!CommonUtil.nullOrEmpty((String)domain)) {
            return String.format("{\"term\": {\"domain.fullyQualifiedName\": \"%s\"}}", domain);
        }
        return "";
    }

    private String getDomainCondition() {
        String deleted = "";
        if (this.include != Include.ALL) {
            deleted = String.format("{\"term\": {\"deleted\": \"%s\"}}", this.include == Include.DELETED);
        }
        return deleted;
    }

    private String getOwnerCondition() {
        String owner = this.getQueryParam("owner");
        if (!CommonUtil.nullOrEmpty((String)owner)) {
            return String.format("{\"term\": {\"owner.id\": \"%s\"}}", owner);
        }
        return "";
    }

    private String buildQueryFilter(String conditionFilter, String sourceFilter) {
        String q = (String)this.queryParams.get("q");
        boolean isQEmpty = CommonUtil.nullOrEmpty((String)q);
        if (!conditionFilter.isEmpty()) {
            return String.format("{%s,\"query\": {\"bool\": {\"filter\": [%s]}}}", sourceFilter, conditionFilter);
        }
        if (!isQEmpty) {
            return String.format("{%s}", sourceFilter);
        }
        return String.format("{%s,\"query\": {\"match_all\": {}}}", sourceFilter);
    }

    private String getTestCaseCondition() {
        ArrayList<String> conditions = new ArrayList<String>();
        String entityFQN = this.getQueryParam("entityFQN");
        boolean includeAllTests = Boolean.parseBoolean(this.getQueryParam("includeAllTests"));
        String status = this.getQueryParam("testCaseStatus");
        String testSuiteId = this.getQueryParam("testSuiteId");
        String type = this.getQueryParam("testCaseType");
        String testPlatform = this.getQueryParam("testPlatforms");
        String startTimestamp = this.getQueryParam("startTimestamp");
        String endTimestamp = this.getQueryParam("endTimestamp");
        if (entityFQN != null) {
            conditions.add(includeAllTests ? String.format("{\"prefix\": {\"entityFQN\": \"%s\"}}", this.escapeDoubleQuotes(entityFQN)) : String.format("{\"term\": {\"entityFQN\": \"%s\"}}", this.escapeDoubleQuotes(entityFQN)));
        }
        if (testSuiteId != null) {
            conditions.add(String.format("{\"term\": {\"testSuite.id\": \"%s\"}}", testSuiteId));
        }
        if (status != null) {
            conditions.add(String.format("{\"term\": {\"testCaseResult.testCaseStatus\": \"%s\"}}", status));
        }
        if (type != null) {
            conditions.add(switch (type) {
                case "table" -> "{\"bool\": {\"must_not\": [{\"regexp\": {\"entityLink\": \".*::columns::.*\"}}]}}";
                case "column" -> "{\"regexp\": {\"entityLink\": \".*::columns::.*\"}}";
                default -> "";
            });
        }
        if (testPlatform != null) {
            String platforms = Arrays.stream(testPlatform.split(",")).collect(Collectors.joining("\", \"", "\"", "\""));
            conditions.add(String.format("{\"terms\": {\"testPlatforms\": [%s]}}", platforms));
        }
        if (startTimestamp != null && endTimestamp != null) {
            conditions.add(this.getTimestampFilter("testCaseResult.timestamp", "gte", Long.parseLong(startTimestamp)));
            conditions.add(this.getTimestampFilter("testCaseResult.timestamp", "lte", Long.parseLong(endTimestamp)));
        }
        return this.addCondition(conditions);
    }

    private String getTestSuiteCondition() {
        ArrayList<String> conditions = new ArrayList<String>();
        String testSuiteType = this.getQueryParam("testSuiteType");
        String fullyQualifiedName = this.getQueryParam("fullyQualifiedName");
        Boolean includeEmptyTestSuites = Boolean.parseBoolean(this.getQueryParam("includeEmptyTestSuites"));
        if (testSuiteType != null) {
            Boolean executable = true;
            if (testSuiteType.equals("logical")) {
                executable = false;
            }
            conditions.add(String.format("{\"term\": {\"executable\": \"%s\"}}", executable));
        }
        if (!includeEmptyTestSuites.booleanValue()) {
            conditions.add("{\"exists\": {\"field\": \"tests\"}}");
        }
        if (fullyQualifiedName != null) {
            conditions.add(String.format("{\"term\": {\"fullyQualifiedName\": \"%s\"}}", this.escapeDoubleQuotes(fullyQualifiedName)));
        }
        return this.addCondition(conditions);
    }

    private String escapeDoubleQuotes(String str) {
        return str.replace("\"", "\\\"");
    }
}

