/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record ClassificationIndex(Classification classification) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.classification.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.classification.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.classification);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.classification, "classification");
        doc.putAll(commonAttributes);
        return doc;
    }
}

