/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record DatabaseIndex(Database database) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.database.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.database.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.database);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.database, "database");
        doc.putAll(commonAttributes);
        return doc;
    }
}

