/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record DatabaseSchemaIndex(DatabaseSchema databaseSchema) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.databaseSchema.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.databaseSchema.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.databaseSchema);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.databaseSchema, "databaseSchema");
        doc.putAll(commonAttributes);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        return doc;
    }
}

