/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class GlossaryIndex
implements SearchIndex {
    final Glossary glossary;
    final List<String> excludeFields = List.of("changeDescription");

    public GlossaryIndex(Glossary glossary) {
        this.glossary = glossary;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossary.getName()).weight(5).build());
        if (this.glossary.getDisplayName() != null && !this.glossary.getDisplayName().isEmpty()) {
            suggest.add(SearchSuggest.builder().input(this.glossary.getDisplayName()).weight(10).build());
        }
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.glossary);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.glossary, "glossary");
        doc.putAll(commonAttributes);
        return doc;
    }
}

