/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class GlossaryTermIndex
implements SearchIndex {
    final GlossaryTerm glossaryTerm;
    final List<String> excludeFields = List.of("changeDescription");

    public GlossaryTermIndex(GlossaryTerm glossaryTerm) {
        this.glossaryTerm = glossaryTerm;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getName()).weight(5).build());
        if (this.glossaryTerm.getDisplayName() != null && !this.glossaryTerm.getDisplayName().isEmpty()) {
            suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getDisplayName()).weight(10).build());
        }
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.glossaryTerm);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.glossaryTerm, "glossaryTerm");
        doc.putAll(commonAttributes);
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("synonyms", Float.valueOf(5.0f));
        fields.put("synonyms.ngram", Float.valueOf(1.0f));
        fields.put("glossary.name", Float.valueOf(5.0f));
        fields.put("glossary.displayName", Float.valueOf(5.0f));
        return fields;
    }
}

