/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record PipelineServiceIndex(PipelineService pipelineService) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.pipelineService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.pipelineService.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.pipelineService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.pipelineService, "pipelineService");
        doc.putAll(commonAttributes);
        return doc;
    }
}

