/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ColumnIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.FlattenColumn;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record TableIndex(Table table) implements ColumnIndex
{
    private static final List<String> excludeFields = List.of("sampleData", "tableProfile", "joins", "changeDescription", "viewDefinition, tableProfilerConfig, profile, location, tableQueries, tests, dataModel");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.table.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.table.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.table.getDatabase().getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.table.getDatabaseSchema().getName()).weight(5).build());
        String[] fqnPartsWithoutService = this.table.getFullyQualifiedName().split(Pattern.quote("."), 2);
        if (fqnPartsWithoutService.length == 2) {
            suggest.add(SearchSuggest.builder().input(fqnPartsWithoutService[1]).weight(5).build());
            String[] fqnPartsWithoutDB = fqnPartsWithoutService[1].split(Pattern.quote("."), 2);
            if (fqnPartsWithoutDB.length == 2) {
                suggest.add(SearchSuggest.builder().input(fqnPartsWithoutDB[1]).weight(5).build());
            }
        }
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.table);
        ArrayList<SearchSuggest> columnSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> schemaSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> databaseSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        HashSet<List<TagLabel>> tagsWithChildren = new HashSet<List<TagLabel>>();
        ArrayList<String> columnsWithChildrenName = new ArrayList<String>();
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        if (doc.get("testSuite") != null) {
            ((Map)doc.get("testSuite")).remove("changeDescription");
        }
        if (this.table.getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.table.getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(SearchSuggest.builder().input(col.getName()).weight(5).build());
                columnsWithChildrenName.add(col.getName());
                if (col.getTags() == null) continue;
                tagsWithChildren.add(col.getTags());
            }
            doc.put("columnNames", columnsWithChildrenName);
        }
        serviceSuggest.add(SearchSuggest.builder().input(this.table.getService().getName()).weight(5).build());
        databaseSuggest.add(SearchSuggest.builder().input(this.table.getDatabase().getName()).weight(5).build());
        schemaSuggest.add(SearchSuggest.builder().input(this.table.getDatabaseSchema().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("table", (EntityInterface)this.table));
        tagsWithChildren.add(parseTags.getTags());
        List flattenedTagList = tagsWithChildren.stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.table, "table");
        doc.putAll(commonAttributes);
        doc.put("displayName", this.table.getDisplayName() != null ? this.table.getDisplayName() : this.table.getName());
        doc.put("tags", flattenedTagList);
        doc.put("tier", parseTags.getTierTag());
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("schema_suggest", schemaSuggest);
        doc.put("database_suggest", databaseSuggest);
        doc.put("serviceType", this.table.getServiceType());
        doc.put("service", this.getEntityWithDisplayName(this.table.getService()));
        doc.put("database", this.getEntityWithDisplayName(this.table.getDatabase()));
        doc.put("lineage", SearchIndex.getLineageData(this.table.getEntityReference()));
        doc.put("databaseSchema", this.getEntityWithDisplayName(this.table.getDatabaseSchema()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("columns.name.keyword", Float.valueOf(5.0f));
        fields.put("columns.name", Float.valueOf(7.0f));
        fields.put("columns.displayName", Float.valueOf(7.0f));
        fields.put("columns.description", Float.valueOf(2.0f));
        fields.put("columns.children.name", Float.valueOf(7.0f));
        return fields;
    }
}

