/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record TagIndex(Tag tag) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.tag.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.tag.getName()).weight(10).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.tag);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.tag, "tag");
        doc.putAll(commonAttributes);
        if (this.tag.getDisabled() != null && this.tag.getDisabled().booleanValue()) {
            doc.put("disabled", this.tag.getDisabled());
        } else {
            doc.put("disabled", "false");
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("classification.name", Float.valueOf(7.0f));
        return fields;
    }
}

