/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class UserIndex
implements SearchIndex {
    final User user;
    final List<String> excludeFields = List.of("owns", "changeDescription", "follows", "authenticationMechanism");

    public UserIndex(User user) {
        this.user = user;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.user.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.user.getDisplayName()).weight(10).build());
        return suggest;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.user);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.user, "user");
        doc.putAll(commonAttributes);
        doc.put("displayName", CommonUtil.nullOrEmpty((String)this.user.getDisplayName()) ? this.user.getName() : this.user.getDisplayName());
        if (this.user.getIsBot() == null) {
            doc.put("isBot", false);
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

