/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.security.ssl.ValidateSSLClientConfig;
import org.openmetadata.schema.services.connections.database.DorisConnection;
import org.openmetadata.schema.services.connections.database.common.IamAuthConfig;
import org.openmetadata.schema.services.connections.database.common.basicAuth;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class DorisConnectionClassConverter
extends ClassConverter {
    private static final List<Class<?>> CONFIG_SOURCE_CLASSES = List.of(basicAuth.class, IamAuthConfig.class);
    private static final List<Class<?>> SSL_SOURCE_CLASS = List.of(ValidateSSLClientConfig.class);

    public DorisConnectionClassConverter() {
        super(DorisConnection.class);
    }

    @Override
    public Object convert(Object object) {
        DorisConnection dorisConnection = (DorisConnection)JsonUtils.convertValue(object, this.clazz);
        this.tryToConvert(dorisConnection.getSslConfig(), SSL_SOURCE_CLASS).ifPresent(obj -> dorisConnection.setSslConfig((Object)((ValidateSSLClientConfig)obj)));
        return dorisConnection;
    }
}

