/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class Utilities {
    private Utilities() {
    }

    public static List<String> getLastSevenDays(long currentEpochTimestampInMilli) {
        ArrayList<String> lastSevenDays = new ArrayList<String>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d");
        for (int i = 6; i >= 0; --i) {
            long dayEpochTimestamp = currentEpochTimestampInMilli - (long)i * 24L * 60L * 60L * 1000L;
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(dayEpochTimestamp), ZoneId.systemDefault());
            lastSevenDays.add(dateTime.format(formatter));
        }
        return lastSevenDays;
    }

    public static String getMonthAndDateFromEpoch(long epochTimestamp) {
        return Utilities.getFormattedDateFromEpoch(epochTimestamp, "MMM d");
    }

    public static String getDateFromEpoch(long epochTimestampInMilli) {
        return Utilities.getFormattedDateFromEpoch(epochTimestampInMilli, "d");
    }

    private static String getFormattedDateFromEpoch(long epochTimestamp, String format) {
        Instant instant = Instant.ofEpochMilli(epochTimestamp);
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(format);
        return dateTime.format(dateFormat);
    }
}

