/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled;

import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.EventSubscriptionOffset;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.changeEvent.AlertPublisher;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriptionScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(EventSubscriptionScheduler.class);
    public static final String ALERT_JOB_GROUP = "OMAlertJobGroup";
    public static final String ALERT_TRIGGER_GROUP = "OMAlertJobGroup";
    private static EventSubscriptionScheduler instance;
    private static volatile boolean initialized;
    private final Scheduler alertsScheduler = new StdSchedulerFactory().getScheduler();

    private EventSubscriptionScheduler() throws SchedulerException {
        this.alertsScheduler.start();
    }

    public static EventSubscriptionScheduler getInstance() {
        if (!initialized) {
            EventSubscriptionScheduler.initialize();
        }
        return instance;
    }

    private static void initialize() throws SchedulerException {
        if (!initialized) {
            instance = new EventSubscriptionScheduler();
            initialized = true;
        } else {
            LOG.info("Event Subscription Scheduler is already initialized");
        }
    }

    @Transaction
    public void addSubscriptionPublisher(EventSubscription eventSubscription) throws SchedulerException {
        AlertPublisher alertPublisher = new AlertPublisher();
        if (Boolean.FALSE.equals(eventSubscription.getEnabled())) {
            eventSubscription.getDestinations().forEach(sub -> sub.setStatusDetails(this.getSubscriptionStatusAtCurrentTime(SubscriptionStatus.Status.DISABLED)));
            LOG.info("Event Subscription started as {} : status {} for all Destinations", (Object)eventSubscription.getName(), (Object)SubscriptionStatus.Status.ACTIVE);
        } else {
            eventSubscription.getDestinations().forEach(sub -> sub.setStatusDetails(this.getSubscriptionStatusAtCurrentTime(SubscriptionStatus.Status.ACTIVE)));
            JobDetail jobDetail = this.jobBuilder(alertPublisher, eventSubscription, String.format("%s", eventSubscription.getId().toString()));
            Trigger trigger = this.trigger(eventSubscription);
            this.alertsScheduler.scheduleJob(jobDetail, trigger);
            LOG.info("Event Subscription started as {} : status {} for all Destinations", (Object)eventSubscription.getName(), (Object)SubscriptionStatus.Status.ACTIVE);
        }
    }

    private JobDetail jobBuilder(AlertPublisher publisher, EventSubscription eventSubscription, String jobIdentity) {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("alertInfoKey", (Object)eventSubscription);
        dataMap.put("alertOffsetKey", (Object)AlertUtil.getStartingOffset(eventSubscription.getId()));
        JobBuilder jobBuilder = JobBuilder.newJob(publisher.getClass()).withIdentity(jobIdentity, "OMAlertJobGroup").usingJobData(dataMap);
        return jobBuilder.build();
    }

    private Trigger trigger(EventSubscription eventSubscription) {
        return TriggerBuilder.newTrigger().withIdentity(eventSubscription.getId().toString(), "OMAlertJobGroup").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)eventSubscription.getPollInterval())).startNow().build();
    }

    private SubscriptionStatus getSubscriptionStatusAtCurrentTime(SubscriptionStatus.Status status) {
        return new SubscriptionStatus().withStatus(status).withTimestamp(Long.valueOf(System.currentTimeMillis()));
    }

    @Transaction
    public void updateEventSubscription(EventSubscription eventSubscription) {
        this.deleteEventSubscriptionPublisher(eventSubscription);
        if (Boolean.TRUE.equals(eventSubscription.getEnabled())) {
            this.addSubscriptionPublisher(eventSubscription);
        }
    }

    @Transaction
    public void deleteEventSubscriptionPublisher(EventSubscription deletedEntity) throws SchedulerException {
        this.alertsScheduler.deleteJob(new JobKey(deletedEntity.getId().toString(), "OMAlertJobGroup"));
        this.alertsScheduler.unscheduleJob(new TriggerKey(deletedEntity.getId().toString(), "OMAlertJobGroup"));
        LOG.info("Alert publisher deleted for {}", (Object)deletedEntity.getName());
    }

    public SubscriptionStatus getStatusForEventSubscription(UUID subscriptionId, UUID destinationId) {
        EventSubscription eventSubscription = this.getEventSubscriptionFromScheduledJob(subscriptionId);
        if (eventSubscription == null) {
            EntityRepository<? extends EntityInterface> subscriptionRepository = Entity.getEntityRepository("eventsubscription");
            EventSubscription subscription = (EventSubscription)subscriptionRepository.get(null, subscriptionId, subscriptionRepository.getFields("id"));
            if (subscription != null && Boolean.FALSE.equals(subscription.getEnabled())) {
                return new SubscriptionStatus().withStatus(SubscriptionStatus.Status.DISABLED);
            }
        } else {
            List<SubscriptionDestination> subscriptions = eventSubscription.getDestinations().stream().filter(sub -> sub.getId().equals(destinationId)).toList();
            if (subscriptions.size() == 1) {
                return subscriptions.get(0).getStatusDetails();
            }
        }
        return null;
    }

    public EventSubscription getEventSubscriptionFromScheduledJob(UUID id) {
        try {
            JobDetail jobDetail = this.alertsScheduler.getJobDetail(new JobKey(id.toString(), "OMAlertJobGroup"));
            if (jobDetail != null) {
                return (EventSubscription)jobDetail.getJobDataMap().get((Object)"alertInfoKey");
            }
        }
        catch (SchedulerException ex) {
            LOG.error("Failed to get Event Subscription from Job, Subscription Id : {}", (Object)id);
        }
        return null;
    }

    public boolean checkIfPublisherPublishedAllEvents(UUID subscriptionID) {
        long countOfEvents = Entity.getCollectionDAO().changeEventDAO().getLatestOffset();
        try {
            EventSubscriptionOffset offset;
            JobDetail jobDetail = this.alertsScheduler.getJobDetail(new JobKey(subscriptionID.toString(), "OMAlertJobGroup"));
            if (jobDetail != null && (offset = (EventSubscriptionOffset)jobDetail.getJobDataMap().get((Object)"alertOffsetKey")) != null) {
                return offset.getOffset() == countOfEvents;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to get Event Subscription from Job, Subscription Id : {}, Exception: ", (Object)subscriptionID.toString(), (Object)ex);
        }
        return false;
    }

    public static void shutDown() throws SchedulerException {
        LOG.info("Shutting Down Event Subscription Scheduler");
        if (instance != null) {
            EventSubscriptionScheduler.instance.alertsScheduler.shutdown(true);
        }
    }

    static {
        initialized = false;
    }
}

