/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import javax.ws.rs.core.Response;
import org.openmetadata.sdk.exception.WebServiceException;

public class SecretsManagerException
extends WebServiceException {
    private static final String BY_NAME_MESSAGE = "SecretsManagerException for secret manager [%s] when using the secret name [%s] due to [%s].";
    public static final String SECRETS_MANAGER_ERROR = "SECRETS_MANAGER_ERROR";

    public SecretsManagerException(String message) {
        super(Response.Status.INTERNAL_SERVER_ERROR, SECRETS_MANAGER_ERROR, message);
    }

    public SecretsManagerException(Response.Status status, String message) {
        super(status.getStatusCode(), SECRETS_MANAGER_ERROR, message);
    }

    public static SecretsManagerException byMessage(String secretManager, String connectionType, String errorMessage) {
        return new SecretsManagerException(SecretsManagerException.buildMessageByName(secretManager, connectionType, errorMessage));
    }

    private static String buildMessageByName(String secretManager, String secretName, String errorMessage) {
        return String.format(BY_NAME_MESSAGE, secretManager, secretName, errorMessage);
    }
}

