/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.schema.entity.feed.DescriptionFeedInfo;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;

public class DescriptionFormatter
extends DefaultFieldFormatter {
    private static final String HEADER_MESSAGE = "%s %s the description for %s %s";

    public DescriptionFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
    }

    @Override
    public String formatAddedField() {
        String message = super.formatAddedField();
        this.populateDescriptionFeedInfo(Thread.FieldOperation.ADDED, message, message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = super.formatUpdatedField();
        this.populateDescriptionFeedInfo(Thread.FieldOperation.UPDATED, message, message);
        return message;
    }

    @Override
    public String formatDeletedField() {
        String message = super.formatDeletedField();
        this.populateDescriptionFeedInfo(Thread.FieldOperation.DELETED, message, message);
        return message;
    }

    private void populateDescriptionFeedInfo(Thread.FieldOperation operation, String threadMessage, String diffMessage) {
        DescriptionFeedInfo descriptionFeedInfo = new DescriptionFeedInfo().withPreviousDescription(this.fieldOldValue).withNewDescription(this.fieldNewValue).withDiffMessage(diffMessage);
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForDescriptionUpdate(operation.value())).withFieldName("description").withEntitySpecificInfo((Object)descriptionFeedInfo);
        DescriptionFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.DESCRIPTION, operation, feedInfo);
    }

    private String getHeaderForDescriptionUpdate(String eventTypeMessage) {
        return String.format(HEADER_MESSAGE, this.thread.getUpdatedBy(), eventTypeMessage, this.thread.getEntityType(), this.thread.getEntityUrlLink());
    }
}

