/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.networknt.schema.JsonSchema;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.feed.Suggestion;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.system.EntityError;
import org.openmetadata.schema.type.ApiStatus;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.schema.type.Votes;
import org.openmetadata.schema.type.api.BulkAssets;
import org.openmetadata.schema.type.api.BulkOperationResult;
import org.openmetadata.schema.type.api.BulkResponse;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.TypeRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.jdbi3.SuggestionRepository;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchListFilter;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.search.SearchSortFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public abstract class EntityRepository<T extends EntityInterface> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRepository.class);
    public static final LoadingCache<Pair<String, String>, EntityInterface> CACHE_WITH_NAME = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build((CacheLoader)new EntityLoaderWithName());
    public static final LoadingCache<Pair<String, UUID>, EntityInterface> CACHE_WITH_ID = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build((CacheLoader)new EntityLoaderWithId());
    private final String collectionPath;
    private final Class<T> entityClass;
    protected final String entityType;
    protected final EntityDAO<T> dao;
    protected final CollectionDAO daoCollection;
    protected final SearchRepository searchRepository;
    protected final Set<String> allowedFields;
    public final boolean supportsSoftDelete;
    protected final boolean supportsTags;
    protected final boolean supportsOwner;
    protected final boolean supportsStyle;
    protected final boolean supportsLifeCycle;
    protected final boolean supportsFollower;
    protected final boolean supportsExtension;
    protected final boolean supportsVotes;
    protected final boolean supportsDomain;
    protected final boolean supportsDataProducts;
    protected final boolean supportsReviewers;
    protected final boolean supportsExperts;
    protected boolean quoteFqn = false;
    protected boolean renameAllowed = false;
    private final EntityUtil.Fields patchFields;
    protected final EntityUtil.Fields putFields;
    protected boolean supportsSearch = false;

    protected EntityRepository(String collectionPath, String entityType, Class<T> entityClass, EntityDAO<T> entityDAO, String patchFields, String putFields) {
        this.collectionPath = collectionPath;
        this.entityClass = entityClass;
        this.allowedFields = Entity.getEntityFields(entityClass);
        this.dao = entityDAO;
        this.daoCollection = Entity.getCollectionDAO();
        this.searchRepository = Entity.getSearchRepository();
        this.entityType = entityType;
        this.patchFields = this.getFields(patchFields);
        this.putFields = this.getFields(putFields);
        this.supportsTags = this.allowedFields.contains("tags");
        if (this.supportsTags) {
            this.patchFields.addField(this.allowedFields, "tags");
            this.putFields.addField(this.allowedFields, "tags");
        }
        this.supportsOwner = this.allowedFields.contains("owner");
        if (this.supportsOwner) {
            this.patchFields.addField(this.allowedFields, "owner");
            this.putFields.addField(this.allowedFields, "owner");
        }
        this.supportsSoftDelete = this.allowedFields.contains("deleted");
        this.supportsFollower = this.allowedFields.contains("followers");
        if (this.supportsFollower) {
            this.patchFields.addField(this.allowedFields, "followers");
            this.putFields.addField(this.allowedFields, "followers");
        }
        this.supportsExtension = this.allowedFields.contains("extension");
        if (this.supportsExtension) {
            this.patchFields.addField(this.allowedFields, "extension");
            this.putFields.addField(this.allowedFields, "extension");
        }
        this.supportsVotes = this.allowedFields.contains("votes");
        if (this.supportsVotes) {
            this.patchFields.addField(this.allowedFields, "votes");
            this.putFields.addField(this.allowedFields, "votes");
        }
        this.supportsDomain = this.allowedFields.contains("domain");
        if (this.supportsDomain) {
            this.patchFields.addField(this.allowedFields, "domain");
            this.putFields.addField(this.allowedFields, "domain");
        }
        this.supportsReviewers = this.allowedFields.contains("reviewers");
        if (this.supportsReviewers) {
            this.patchFields.addField(this.allowedFields, "reviewers");
            this.putFields.addField(this.allowedFields, "reviewers");
        }
        this.supportsExperts = this.allowedFields.contains("experts");
        if (this.supportsExperts) {
            this.patchFields.addField(this.allowedFields, "experts");
            this.putFields.addField(this.allowedFields, "experts");
        }
        this.supportsDataProducts = this.allowedFields.contains("dataProducts");
        if (this.supportsDataProducts) {
            this.patchFields.addField(this.allowedFields, "dataProducts");
            this.putFields.addField(this.allowedFields, "dataProducts");
        }
        this.supportsStyle = this.allowedFields.contains("style");
        if (this.supportsStyle) {
            this.patchFields.addField(this.allowedFields, "style");
            this.putFields.addField(this.allowedFields, "style");
        }
        this.supportsLifeCycle = this.allowedFields.contains("lifeCycle");
        if (this.supportsLifeCycle) {
            this.patchFields.addField(this.allowedFields, "lifeCycle");
            this.putFields.addField(this.allowedFields, "lifeCycle");
        }
        Entity.registerEntity(entityClass, entityType, this);
    }

    protected abstract void setFields(T var1, EntityUtil.Fields var2);

    protected abstract void clearFields(T var1, EntityUtil.Fields var2);

    protected abstract void prepare(T var1, boolean var2);

    protected abstract void storeEntity(T var1, boolean var2);

    protected abstract void storeRelationships(T var1);

    protected void setInheritedFields(T entity, EntityUtil.Fields fields) {
        EntityInterface parent;
        EntityInterface entityInterface = parent = this.supportsDomain ? this.getParentEntity(entity, "domain") : null;
        if (parent != null) {
            this.inheritDomain(entity, fields, parent);
        }
    }

    protected final void addServiceRelationship(T entity, EntityReference service) {
        if (service != null) {
            this.addRelationship(service.getId(), entity.getId(), service.getType(), this.entityType, Relationship.CONTAINS);
        }
    }

    protected void restorePatchAttributes(T original, T updated) {
        updated.setId(original.getId());
        updated.setName(this.renameAllowed ? updated.getName() : original.getName());
        updated.setFullyQualifiedName(original.getFullyQualifiedName());
        updated.setChangeDescription(original.getChangeDescription());
    }

    public void setFullyQualifiedName(T entity) {
        entity.setFullyQualifiedName(EntityInterfaceUtil.quoteName((String)entity.getName()));
    }

    public final void initSeedDataFromResources() throws IOException {
        List<T> entities = this.getEntitiesFromSeedData();
        for (EntityInterface entity : entities) {
            this.initializeEntity(entity);
        }
    }

    public final List<T> getEntitiesFromSeedData() throws IOException {
        return this.getEntitiesFromSeedData(String.format(".*json/data/%s/.*\\.json$", this.entityType));
    }

    public final List<T> getEntitiesFromSeedData(String path) throws IOException {
        return EntityRepository.getEntitiesFromSeedData(this.entityType, path, this.entityClass);
    }

    public static <U> List<U> getEntitiesFromSeedData(String entityType, String path, Class<U> clazz) throws IOException {
        ArrayList entities = new ArrayList();
        List<String> jsonDataFiles = EntityUtil.getJsonDataResources(path);
        jsonDataFiles.forEach(jsonDataFile -> {
            try {
                String json = CommonUtil.getResourceAsStream((ClassLoader)EntityRepository.class.getClassLoader(), (String)jsonDataFile);
                json = json.replace("<separator>", ".");
                entities.add(JsonUtils.readValue(json, clazz));
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the {} from file {}", new Object[]{entityType, jsonDataFile, e});
            }
        });
        return entities;
    }

    @Transaction
    public final void initializeEntity(T entity) {
        T existingEntity = this.findByNameOrNull(entity.getFullyQualifiedName(), Include.ALL);
        if (existingEntity != null) {
            LOG.debug("{} {} is already initialized", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
            return;
        }
        LOG.debug("{} {} is not initialized", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
        entity.setUpdatedBy("admin");
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        entity.setId(UUID.randomUUID());
        this.create(null, entity);
        LOG.debug("Created a new {} {}", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
    }

    public final T copy(T entity, CreateEntity request, String updatedBy) {
        EntityReference owner = this.validateOwner(request.getOwner());
        EntityReference domain = this.validateDomain(request.getDomain());
        entity.setId(UUID.randomUUID());
        entity.setName(request.getName());
        entity.setDisplayName(request.getDisplayName());
        entity.setDescription(request.getDescription());
        entity.setOwner(owner);
        entity.setDomain(domain);
        entity.setTags(request.getTags());
        entity.setDataProducts(EntityUtil.getEntityReferences("dataProduct", request.getDataProducts()));
        entity.setLifeCycle(request.getLifeCycle());
        entity.setExtension(request.getExtension());
        entity.setUpdatedBy(updatedBy);
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    protected EntityUpdater getUpdater(T original, T updated, Operation operation) {
        return new EntityUpdater(this, original, updated, operation);
    }

    public final T get(UriInfo uriInfo, UUID id, EntityUtil.Fields fields) {
        return this.get(uriInfo, id, fields, Include.NON_DELETED, false);
    }

    public final T get(UriInfo uriInfo, UUID id, EntityUtil.Fields fields, Include include, boolean fromCache) {
        if (!fromCache) {
            CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)this.entityType, (Object)id));
        }
        T entity = this.find(id, include);
        this.setFieldsInternal(entity, fields);
        this.setInheritedFields(entity, fields);
        EntityInterface entityClone = (EntityInterface)JsonUtils.deepCopy(entity, this.entityClass);
        this.clearFieldsInternal(entityClone, fields);
        return (T)this.withHref(uriInfo, entityClone);
    }

    public final EntityReference getReference(UUID id, Include include) throws EntityNotFoundException {
        return this.find(id, include).getEntityReference();
    }

    public final T find(UUID id, Include include) throws EntityNotFoundException {
        try {
            EntityInterface entity = (EntityInterface)CACHE_WITH_ID.get((Object)new ImmutablePair((Object)this.entityType, (Object)id));
            if (include == Include.NON_DELETED && Boolean.TRUE.equals(entity.getDeleted()) || include == Include.DELETED && !Boolean.TRUE.equals(entity.getDeleted())) {
                throw new EntityNotFoundException(CatalogExceptionMessage.entityNotFound(this.entityType, id));
            }
            return (T)entity;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new EntityNotFoundException(CatalogExceptionMessage.entityNotFound(this.entityType, id));
        }
    }

    public T getByName(UriInfo uriInfo, String fqn, EntityUtil.Fields fields) {
        return this.getByName(uriInfo, fqn, fields, Include.NON_DELETED, false);
    }

    public final T getByName(UriInfo uriInfo, String fqn, EntityUtil.Fields fields, Include include, boolean fromCache) {
        String string = fqn = this.quoteFqn ? EntityInterfaceUtil.quoteName((String)fqn) : fqn;
        if (!fromCache) {
            CACHE_WITH_NAME.invalidate((Object)new ImmutablePair((Object)this.entityType, (Object)fqn));
        }
        T entity = this.findByName(fqn, include);
        this.setFieldsInternal(entity, fields);
        this.setInheritedFields(entity, fields);
        EntityInterface entityClone = (EntityInterface)JsonUtils.deepCopy(entity, this.entityClass);
        this.clearFieldsInternal(entityClone, fields);
        return (T)this.withHref(uriInfo, entityClone);
    }

    public final EntityReference getReferenceByName(String fqn, Include include) {
        fqn = this.quoteFqn ? EntityInterfaceUtil.quoteName((String)fqn) : fqn;
        return this.findByName(fqn, include).getEntityReference();
    }

    public final T findByNameOrNull(String fqn, Include include) {
        try {
            return this.findByName(fqn, include);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public final T findByName(String fqn, Include include) {
        fqn = this.quoteFqn ? EntityInterfaceUtil.quoteName((String)fqn) : fqn;
        try {
            EntityInterface entity = (EntityInterface)CACHE_WITH_NAME.get((Object)new ImmutablePair((Object)this.entityType, (Object)fqn));
            if (include == Include.NON_DELETED && Boolean.TRUE.equals(entity.getDeleted()) || include == Include.DELETED && !Boolean.TRUE.equals(entity.getDeleted())) {
                throw new EntityNotFoundException(CatalogExceptionMessage.entityNotFound(this.entityType, fqn));
            }
            return (T)entity;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new EntityNotFoundException(CatalogExceptionMessage.entityNotFound(this.entityType, fqn));
        }
    }

    public final List<T> listAll(EntityUtil.Fields fields, ListFilter filter) {
        List<String> jsons = this.dao.listAfter(filter, Integer.MAX_VALUE, "");
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        for (String json : jsons) {
            EntityInterface entity = this.setFieldsInternal((EntityInterface)JsonUtils.readValue(json, this.entityClass), fields);
            this.setInheritedFields(entity, fields);
            this.clearFieldsInternal(entity, fields);
            entities.add(entity);
        }
        return entities;
    }

    public ResultList<T> listAfter(UriInfo uriInfo, EntityUtil.Fields fields, ListFilter filter, int limitParam, String after) {
        int total = this.dao.listCount(filter);
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        if (limitParam > 0) {
            String beforeCursor;
            List<String> jsons = this.dao.listAfter(filter, limitParam + 1, after == null ? "" : RestUtil.decodeCursor(after));
            for (String json : jsons) {
                EntityInterface entity = this.setFieldsInternal((EntityInterface)JsonUtils.readValue(json, this.entityClass), fields);
                this.setInheritedFields(entity, fields);
                this.clearFieldsInternal(entity, fields);
                entities.add(this.withHref(uriInfo, entity));
            }
            String afterCursor = null;
            String string = beforeCursor = after == null ? null : ((EntityInterface)entities.get(0)).getName();
            if (entities.size() > limitParam) {
                entities.remove(limitParam);
                afterCursor = ((EntityInterface)entities.get(limitParam - 1)).getName();
            }
            return this.getResultList(entities, beforeCursor, afterCursor, total);
        }
        return this.getResultList(entities, null, null, total);
    }

    public final ResultList<T> listAfterWithSkipFailure(UriInfo uriInfo, EntityUtil.Fields fields, ListFilter filter, int limitParam, String after) {
        int beforeOffset;
        ArrayList<EntityError> errors = new ArrayList<EntityError>();
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        int currentOffset = beforeOffset = Integer.parseInt(RestUtil.decodeCursor(after));
        int total = this.dao.listCount(filter);
        if (limitParam > 0) {
            List<String> jsons = this.dao.listAfterWithOffset(limitParam, currentOffset);
            for (String json : jsons) {
                EntityInterface parsedEntity = (EntityInterface)JsonUtils.readValue(json, this.entityClass);
                try {
                    EntityInterface entity = this.setFieldsInternal(parsedEntity, fields);
                    this.setInheritedFields(entity, fields);
                    this.clearFieldsInternal(entity, fields);
                    entities.add(this.withHref(uriInfo, entity));
                }
                catch (Exception e) {
                    this.clearFieldsInternal(parsedEntity, fields);
                    EntityError entityError = new EntityError().withMessage(e.getMessage()).withEntity((Object)parsedEntity);
                    errors.add(entityError);
                    LOG.error("[ListForIndexing] Failed for Entity : {}", (Object)entityError);
                }
            }
            String newAfter = (currentOffset += limitParam) > total ? null : String.valueOf(currentOffset);
            return this.getResultList(entities, errors, String.valueOf(beforeOffset), newAfter, total);
        }
        return this.getResultList(entities, errors, null, null, total);
    }

    public ResultList<T> listBefore(UriInfo uriInfo, EntityUtil.Fields fields, ListFilter filter, int limitParam, String before) {
        List<String> jsons = this.dao.listBefore(filter, limitParam + 1, RestUtil.decodeCursor(before));
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        for (String json : jsons) {
            EntityInterface entity = this.setFieldsInternal((EntityInterface)JsonUtils.readValue(json, this.entityClass), fields);
            this.setInheritedFields(entity, fields);
            this.clearFieldsInternal(entity, fields);
            entities.add(this.withHref(uriInfo, entity));
        }
        int total = this.dao.listCount(filter);
        String beforeCursor = null;
        if (entities.size() > limitParam) {
            entities.remove(0);
            beforeCursor = ((EntityInterface)entities.get(0)).getName();
        }
        String afterCursor = ((EntityInterface)entities.get(entities.size() - 1)).getName();
        return this.getResultList(entities, beforeCursor, afterCursor, total);
    }

    public final T getVersion(UUID id, String version) {
        Double requestedVersion = Double.parseDouble(version);
        String extension = EntityUtil.getVersionExtension(this.entityType, requestedVersion);
        String json = this.daoCollection.entityExtensionDAO().getExtension(id, extension);
        if (json != null) {
            return (T)((EntityInterface)JsonUtils.readValue(json, this.entityClass));
        }
        T entity = this.setFieldsInternal(this.find(id, Include.ALL), this.putFields);
        if (entity.getVersion().equals(requestedVersion)) {
            return entity;
        }
        throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityVersionNotFound(this.entityType, id, requestedVersion));
    }

    public final EntityHistory listVersions(UUID id) {
        T latest = this.setFieldsInternal(this.find(id, Include.ALL), this.putFields);
        this.setInheritedFields(latest, this.putFields);
        String extensionPrefix = EntityUtil.getVersionExtensionPrefix(this.entityType);
        List<CollectionDAO.ExtensionRecord> records = this.daoCollection.entityExtensionDAO().getExtensions(id, extensionPrefix);
        ArrayList<CollectionDAO.EntityVersionPair> oldVersions = new ArrayList<CollectionDAO.EntityVersionPair>();
        records.forEach(r -> oldVersions.add(new CollectionDAO.EntityVersionPair((CollectionDAO.ExtensionRecord)r)));
        oldVersions.sort(EntityUtil.compareVersion.reversed());
        ArrayList<String> allVersions = new ArrayList<String>();
        allVersions.add(JsonUtils.pojoToJson(latest));
        oldVersions.forEach(version -> allVersions.add(version.getEntityJson()));
        return new EntityHistory().withEntityType(this.entityType).withVersions(allVersions);
    }

    public final T create(UriInfo uriInfo, T entity) {
        entity = this.withHref(uriInfo, this.createInternal(entity));
        return entity;
    }

    public final T createInternal(T entity) {
        this.prepareInternal(entity, false);
        return this.createNewEntity(entity);
    }

    public final void prepareInternal(T entity, boolean update) {
        this.validateTags(entity);
        this.prepare(entity, update);
        this.setFullyQualifiedName(entity);
        this.validateExtension(entity);
    }

    public final void storeRelationshipsInternal(T entity) {
        this.storeOwner(entity, entity.getOwner());
        this.applyTags(entity);
        this.storeDomain(entity, entity.getDomain());
        this.storeDataProducts(entity, entity.getDataProducts());
        this.storeRelationships(entity);
    }

    public final T setFieldsInternal(T entity, EntityUtil.Fields fields) {
        entity.setOwner(fields.contains("owner") ? this.getOwner(entity) : entity.getOwner());
        entity.setTags(fields.contains("tags") ? this.getTags(entity) : entity.getTags());
        entity.setExtension(fields.contains("extension") ? this.getExtension(entity) : entity.getExtension());
        entity.setDomain(fields.contains("domain") ? this.getDomain(entity) : entity.getDomain());
        entity.setDataProducts(fields.contains("dataProducts") ? this.getDataProducts(entity) : entity.getDataProducts());
        entity.setFollowers(fields.contains("followers") ? this.getFollowers(entity) : entity.getFollowers());
        entity.setChildren(fields.contains("children") ? this.getChildren(entity) : entity.getChildren());
        entity.setExperts(fields.contains("experts") ? this.getExperts(entity) : entity.getExperts());
        entity.setReviewers(fields.contains("reviewers") ? this.getReviewers(entity) : entity.getReviewers());
        entity.setVotes(fields.contains("votes") ? this.getVotes(entity) : entity.getVotes());
        this.setFields(entity, fields);
        return entity;
    }

    public final void clearFieldsInternal(T entity, EntityUtil.Fields fields) {
        entity.setOwner(fields.contains("owner") ? entity.getOwner() : null);
        entity.setTags(fields.contains("tags") ? entity.getTags() : null);
        entity.setExtension(fields.contains("extension") ? entity.getExtension() : null);
        entity.setDomain(fields.contains("domain") ? entity.getDomain() : null);
        entity.setDataProducts(fields.contains("dataProducts") ? entity.getDataProducts() : null);
        entity.setFollowers(fields.contains("followers") ? entity.getFollowers() : null);
        entity.setChildren(fields.contains("children") ? entity.getChildren() : null);
        entity.setExperts(fields.contains("experts") ? entity.getExperts() : null);
        entity.setReviewers(fields.contains("reviewers") ? entity.getReviewers() : null);
        entity.setVotes(fields.contains("votes") ? entity.getVotes() : null);
        this.clearFields(entity, fields);
    }

    @Transaction
    public final RestUtil.PutResponse<T> createOrUpdate(UriInfo uriInfo, T updated) {
        T original = this.findByNameOrNull(updated.getFullyQualifiedName(), Include.ALL);
        if (original == null) {
            return new RestUtil.PutResponse<T>(Response.Status.CREATED, this.withHref(uriInfo, this.createNewEntity(updated)), EventType.ENTITY_CREATED);
        }
        return this.update(uriInfo, original, updated);
    }

    protected void postCreate(T entity) {
        if (this.supportsSearch) {
            this.searchRepository.createEntity((EntityInterface)entity);
        }
    }

    protected void postUpdate(T original, T updated) {
        if (this.supportsSearch) {
            this.searchRepository.updateEntity((EntityInterface)updated);
        }
    }

    @Transaction
    public final RestUtil.PutResponse<T> update(UriInfo uriInfo, T original, T updated) {
        this.setFieldsInternal(original, this.putFields);
        if (Boolean.TRUE.equals(original.getDeleted())) {
            this.restoreEntity(updated.getUpdatedBy(), this.entityType, original.getId());
        }
        EntityUpdater entityUpdater = this.getUpdater(original, updated, Operation.PUT);
        entityUpdater.update();
        EventType change = entityUpdater.fieldsChanged() ? EventType.ENTITY_UPDATED : EventType.ENTITY_NO_CHANGE;
        this.setInheritedFields(updated, new EntityUtil.Fields(this.allowedFields));
        return new RestUtil.PutResponse<T>(Response.Status.OK, this.withHref(uriInfo, updated), change);
    }

    @Transaction
    public final RestUtil.PatchResponse<T> patch(UriInfo uriInfo, UUID id, String user, JsonPatch patch) {
        T original = this.setFieldsInternal(this.find(id, Include.NON_DELETED), this.patchFields);
        this.setInheritedFields(original, this.patchFields);
        EntityInterface updated = (EntityInterface)JsonUtils.applyPatch(original, patch, this.entityClass);
        updated.setUpdatedBy(user);
        updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.prepareInternal(updated, true);
        this.populateOwner(updated.getOwner());
        this.restorePatchAttributes(original, updated);
        EntityUpdater entityUpdater = this.getUpdater(original, updated, Operation.PATCH);
        entityUpdater.update();
        EventType change = EventType.ENTITY_NO_CHANGE;
        if (entityUpdater.fieldsChanged()) {
            change = EventType.ENTITY_UPDATED;
            this.setInheritedFields(original, this.patchFields);
        }
        return new RestUtil.PatchResponse<EntityInterface>(Response.Status.OK, this.withHref(uriInfo, updated), change);
    }

    @Transaction
    public final RestUtil.PatchResponse<T> patch(UriInfo uriInfo, String fqn, String user, JsonPatch patch) {
        T original = this.setFieldsInternal(this.findByName(fqn, Include.NON_DELETED), this.patchFields);
        this.setInheritedFields(original, this.patchFields);
        EntityInterface updated = (EntityInterface)JsonUtils.applyPatch(original, patch, this.entityClass);
        updated.setUpdatedBy(user);
        updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.prepareInternal(updated, true);
        this.populateOwner(updated.getOwner());
        this.restorePatchAttributes(original, updated);
        EntityUpdater entityUpdater = this.getUpdater(original, updated, Operation.PATCH);
        entityUpdater.update();
        EventType change = EventType.ENTITY_NO_CHANGE;
        if (entityUpdater.fieldsChanged()) {
            change = EventType.ENTITY_UPDATED;
            this.setInheritedFields(original, this.patchFields);
        }
        return new RestUtil.PatchResponse<EntityInterface>(Response.Status.OK, this.withHref(uriInfo, updated), change);
    }

    @Transaction
    public final RestUtil.PutResponse<T> addFollower(String updatedBy, UUID entityId, UUID userId) {
        T entity = this.find(entityId, Include.NON_DELETED);
        User user = (User)this.daoCollection.userDAO().findEntityById(userId);
        if (Boolean.TRUE.equals(user.getDeleted())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.deletedUser(userId));
        }
        this.addRelationship(userId, entityId, "user", this.entityType, Relationship.FOLLOWS);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(entity.getVersion());
        EntityUtil.fieldAdded(change, "followers", List.of(user.getEntityReference()));
        ChangeEvent changeEvent = new ChangeEvent().withId(UUID.randomUUID()).withEntity(entity).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(this.entityType).withEntityId(entityId).withEntityFullyQualifiedName(entity.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(entity.getVersion()).withPreviousVersion(change.getPreviousVersion());
        entity.setChangeDescription(change);
        this.postUpdate(entity, entity);
        return new RestUtil.PutResponse(Response.Status.OK, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
    }

    @Transaction
    public final RestUtil.PutResponse<T> updateVote(String updatedBy, UUID entityId, VoteRequest request) {
        T originalEntity = this.find(entityId, Include.NON_DELETED);
        User user = (User)this.daoCollection.userDAO().findEntityByName(FullyQualifiedName.quoteName(updatedBy));
        UUID userId = user.getId();
        if (Boolean.TRUE.equals(user.getDeleted())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.deletedUser(userId));
        }
        ChangeDescription change = new ChangeDescription().withPreviousVersion(originalEntity.getVersion());
        EntityUtil.fieldUpdated(change, "votes", null, request.getUpdatedVoteType());
        if (request.getUpdatedVoteType() == VoteRequest.VoteType.UN_VOTED) {
            this.deleteRelationship(userId, "user", entityId, this.entityType, Relationship.VOTED);
        } else {
            this.addRelationship(userId, entityId, "user", this.entityType, Relationship.VOTED, JsonUtils.pojoToJson(request.getUpdatedVoteType()), false);
        }
        this.setFieldsInternal(originalEntity, new EntityUtil.Fields(this.allowedFields, "votes"));
        ChangeEvent changeEvent = new ChangeEvent().withId(UUID.randomUUID()).withEntity(originalEntity).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(this.entityType).withEntityId(entityId).withEntityFullyQualifiedName(originalEntity.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(originalEntity.getVersion()).withPreviousVersion(change.getPreviousVersion());
        this.postUpdate(originalEntity, originalEntity);
        return new RestUtil.PutResponse(Response.Status.OK, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> delete(String updatedBy, UUID id, boolean recursive, boolean hardDelete) {
        RestUtil.DeleteResponse<T> response = this.deleteInternal(updatedBy, id, recursive, hardDelete);
        this.postDelete((EntityInterface)response.entity());
        return response;
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> deleteByName(String updatedBy, String name, boolean recursive, boolean hardDelete) {
        name = this.quoteFqn ? EntityInterfaceUtil.quoteName((String)name) : name;
        RestUtil.DeleteResponse<T> response = this.deleteInternalByName(updatedBy, name, recursive, hardDelete);
        this.postDelete((EntityInterface)response.entity());
        return response;
    }

    protected void preDelete(T entity, String deletedBy) {
    }

    protected void postDelete(T entity) {
    }

    public final void deleteFromSearch(T entity, EventType changeType) {
        if (this.supportsSearch) {
            if (changeType.equals((Object)EventType.ENTITY_SOFT_DELETED)) {
                this.searchRepository.softDeleteOrRestoreEntity((EntityInterface)entity, true);
            } else {
                this.searchRepository.deleteEntity((EntityInterface)entity);
            }
        }
    }

    public final void restoreFromSearch(T entity) {
        if (this.supportsSearch) {
            this.searchRepository.softDeleteOrRestoreEntity((EntityInterface)entity, false);
        }
    }

    public ResultList<T> listFromSearchWithOffset(UriInfo uriInfo, EntityUtil.Fields fields, SearchListFilter searchListFilter, int limit, int offset, String q) throws IOException {
        return this.listFromSearchWithOffset(uriInfo, fields, searchListFilter, limit, offset, null, q);
    }

    public ResultList<T> listFromSearchWithOffset(UriInfo uriInfo, EntityUtil.Fields fields, SearchListFilter searchListFilter, int limit, int offset, SearchSortFilter searchSortFilter, String q) throws IOException {
        ArrayList<EntityInterface> entityList = new ArrayList<EntityInterface>();
        Long total = 0L;
        if (limit > 0) {
            SearchClient.SearchResultListMapper results = this.searchRepository.listWithOffset(searchListFilter, limit, offset, this.entityType, searchSortFilter, q);
            total = results.getTotal();
            for (Map<String, Object> json : results.getResults()) {
                EntityInterface entity = this.setFieldsInternal((EntityInterface)JsonUtils.readOrConvertValue(json, this.entityClass), fields);
                this.setInheritedFields(entity, fields);
                this.clearFieldsInternal(entity, fields);
                entityList.add(this.withHref(uriInfo, entity));
            }
            return new ResultList(entityList, offset, limit, (Integer)total.intValue());
        }
        throw new IllegalArgumentException("Limit should be greater than 0");
    }

    @Transaction
    private RestUtil.DeleteResponse<T> delete(String deletedBy, T original, boolean recursive, boolean hardDelete) {
        EventType changeType;
        this.checkSystemEntityDeletion(original);
        this.preDelete(original, deletedBy);
        this.setFieldsInternal(original, this.putFields);
        this.deleteChildren(original.getId(), recursive, hardDelete, deletedBy);
        T updated = this.get(null, original.getId(), this.putFields, Include.ALL, false);
        if (this.supportsSoftDelete && !hardDelete) {
            updated.setUpdatedBy(deletedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            updated.setDeleted(Boolean.valueOf(true));
            EntityUpdater updater = this.getUpdater(original, updated, Operation.SOFT_DELETE);
            updater.update();
            changeType = EventType.ENTITY_SOFT_DELETED;
        } else {
            this.cleanup(updated);
            changeType = EventType.ENTITY_DELETED;
        }
        LOG.info("{} deleted {}", (Object)(hardDelete ? "Hard" : "Soft"), (Object)updated.getFullyQualifiedName());
        return new RestUtil.DeleteResponse<T>(updated, changeType);
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> deleteInternalByName(String updatedBy, String name, boolean recursive, boolean hardDelete) {
        T entity = this.findByName(name, Include.ALL);
        return this.delete(updatedBy, entity, recursive, hardDelete);
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> deleteInternal(String updatedBy, UUID id, boolean recursive, boolean hardDelete) {
        T entity = this.find(id, Include.ALL);
        return this.delete(updatedBy, entity, recursive, hardDelete);
    }

    @Transaction
    private void deleteChildren(UUID id, boolean recursive, boolean hardDelete, String updatedBy) {
        List<CollectionDAO.EntityRelationshipRecord> childrenRecords = this.daoCollection.relationshipDAO().findTo(id, this.entityType, List.of(Integer.valueOf(Relationship.CONTAINS.ordinal()), Integer.valueOf(Relationship.PARENT_OF.ordinal())));
        if (childrenRecords.isEmpty()) {
            LOG.info("No children to delete");
            return;
        }
        if (!recursive) {
            throw new IllegalArgumentException(CatalogExceptionMessage.entityIsNotEmpty(this.entityType));
        }
        this.deleteChildren(childrenRecords, hardDelete, updatedBy);
    }

    @Transaction
    protected void deleteChildren(List<CollectionDAO.EntityRelationshipRecord> children, boolean hardDelete, String updatedBy) {
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : children) {
            LOG.info("Recursively {} deleting {} {}", new Object[]{hardDelete ? "hard" : "soft", entityRelationshipRecord.getType(), entityRelationshipRecord.getId()});
            Entity.deleteEntity(updatedBy, entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), true, hardDelete);
        }
    }

    @Transaction
    protected void cleanup(T entityInterface) {
        UUID id = entityInterface.getId();
        this.daoCollection.relationshipDAO().deleteAll(id, this.entityType);
        this.daoCollection.fieldRelationshipDAO().deleteAllByPrefix(entityInterface.getFullyQualifiedName());
        this.daoCollection.entityExtensionDAO().deleteAll(id);
        this.daoCollection.tagUsageDAO().deleteTagLabelsByTargetPrefix(entityInterface.getFullyQualifiedName());
        this.daoCollection.tagUsageDAO().deleteTagLabelsByFqn(entityInterface.getFullyQualifiedName());
        this.daoCollection.usageDAO().delete(id);
        this.removeExtension((EntityInterface)entityInterface);
        Entity.getFeedRepository().deleteByAbout(entityInterface.getId());
        this.invalidate(entityInterface);
        this.dao.delete(id);
    }

    private void invalidate(T entity) {
        CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)this.entityType, (Object)entity.getId()));
        CACHE_WITH_NAME.invalidate((Object)new ImmutablePair((Object)this.entityType, (Object)entity.getFullyQualifiedName()));
    }

    @Transaction
    public final RestUtil.PutResponse<T> deleteFollower(String updatedBy, UUID entityId, UUID userId) {
        T entity = this.find(entityId, Include.NON_DELETED);
        EntityReference user = Entity.getEntityReferenceById("user", userId, Include.NON_DELETED);
        this.deleteRelationship(userId, "user", entityId, this.entityType, Relationship.FOLLOWS);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(entity.getVersion());
        EntityUtil.fieldDeleted(change, "followers", List.of(user));
        ChangeEvent changeEvent = new ChangeEvent().withId(UUID.randomUUID()).withEntity(entity).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityFullyQualifiedName(entity.getFullyQualifiedName()).withEntityType(this.entityType).withEntityId(entityId).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(entity.getVersion()).withPreviousVersion(change.getPreviousVersion());
        return new RestUtil.PutResponse(Response.Status.OK, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
    }

    public final ResultList<T> getResultList(List<T> entities, String beforeCursor, String afterCursor, int total) {
        return new ResultList<T>(entities, beforeCursor, afterCursor, total);
    }

    public final ResultList<T> getResultList(List<T> entities, List<EntityError> errors, String beforeCursor, String afterCursor, int total) {
        return new ResultList<T>(entities, errors, beforeCursor, afterCursor, total);
    }

    @Transaction
    private T createNewEntity(T entity) {
        this.storeEntity(entity, false);
        this.storeExtension((EntityInterface)entity);
        this.storeRelationshipsInternal(entity);
        this.setInheritedFields(entity, new EntityUtil.Fields(this.allowedFields));
        this.postCreate(entity);
        return entity;
    }

    @Transaction
    protected void store(T entity, boolean update) {
        entity.withHref(null);
        EntityReference owner = entity.getOwner();
        entity.setOwner(null);
        List children = entity.getChildren();
        entity.setChildren(null);
        List tags = entity.getTags();
        entity.setTags(null);
        EntityReference domain = entity.getDomain();
        entity.setDomain(null);
        List dataProducts = entity.getDataProducts();
        entity.setDataProducts(null);
        List followers = entity.getFollowers();
        entity.setFollowers(null);
        List experts = entity.getExperts();
        entity.setExperts(null);
        if (update) {
            this.dao.update(entity.getId(), entity.getFullyQualifiedName(), JsonUtils.pojoToJson(entity));
            LOG.info("Updated {}:{}:{}", new Object[]{this.entityType, entity.getId(), entity.getFullyQualifiedName()});
            this.invalidate(entity);
        } else {
            this.dao.insert((EntityInterface)entity, entity.getFullyQualifiedName());
            LOG.info("Created {}:{}:{}", new Object[]{this.entityType, entity.getId(), entity.getFullyQualifiedName()});
        }
        entity.setOwner(owner);
        entity.setChildren(children);
        entity.setTags(tags);
        entity.setDomain(domain);
        entity.setDataProducts(dataProducts);
        entity.setFollowers(followers);
        entity.setExperts(experts);
    }

    @Transaction
    protected void storeTimeSeries(String fqn, String extension, String jsonSchema, String entityJson) {
        this.daoCollection.entityExtensionTimeSeriesDao().insert(fqn, extension, jsonSchema, entityJson);
    }

    @Transaction
    public final String getExtensionAtTimestamp(String fqn, String extension, Long timestamp) {
        return this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, extension, timestamp);
    }

    public final String getLatestExtensionFromTimeSeries(String fqn, String extension) {
        return this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(fqn, extension);
    }

    public final List<String> getResultsFromAndToTimestamps(String fullyQualifiedName, String extension, Long startTs, Long endTs) {
        return this.getResultsFromAndToTimestamps(fullyQualifiedName, extension, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC);
    }

    public final List<String> getResultsFromAndToTimestamps(String fqn, String extension, Long startTs, Long endTs, EntityTimeSeriesDAO.OrderBy orderBy) {
        return this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestampsByOrder(fqn, extension, startTs, endTs, orderBy);
    }

    @Transaction
    public final void deleteExtensionAtTimestamp(String fqn, String extension, Long timestamp) {
        this.daoCollection.entityExtensionTimeSeriesDao().deleteAtTimestamp(fqn, extension, timestamp);
    }

    @Transaction
    public final void deleteExtensionBeforeTimestamp(String fqn, String extension, Long timestamp) {
        this.daoCollection.entityExtensionTimeSeriesDao().deleteBeforeTimestamp(fqn, extension, timestamp);
    }

    private void validateExtension(T entity) {
        if (entity.getExtension() == null) {
            return;
        }
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            String fieldName = (String)entry.getKey();
            JsonNode fieldValue = (JsonNode)entry.getValue();
            JsonSchema jsonSchema = TypeRegistry.instance().getSchema(this.entityType, fieldName);
            if (jsonSchema == null) {
                throw new IllegalArgumentException(CatalogExceptionMessage.unknownCustomField(fieldName));
            }
            Set validationMessages = jsonSchema.validate(fieldValue);
            if (validationMessages.isEmpty()) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.jsonValidationError(fieldName, validationMessages.toString()));
        }
    }

    public final void storeExtension(EntityInterface entity) {
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            this.storeCustomProperty(entity, fieldName, value);
        }
    }

    public final void removeExtension(EntityInterface entity) {
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            this.removeCustomProperty(entity, (String)entry.getKey());
        }
    }

    private void storeCustomProperty(EntityInterface entity, String fieldName, JsonNode value) {
        String fieldFQN = TypeRegistry.getCustomPropertyFQN(this.entityType, fieldName);
        this.daoCollection.entityExtensionDAO().insert(entity.getId(), fieldFQN, "customFieldSchema", JsonUtils.pojoToJson(value));
    }

    private void removeCustomProperty(EntityInterface entity, String fieldName) {
        String fieldFQN = TypeRegistry.getCustomPropertyFQN(this.entityType, fieldName);
        this.daoCollection.entityExtensionDAO().delete(entity.getId(), fieldFQN);
    }

    public final Object getExtension(T entity) {
        if (!this.supportsExtension) {
            return null;
        }
        String fieldFQNPrefix = TypeRegistry.getCustomPropertyFQNPrefix(this.entityType);
        List<CollectionDAO.ExtensionRecord> records = this.daoCollection.entityExtensionDAO().getExtensions(entity.getId(), fieldFQNPrefix);
        if (records.isEmpty()) {
            return null;
        }
        ObjectNode objectNode = JsonUtils.getObjectNode();
        for (CollectionDAO.ExtensionRecord extensionRecord : records) {
            String fieldName = TypeRegistry.getPropertyName(extensionRecord.extensionName());
            objectNode.set(fieldName, JsonUtils.readTree(extensionRecord.extensionJson()));
        }
        return objectNode;
    }

    protected void applyColumnTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyColumnTags(column.getChildren());
        }
    }

    protected void applyTags(T entity) {
        if (this.supportsTags) {
            this.applyTags(entity.getTags(), entity.getFullyQualifiedName());
        }
    }

    @Transaction
    public final void applyTags(List<TagLabel> tagLabels, String targetFQN) {
        for (TagLabel tagLabel : CommonUtil.listOrEmpty(tagLabels)) {
            boolean isTagDerived = tagLabel.getLabelType().equals((Object)TagLabel.LabelType.DERIVED);
            if (isTagDerived) continue;
            this.daoCollection.tagUsageDAO().applyTag(tagLabel.getSource().ordinal(), tagLabel.getTagFQN(), tagLabel.getTagFQN(), targetFQN, tagLabel.getLabelType().ordinal(), tagLabel.getState().ordinal());
        }
    }

    protected List<TagLabel> getTags(T entity) {
        return !this.supportsTags ? null : this.getTags(entity.getFullyQualifiedName());
    }

    protected List<TagLabel> getTags(String fqn) {
        if (!this.supportsTags) {
            return null;
        }
        return TagLabelUtil.addDerivedTags(this.daoCollection.tagUsageDAO().getTags(fqn));
    }

    public final Map<String, List<TagLabel>> getTagsByPrefix(String prefix, String postfix) {
        return !this.supportsTags ? null : this.daoCollection.tagUsageDAO().getTagsByPrefix(prefix, postfix, true);
    }

    protected List<EntityReference> getFollowers(T entity) {
        return !this.supportsFollower || entity == null ? Collections.emptyList() : this.findFrom(entity.getId(), this.entityType, Relationship.FOLLOWS, "user");
    }

    protected Votes getVotes(T entity) {
        if (!this.supportsVotes || entity == null) {
            return new Votes();
        }
        ArrayList<CollectionDAO.EntityRelationshipRecord> upVoterRecords = new ArrayList<CollectionDAO.EntityRelationshipRecord>();
        ArrayList<CollectionDAO.EntityRelationshipRecord> downVoterRecords = new ArrayList<CollectionDAO.EntityRelationshipRecord>();
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(entity.getId(), this.entityType, Relationship.VOTED, "user");
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            VoteRequest.VoteType type = JsonUtils.readValue(entityRelationshipRecord.getJson(), VoteRequest.VoteType.class);
            if (type == VoteRequest.VoteType.VOTED_UP) {
                upVoterRecords.add(entityRelationshipRecord);
                continue;
            }
            if (type != VoteRequest.VoteType.VOTED_DOWN) continue;
            downVoterRecords.add(entityRelationshipRecord);
        }
        List<EntityReference> upVoters = EntityUtil.getEntityReferences(upVoterRecords);
        List<EntityReference> downVoters = EntityUtil.getEntityReferences(downVoterRecords);
        return new Votes().withUpVotes(Integer.valueOf(upVoters.size())).withDownVotes(Integer.valueOf(downVoters.size())).withUpVoters(upVoters).withDownVoters(downVoters);
    }

    public final T withHref(UriInfo uriInfo, T entity) {
        if (uriInfo == null) {
            return entity;
        }
        return (T)entity.withHref(this.getHref(uriInfo, entity.getId()));
    }

    public final URI getHref(UriInfo uriInfo, UUID id) {
        return RestUtil.getHref(uriInfo, this.collectionPath, id);
    }

    @Transaction
    public final RestUtil.PutResponse<T> restoreEntity(String updatedBy, String entityType, UUID id) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.daoCollection.relationshipDAO().findTo(id, entityType, Relationship.CONTAINS.ordinal());
        if (!records.isEmpty()) {
            for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
                LOG.info("Recursively restoring {} {}", (Object)entityRelationshipRecord.getType(), (Object)entityRelationshipRecord.getId());
                Entity.restoreEntity(updatedBy, entityRelationshipRecord.getType(), entityRelationshipRecord.getId());
            }
        }
        LOG.info("Restoring the {} {}", (Object)entityType, (Object)id);
        try {
            T original = this.find(id, Include.DELETED);
            this.setFieldsInternal(original, this.putFields);
            EntityInterface updated = (EntityInterface)JsonUtils.readValue(JsonUtils.pojoToJson(original), this.entityClass);
            updated.setUpdatedBy(updatedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            EntityUpdater updater = this.getUpdater(original, updated, Operation.PUT);
            updater.update();
            return new RestUtil.PutResponse<EntityInterface>(Response.Status.OK, updated, EventType.ENTITY_RESTORED);
        }
        catch (EntityNotFoundException e) {
            LOG.info("Entity is not in deleted state {} {}", (Object)entityType, (Object)id);
            return null;
        }
    }

    public final void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship) {
        this.addRelationship(fromId, toId, fromEntity, toEntity, relationship, false);
    }

    public final void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship, boolean bidirectional) {
        this.addRelationship(fromId, toId, fromEntity, toEntity, relationship, null, bidirectional);
    }

    @Transaction
    public final void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship, String json, boolean bidirectional) {
        UUID from = fromId;
        UUID to = toId;
        if (bidirectional && fromId.compareTo(toId) > 0) {
            from = toId;
            to = fromId;
        }
        this.daoCollection.relationshipDAO().insert(from, to, fromEntity, toEntity, relationship.ordinal(), json);
    }

    @Transaction
    public final void bulkAddToRelationship(UUID fromId, List<UUID> toId, String fromEntity, String toEntity, Relationship relationship) {
        this.daoCollection.relationshipDAO().bulkInsertToRelationship(fromId, toId, fromEntity, toEntity, relationship.ordinal());
    }

    public final List<EntityReference> findBoth(UUID entity1, String entityType1, Relationship relationship, String entity2) {
        ArrayList<EntityReference> ids = new ArrayList<EntityReference>();
        ids.addAll(this.findFrom(entity1, entityType1, relationship, entity2));
        ids.addAll(this.findTo(entity1, entityType1, relationship, entity2));
        return ids;
    }

    public final List<EntityReference> findFrom(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(toId, toEntityType, relationship, fromEntityType);
        return EntityUtil.getEntityReferences(records);
    }

    public final List<CollectionDAO.EntityRelationshipRecord> findFromRecords(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        return fromEntityType == null ? this.daoCollection.relationshipDAO().findFrom(toId, toEntityType, relationship.ordinal()) : this.daoCollection.relationshipDAO().findFrom(toId, toEntityType, relationship.ordinal(), fromEntityType);
    }

    public final EntityReference getContainer(UUID toId) {
        return this.getFromEntityRef(toId, Relationship.CONTAINS, null, true);
    }

    public final EntityReference getContainer(UUID toId, String fromEntityType) {
        return this.getFromEntityRef(toId, Relationship.CONTAINS, fromEntityType, true);
    }

    public final EntityReference getFromEntityRef(UUID toId, Relationship relationship, String fromEntityType, boolean mustHaveRelationship) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(toId, this.entityType, relationship, fromEntityType);
        EntityRepository.ensureSingleRelationship(this.entityType, toId, records, relationship.value(), fromEntityType, mustHaveRelationship);
        return !records.isEmpty() ? Entity.getEntityReferenceById(records.get(0).getType(), records.get(0).getId(), Include.ALL) : null;
    }

    public final EntityReference getToEntityRef(UUID fromId, Relationship relationship, String toEntityType, boolean mustHaveRelationship) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findToRecords(fromId, this.entityType, relationship, toEntityType);
        EntityRepository.ensureSingleRelationship(this.entityType, fromId, records, relationship.value(), toEntityType, mustHaveRelationship);
        return !records.isEmpty() ? Entity.getEntityReferenceById(records.get(0).getType(), records.get(0).getId(), Include.ALL) : null;
    }

    public static void ensureSingleRelationship(String entityType, UUID id, List<CollectionDAO.EntityRelationshipRecord> relations, String relationshipName, String toEntityType, boolean mustHaveRelationship) {
        if (mustHaveRelationship && relations.isEmpty()) {
            throw new UnhandledServerException(CatalogExceptionMessage.entityRelationshipNotFound(entityType, id, relationshipName, toEntityType));
        }
        if (!mustHaveRelationship && relations.isEmpty()) {
            return;
        }
        if (relations.size() != 1) {
            LOG.warn("Possible database issues - multiple relations {} for entity {}:{}", new Object[]{relationshipName, entityType, id});
        }
    }

    public final List<EntityReference> findTo(UUID fromId, String fromEntityType, Relationship relationship, String toEntityType) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findToRecords(fromId, fromEntityType, relationship, toEntityType);
        return EntityUtil.getEntityReferences(records);
    }

    public final List<CollectionDAO.EntityRelationshipRecord> findToRecords(UUID fromId, String fromEntityType, Relationship relationship, String toEntityType) {
        return toEntityType == null ? this.daoCollection.relationshipDAO().findTo(fromId, fromEntityType, relationship.ordinal()) : this.daoCollection.relationshipDAO().findTo(fromId, fromEntityType, relationship.ordinal(), toEntityType);
    }

    public final void deleteRelationship(UUID fromId, String fromEntityType, UUID toId, String toEntityType, Relationship relationship) {
        this.daoCollection.relationshipDAO().delete(fromId, fromEntityType, toId, toEntityType, relationship.ordinal());
    }

    public final void deleteTo(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        this.daoCollection.relationshipDAO().deleteTo(toId, toEntityType, relationship.ordinal(), fromEntityType);
    }

    public final void deleteFrom(UUID fromId, String fromEntityType, Relationship relationship, String toEntityType) {
        this.daoCollection.relationshipDAO().deleteFrom(fromId, fromEntityType, relationship.ordinal(), toEntityType);
    }

    public final void validateUsers(List<EntityReference> entityReferences) {
        if (entityReferences != null) {
            for (EntityReference entityReference : entityReferences) {
                EntityReference ref = entityReference.getId() != null ? Entity.getEntityReferenceById("user", entityReference.getId(), Include.ALL) : Entity.getEntityReferenceByName("user", entityReference.getFullyQualifiedName(), Include.ALL);
                EntityUtil.copy(ref, entityReference);
            }
            entityReferences.sort(EntityUtil.compareEntityReference);
        }
    }

    public final void validateRoles(List<EntityReference> roles) {
        if (roles != null) {
            for (EntityReference entityReference : roles) {
                EntityReference ref = Entity.getEntityReferenceById("role", entityReference.getId(), Include.ALL);
                EntityUtil.copy(ref, entityReference);
            }
            roles.sort(EntityUtil.compareEntityReference);
        }
    }

    final void validatePolicies(List<EntityReference> policies) {
        if (policies != null) {
            for (EntityReference entityReference : policies) {
                EntityReference ref = Entity.getEntityReferenceById("policy", entityReference.getId(), Include.ALL);
                EntityUtil.copy(ref, entityReference);
            }
            policies.sort(EntityUtil.compareEntityReference);
        }
    }

    public final EntityReference getOwner(T entity) {
        return !this.supportsOwner ? null : this.getFromEntityRef(entity.getId(), Relationship.OWNS, null, false);
    }

    public final EntityReference getDomain(T entity) {
        return this.supportsDomain ? this.getFromEntityRef(entity.getId(), Relationship.HAS, "domain", false) : null;
    }

    private List<EntityReference> getDataProducts(T entity) {
        return !this.supportsDataProducts ? null : this.findFrom(entity.getId(), this.entityType, Relationship.HAS, "dataProduct");
    }

    public EntityInterface getParentEntity(T entity, String fields) {
        return null;
    }

    public final EntityReference getParent(T entity) {
        return this.getFromEntityRef(entity.getId(), Relationship.CONTAINS, this.entityType, false);
    }

    protected List<EntityReference> getChildren(T entity) {
        return this.findTo(entity.getId(), this.entityType, Relationship.CONTAINS, this.entityType);
    }

    protected List<EntityReference> getReviewers(T entity) {
        return this.supportsReviewers ? this.findFrom(entity.getId(), this.entityType, Relationship.REVIEWS, "user") : null;
    }

    protected List<EntityReference> getExperts(T entity) {
        return this.supportsExperts ? this.findTo(entity.getId(), this.entityType, Relationship.EXPERT, "user") : null;
    }

    public final EntityReference getOwner(EntityReference ref) {
        return !this.supportsOwner ? null : this.getFromEntityRef(ref.getId(), Relationship.OWNS, null, false);
    }

    public final void inheritDomain(T entity, EntityUtil.Fields fields, EntityInterface parent) {
        if (fields.contains("domain") && entity.getDomain() == null && parent != null) {
            entity.setDomain(parent.getDomain() != null ? parent.getDomain().withInherited(Boolean.valueOf(true)) : null);
        }
    }

    public final void inheritOwner(T entity, EntityUtil.Fields fields, EntityInterface parent) {
        if (fields.contains("owner") && entity.getOwner() == null && parent != null) {
            entity.setOwner(parent.getOwner() != null ? parent.getOwner().withInherited(Boolean.valueOf(true)) : null);
        }
    }

    public final void inheritExperts(T entity, EntityUtil.Fields fields, EntityInterface parent) {
        if (fields.contains("experts") && CommonUtil.nullOrEmpty((List)entity.getExperts()) && parent != null) {
            entity.setExperts(parent.getExperts());
            CommonUtil.listOrEmpty((List)entity.getExperts()).forEach(expert -> expert.withInherited(Boolean.valueOf(true)));
        }
    }

    public final void inheritReviewers(T entity, EntityUtil.Fields fields, EntityInterface parent) {
        if (fields.contains("reviewers") && CommonUtil.nullOrEmpty((List)entity.getReviewers()) && parent != null) {
            entity.setReviewers(parent.getReviewers());
            CommonUtil.listOrEmpty((List)entity.getReviewers()).forEach(reviewer -> reviewer.withInherited(Boolean.valueOf(true)));
        }
    }

    protected void populateOwner(EntityReference owner) {
        if (owner == null) {
            return;
        }
        EntityReference ref = this.validateOwner(owner);
        EntityUtil.copy(ref, owner);
    }

    @Transaction
    protected void storeOwner(T entity, EntityReference owner) {
        if (this.supportsOwner && owner != null) {
            LOG.info("Adding owner {}:{} for entity {}:{}", new Object[]{owner.getType(), owner.getFullyQualifiedName(), this.entityType, entity.getId()});
            this.addRelationship(owner.getId(), entity.getId(), owner.getType(), this.entityType, Relationship.OWNS);
        }
    }

    @Transaction
    protected void storeDomain(T entity, EntityReference domain) {
        if (this.supportsDomain && domain != null) {
            LOG.info("Adding domain {} for entity {}:{}", new Object[]{domain.getFullyQualifiedName(), this.entityType, entity.getId()});
            this.addRelationship(domain.getId(), entity.getId(), "domain", this.entityType, Relationship.HAS);
        }
    }

    @Transaction
    protected void storeDataProducts(T entity, List<EntityReference> dataProducts) {
        if (this.supportsDataProducts && !CommonUtil.nullOrEmpty(dataProducts)) {
            for (EntityReference dataProduct : dataProducts) {
                LOG.info("Adding dataProduct {} for entity {}:{}", new Object[]{dataProduct.getFullyQualifiedName(), this.entityType, entity.getId()});
                this.addRelationship(dataProduct.getId(), entity.getId(), "dataProduct", this.entityType, Relationship.HAS);
            }
        }
    }

    protected BulkOperationResult bulkAssetsOperation(UUID entityId, String fromEntity, Relationship relationship, BulkAssets request, boolean isAdd) {
        BulkOperationResult result = new BulkOperationResult().withStatus(ApiStatus.SUCCESS).withDryRun(Boolean.valueOf(false));
        ArrayList<BulkResponse> success = new ArrayList<BulkResponse>();
        EntityUtil.populateEntityReferences(request.getAssets());
        for (EntityReference ref : request.getAssets()) {
            result.setNumberOfRowsProcessed(Integer.valueOf(result.getNumberOfRowsProcessed() + 1));
            if (isAdd) {
                this.addRelationship(entityId, ref.getId(), fromEntity, ref.getType(), relationship);
            } else {
                this.deleteRelationship(entityId, fromEntity, ref.getId(), ref.getType(), relationship);
            }
            success.add(new BulkResponse().withRequest((Object)ref));
            result.setNumberOfRowsPassed(Integer.valueOf(result.getNumberOfRowsPassed() + 1));
            this.searchRepository.updateEntity(ref);
        }
        result.withSuccessRequest(success);
        if (result.getStatus().equals((Object)ApiStatus.SUCCESS)) {
            EntityInterface entityInterface = (EntityInterface)Entity.getEntity(fromEntity, entityId, "id", Include.ALL);
            ChangeDescription change = this.addBulkAddRemoveChangeDescription(entityInterface.getVersion(), isAdd, request.getAssets(), null);
            ChangeEvent changeEvent = this.getChangeEvent(entityInterface, change, fromEntity, entityInterface.getVersion());
            Entity.getCollectionDAO().changeEventDAO().insert(JsonUtils.pojoToJson(changeEvent));
        }
        return result;
    }

    private ChangeDescription addBulkAddRemoveChangeDescription(Double version, boolean isAdd, Object newValue, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("assets").withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        if (isAdd) {
            change.getFieldsAdded().add(fieldChange);
        } else {
            change.getFieldsDeleted().add(fieldChange);
        }
        return change;
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withId(UUID.randomUUID()).withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    @Transaction
    private void removeOwner(T entity, EntityReference owner) {
        if (EntityUtil.getId(owner) != null) {
            LOG.info("Removing owner {}:{} for entity {}", new Object[]{owner.getType(), owner.getFullyQualifiedName(), entity.getId()});
            this.deleteRelationship(owner.getId(), owner.getType(), entity.getId(), this.entityType, Relationship.OWNS);
        }
    }

    @Transaction
    public final void updateOwner(T ownedEntity, EntityReference originalOwner, EntityReference newOwner) {
        if (Objects.equals(EntityUtil.getId(originalOwner), EntityUtil.getId(newOwner))) {
            return;
        }
        this.validateOwner(newOwner);
        this.removeOwner(ownedEntity, originalOwner);
        this.storeOwner(ownedEntity, newOwner);
    }

    public final EntityUtil.Fields getFields(String fields) {
        if ("*".equals(fields)) {
            return new EntityUtil.Fields(this.allowedFields, String.join((CharSequence)",", this.allowedFields));
        }
        return new EntityUtil.Fields(this.allowedFields, fields);
    }

    protected final EntityUtil.Fields getFields(Set<String> fields) {
        return new EntityUtil.Fields(this.allowedFields, fields);
    }

    public final Set<String> getCommonFields(Set<String> input) {
        HashSet<String> result = new HashSet<String>();
        for (String field : input) {
            if (!this.allowedFields.contains(field)) continue;
            result.add(field);
        }
        return result;
    }

    public final Set<String> getAllowedFieldsCopy() {
        return new HashSet<String>(this.allowedFields);
    }

    protected String getCustomPropertyFQNPrefix(String entityType) {
        return FullyQualifiedName.build(entityType, "customProperties");
    }

    protected String getCustomPropertyFQN(String entityType, String propertyName) {
        return FullyQualifiedName.build(entityType, "customProperties", propertyName);
    }

    protected List<EntityReference> getIngestionPipelines(T service) {
        return this.findTo(service.getId(), this.entityType, Relationship.CONTAINS, "ingestionPipeline");
    }

    protected void checkSystemEntityDeletion(T entity) {
        if (ProviderType.SYSTEM.equals((Object)entity.getProvider())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityDeleteNotAllowed(entity.getName(), this.entityType));
        }
    }

    public final EntityReference validateOwner(EntityReference owner) {
        if (owner == null) {
            return null;
        }
        if (!owner.getType().equals("team") && !owner.getType().equals("user")) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidOwnerType(owner.getType()));
        }
        if (owner.getType().equals("team")) {
            Team team = (Team)Entity.getEntity("team", owner.getId(), "", Include.ALL);
            if (!team.getTeamType().equals((Object)CreateTeam.TeamType.GROUP)) {
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidTeamOwner(team.getTeamType()));
            }
            return team.getEntityReference();
        }
        return Entity.getEntityReferenceById(owner.getType(), owner.getId(), Include.ALL);
    }

    protected void validateTags(T entity) {
        if (!this.supportsTags) {
            return;
        }
        this.validateTags(entity.getTags());
        entity.setTags(TagLabelUtil.addDerivedTags(entity.getTags()));
        TagLabelUtil.checkMutuallyExclusive(entity.getTags());
    }

    protected void validateTags(List<TagLabel> labels) {
        for (TagLabel label : CommonUtil.listOrEmpty(labels)) {
            TagLabelUtil.applyTagCommonFields(label);
        }
    }

    public final EntityReference validateDomain(String domainFqn) {
        if (!this.supportsDomain || domainFqn == null) {
            return null;
        }
        return Entity.getEntityReferenceByName("domain", domainFqn, Include.NON_DELETED);
    }

    public final void validateDomain(EntityReference domain) {
        if (!this.supportsDomain) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidField("domain"));
        }
        Entity.getEntityReferenceById("domain", domain.getId(), Include.NON_DELETED);
    }

    public final void validateDataProducts(List<EntityReference> dataProducts) {
        if (!this.supportsDataProducts) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidField("dataProducts"));
        }
        if (!CommonUtil.nullOrEmpty(dataProducts)) {
            for (EntityReference dataProduct : dataProducts) {
                Entity.getEntityReferenceById("dataProduct", dataProduct.getId(), Include.NON_DELETED);
            }
        }
    }

    public String exportToCsv(String name, String user) throws IOException {
        throw new IllegalArgumentException(CatalogExceptionMessage.csvNotSupported(this.entityType));
    }

    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        throw new IllegalArgumentException(CatalogExceptionMessage.csvNotSupported(this.entityType));
    }

    public List<TagLabel> getAllTags(EntityInterface entity) {
        return entity.getTags();
    }

    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        TaskType taskType = threadContext.getThread().getTask().getType();
        if (EntityUtil.isDescriptionTask(taskType)) {
            return new DescriptionTaskWorkflow(threadContext);
        }
        if (EntityUtil.isTagTask(taskType)) {
            return new TagTaskWorkflow(threadContext);
        }
        throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
    }

    public SuggestionRepository.SuggestionWorkflow getSuggestionWorkflow(EntityInterface entity) {
        return new SuggestionRepository.SuggestionWorkflow(entity);
    }

    public EntityInterface applySuggestion(EntityInterface entity, String childFQN, Suggestion suggestion) {
        return entity;
    }

    public String getSuggestionFields(Suggestion suggestion) {
        return suggestion.getType() == SuggestionType.SuggestTagLabel ? "tags" : "";
    }

    public final void validateTaskThread(FeedRepository.ThreadContext threadContext) {
        ThreadType threadType = threadContext.getThread().getType();
        if (threadType != ThreadType.Task) {
            throw new IllegalArgumentException(String.format("Thread type %s is not task related", threadType));
        }
    }

    protected void validateColumnTags(List<Column> columns) {
        for (Column column : CommonUtil.listOrEmpty(columns)) {
            this.validateTags(column.getTags());
            column.setTags(TagLabelUtil.addDerivedTags(column.getTags()));
            TagLabelUtil.checkMutuallyExclusive(column.getTags());
            if (column.getChildren() == null) continue;
            this.validateColumnTags(column.getChildren());
        }
    }

    public static void validateColumn(Table table, String columnName) {
        boolean validColumn = table.getColumns().stream().anyMatch(col -> col.getName().equals(columnName));
        if (!validColumn) {
            throw new IllegalArgumentException("Invalid column name " + columnName);
        }
    }

    public String getEntityType() {
        return this.entityType;
    }

    public EntityDAO<T> getDao() {
        return this.dao;
    }

    public CollectionDAO getDaoCollection() {
        return this.daoCollection;
    }

    public SearchRepository getSearchRepository() {
        return this.searchRepository;
    }

    public Set<String> getAllowedFields() {
        return this.allowedFields;
    }

    public boolean isSupportsTags() {
        return this.supportsTags;
    }

    public boolean isSupportsOwner() {
        return this.supportsOwner;
    }

    public boolean isSupportsStyle() {
        return this.supportsStyle;
    }

    public boolean isSupportsLifeCycle() {
        return this.supportsLifeCycle;
    }

    public boolean isSupportsDomain() {
        return this.supportsDomain;
    }

    public boolean isSupportsReviewers() {
        return this.supportsReviewers;
    }

    public boolean isSupportsExperts() {
        return this.supportsExperts;
    }

    public EntityUtil.Fields getPatchFields() {
        return this.patchFields;
    }

    public EntityUtil.Fields getPutFields() {
        return this.putFields;
    }

    public static class EntityUpdater {
        private static volatile long sessionTimeoutMillis = 600000L;
        protected T previous;
        protected T original;
        protected T updated;
        protected final Operation operation;
        protected ChangeDescription changeDescription = null;
        protected boolean majorVersionChange = false;
        protected final User updatingUser;
        private boolean entityChanged = false;
        final /* synthetic */ EntityRepository this$0;

        public EntityUpdater(T original, T updated, Operation operation) {
            this.this$0 = this$0;
            this.original = original;
            this.updated = updated;
            this.operation = operation;
            this.updatingUser = updated.getUpdatedBy().equalsIgnoreCase("admin") ? new User().withName("admin").withIsAdmin(Boolean.valueOf(true)) : (User)Entity.getEntityByName("user", updated.getUpdatedBy(), "", Include.NON_DELETED);
        }

        @Transaction
        public final void update() {
            boolean consolidateChanges = this.consolidateChanges(this.original, this.updated, this.operation);
            if (consolidateChanges) {
                this.revert();
            }
            this.changeDescription = new ChangeDescription();
            this.updateInternal();
            this.storeUpdate();
            this.this$0.postUpdate(this.original, this.updated);
        }

        @Transaction
        private void revert() {
            Object updatedOld = this.updated;
            this.previous = this.getPreviousVersion(this.original);
            if (this.previous != null) {
                LOG.debug("In session change consolidation. Reverting to previous version {}", (Object)this.previous.getVersion());
                this.updated = this.previous;
                this.updateInternal();
                LOG.info("In session change consolidation. Reverting to previous version {} completed", (Object)this.previous.getVersion());
                this.updated = updatedOld;
                this.updateInternal();
                this.original = this.previous;
                this.entityChanged = false;
            }
        }

        @Transaction
        private void updateInternal() {
            if (this.operation.isDelete()) {
                this.updateDeleted();
            } else {
                this.updated.setId(this.original.getId());
                this.updateDeleted();
                this.updateDescription();
                this.updateDisplayName();
                this.updateOwner();
                this.updateExtension();
                this.updateTags(this.updated.getFullyQualifiedName(), "tags", this.original.getTags(), this.updated.getTags());
                this.updateDomain();
                this.updateDataProducts();
                this.updateExperts();
                this.updateReviewers();
                this.updateStyle();
                this.updateLifeCycle();
                this.entitySpecificUpdate();
            }
        }

        protected void entitySpecificUpdate() {
        }

        private void updateDescription() {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)this.original.getDescription()) && this.updatedByBot()) {
                this.updated.setDescription(this.original.getDescription());
                return;
            }
            this.recordChange("description", this.original.getDescription(), this.updated.getDescription());
        }

        private void updateDeleted() {
            if (this.operation.isPut() || this.operation.isPatch()) {
                if (!Objects.equals(this.updated.getDeleted(), this.original.getDeleted()) && Boolean.TRUE.equals(this.updated.getDeleted()) && this.changeDescription != null) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.readOnlyAttribute(this.this$0.entityType, "deleted"));
                }
                if (Boolean.TRUE.equals(this.original.getDeleted())) {
                    this.updated.setDeleted(Boolean.valueOf(false));
                    this.recordChange("deleted", true, false);
                }
            } else {
                this.recordChange("deleted", this.original.getDeleted(), this.updated.getDeleted());
            }
        }

        private void updateDisplayName() {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)this.original.getDisplayName()) && this.updatedByBot()) {
                this.updated.setDisplayName(this.original.getDisplayName());
                return;
            }
            this.recordChange("displayName", this.original.getDisplayName(), this.updated.getDisplayName());
        }

        private void updateOwner() {
            EntityReference origOwner = EntityUpdater.getEntityReference(this.original.getOwner());
            EntityReference updatedOwner = EntityUpdater.getEntityReference(this.updated.getOwner());
            if ((this.operation.isPatch() || updatedOwner != null) && this.recordChange("owner", origOwner, updatedOwner, true, EntityUtil.entityReferenceMatch)) {
                this.this$0.updateOwner(this.original, origOwner, updatedOwner);
                this.updated.setOwner(updatedOwner);
            } else {
                this.updated.setOwner(origOwner);
            }
        }

        protected void updateTags(String fqn, String fieldName, List<TagLabel> origTags, List<TagLabel> updatedTags) {
            origTags = CommonUtil.listOrEmpty(origTags);
            updatedTags = Optional.ofNullable(updatedTags).orElse(new ArrayList());
            if (origTags.isEmpty() && updatedTags.isEmpty()) {
                return;
            }
            this.this$0.daoCollection.tagUsageDAO().deleteTagsByTarget(fqn);
            if (this.operation.isPut()) {
                EntityUtil.mergeTags(updatedTags, origTags);
                TagLabelUtil.checkMutuallyExclusive(updatedTags);
            }
            ArrayList addedTags = new ArrayList();
            ArrayList deletedTags = new ArrayList();
            this.recordListChange(fieldName, origTags, updatedTags, addedTags, deletedTags, EntityUtil.tagLabelMatch);
            updatedTags.sort(EntityUtil.compareTagLabel);
            this.this$0.applyTags(updatedTags, fqn);
        }

        private void updateExtension() {
            Object updatedExtension;
            Object origExtension = this.original.getExtension();
            if (origExtension == (updatedExtension = this.updated.getExtension())) {
                return;
            }
            if (this.updatedByBot() && this.operation == Operation.PUT) {
                this.updated.setExtension(origExtension);
                return;
            }
            ArrayList<ObjectNode> added = new ArrayList<ObjectNode>();
            ArrayList<ObjectNode> deleted = new ArrayList<ObjectNode>();
            JsonNode origFields = JsonUtils.valueToTree(origExtension);
            JsonNode updatedFields = JsonUtils.valueToTree(updatedExtension);
            Iterator it = origFields.fields();
            while (it.hasNext()) {
                Map.Entry orig = (Map.Entry)it.next();
                JsonNode updatedField = updatedFields.get((String)orig.getKey());
                if (updatedField == null) {
                    deleted.add(JsonUtils.getObjectNode((String)orig.getKey(), (JsonNode)orig.getValue()));
                    continue;
                }
                this.recordChange(EntityUtil.getExtensionField((String)orig.getKey()), ((JsonNode)orig.getValue()).toString(), updatedField.toString());
            }
            it = updatedFields.fields();
            while (it.hasNext()) {
                Map.Entry updatedField = (Map.Entry)it.next();
                JsonNode orig = origFields.get((String)updatedField.getKey());
                if (orig != null) continue;
                added.add(JsonUtils.getObjectNode((String)updatedField.getKey(), (JsonNode)updatedField.getValue()));
            }
            if (!added.isEmpty()) {
                EntityUtil.fieldAdded(this.changeDescription, "extension", JsonUtils.pojoToJson(added));
            }
            if (!deleted.isEmpty()) {
                EntityUtil.fieldDeleted(this.changeDescription, "extension", JsonUtils.pojoToJson(deleted));
            }
            this.this$0.removeExtension((EntityInterface)this.original);
            this.this$0.storeExtension((EntityInterface)this.updated);
        }

        private void updateDomain() {
            EntityReference updatedDomain;
            EntityReference origDomain = EntityUpdater.getEntityReference(this.original.getDomain());
            if (origDomain == (updatedDomain = EntityUpdater.getEntityReference(this.updated.getDomain()))) {
                return;
            }
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((Object)this.original.getDomain()) && this.updatedByBot()) {
                this.updated.setDomain(this.original.getDomain());
                return;
            }
            if ((this.operation.isPatch() || updatedDomain != null) && this.recordChange("domain", origDomain, updatedDomain, true, EntityUtil.entityReferenceMatch)) {
                if (origDomain != null) {
                    LOG.info("Removing domain {} for entity {}", (Object)origDomain.getFullyQualifiedName(), (Object)this.original.getFullyQualifiedName());
                    this.this$0.deleteRelationship(origDomain.getId(), "domain", this.original.getId(), this.this$0.entityType, Relationship.HAS);
                }
                if (updatedDomain != null) {
                    this.this$0.validateDomain(updatedDomain);
                    LOG.info("Adding domain {} for entity {}", (Object)updatedDomain.getFullyQualifiedName(), (Object)this.original.getFullyQualifiedName());
                    this.this$0.addRelationship(updatedDomain.getId(), this.original.getId(), "domain", this.this$0.entityType, Relationship.HAS);
                }
                this.updated.setDomain(updatedDomain);
            } else {
                this.updated.setDomain(this.original.getDomain());
            }
        }

        private void updateDataProducts() {
            if (!this.this$0.supportsDataProducts) {
                return;
            }
            List origDataProducts = CommonUtil.listOrEmpty((List)this.original.getDataProducts());
            List updatedDataProducts = CommonUtil.listOrEmpty((List)this.updated.getDataProducts());
            this.this$0.validateDataProducts(updatedDataProducts);
            this.updateFromRelationships("dataProducts", "dataProduct", origDataProducts, updatedDataProducts, Relationship.HAS, this.this$0.entityType, this.original.getId());
        }

        private void updateExperts() {
            if (!this.this$0.supportsExperts) {
                return;
            }
            List<EntityReference> origExperts = EntityUpdater.getEntityReferences(this.original.getExperts());
            List<EntityReference> updatedExperts = EntityUpdater.getEntityReferences(this.updated.getExperts());
            this.this$0.validateUsers(updatedExperts);
            this.updateToRelationships("experts", this.this$0.entityType, this.original.getId(), Relationship.EXPERT, "user", origExperts, updatedExperts, false);
            this.updated.setExperts(updatedExperts);
        }

        private void updateReviewers() {
            if (!this.this$0.supportsReviewers) {
                return;
            }
            List<EntityReference> origReviewers = EntityUpdater.getEntityReferences(this.original.getReviewers());
            List<EntityReference> updatedReviewers = EntityUpdater.getEntityReferences(this.updated.getReviewers());
            this.this$0.validateUsers(updatedReviewers);
            this.updateFromRelationships("reviewers", "user", origReviewers, updatedReviewers, Relationship.REVIEWS, this.this$0.entityType, this.original.getId());
            this.updated.setReviewers(updatedReviewers);
        }

        private static EntityReference getEntityReference(EntityReference reference) {
            return reference == null || Boolean.TRUE.equals(reference.getInherited()) ? null : reference;
        }

        private static List<EntityReference> getEntityReferences(List<EntityReference> references) {
            return CommonUtil.listOrEmpty(references).stream().filter(r -> !Boolean.TRUE.equals(r.getInherited())).collect(Collectors.toList());
        }

        private void updateStyle() {
            if (this.this$0.supportsStyle) {
                this.recordChange("style", this.original.getStyle(), this.updated.getStyle(), true);
            }
        }

        private void updateLifeCycle() {
            if (!this.this$0.supportsLifeCycle) {
                return;
            }
            LifeCycle origLifeCycle = this.original.getLifeCycle();
            LifeCycle updatedLifeCycle = this.updated.getLifeCycle();
            if (this.operation == Operation.PUT && updatedLifeCycle == null) {
                updatedLifeCycle = origLifeCycle;
                this.updated.setLifeCycle(origLifeCycle);
            }
            if (origLifeCycle == updatedLifeCycle) {
                return;
            }
            if (origLifeCycle != null && updatedLifeCycle != null) {
                if (origLifeCycle.getCreated() != null && (updatedLifeCycle.getCreated() == null || updatedLifeCycle.getCreated().getTimestamp() < origLifeCycle.getCreated().getTimestamp())) {
                    updatedLifeCycle.setCreated(origLifeCycle.getCreated());
                }
                if (origLifeCycle.getAccessed() != null && (updatedLifeCycle.getAccessed() == null || updatedLifeCycle.getAccessed().getTimestamp() < origLifeCycle.getAccessed().getTimestamp())) {
                    updatedLifeCycle.setAccessed(origLifeCycle.getAccessed());
                }
                if (origLifeCycle.getUpdated() != null && (updatedLifeCycle.getUpdated() == null || updatedLifeCycle.getUpdated().getTimestamp() < origLifeCycle.getUpdated().getTimestamp())) {
                    updatedLifeCycle.setUpdated(origLifeCycle.getUpdated());
                }
            }
            this.recordChange("lifeCycle", origLifeCycle, updatedLifeCycle, true);
        }

        public final boolean updateVersion(Double oldVersion) {
            Double newVersion = oldVersion;
            if (this.majorVersionChange) {
                newVersion = EntityUtil.nextMajorVersion(oldVersion);
            } else if (this.fieldsChanged()) {
                newVersion = EntityUtil.nextVersion(oldVersion);
            }
            LOG.debug("{} {}->{} - Fields added {}, updated {}, deleted {}", new Object[]{this.original.getId(), oldVersion, newVersion, this.changeDescription.getFieldsAdded(), this.changeDescription.getFieldsUpdated(), this.changeDescription.getFieldsDeleted()});
            this.changeDescription.withPreviousVersion(oldVersion);
            this.updated.setVersion(newVersion);
            this.updated.setChangeDescription(this.changeDescription);
            return !newVersion.equals(oldVersion);
        }

        public final boolean fieldsChanged() {
            if (this.changeDescription == null) {
                return false;
            }
            return !this.changeDescription.getFieldsAdded().isEmpty() || !this.changeDescription.getFieldsUpdated().isEmpty() || !this.changeDescription.getFieldsDeleted().isEmpty();
        }

        public final <K> boolean recordChange(String field, K orig, K updated) {
            return this.recordChange(field, orig, updated, false, EntityUtil.objectMatch, true);
        }

        public final <K> boolean recordChange(String field, K orig, K updated, boolean jsonValue) {
            return this.recordChange(field, orig, updated, jsonValue, EntityUtil.objectMatch, true);
        }

        public final <K> boolean recordChange(String field, K orig, K updated, boolean jsonValue, BiPredicate<K, K> typeMatch) {
            return this.recordChange(field, orig, updated, jsonValue, typeMatch, true);
        }

        public final <K> boolean recordChange(String field, K orig, K updated, boolean jsonValue, BiPredicate<K, K> typeMatch, boolean updateVersion) {
            Object newValue;
            if (orig == updated) {
                return false;
            }
            if (!updateVersion && this.entityChanged) {
                return false;
            }
            Object oldValue = jsonValue ? JsonUtils.pojoToJson(orig) : orig;
            Object object = newValue = jsonValue ? JsonUtils.pojoToJson(updated) : updated;
            if (orig == null) {
                this.entityChanged = true;
                if (updateVersion) {
                    EntityUtil.fieldAdded(this.changeDescription, field, newValue);
                }
                return true;
            }
            if (updated == null) {
                this.entityChanged = true;
                if (updateVersion) {
                    EntityUtil.fieldDeleted(this.changeDescription, field, oldValue);
                }
                return true;
            }
            if (!typeMatch.test(orig, updated)) {
                this.entityChanged = true;
                if (updateVersion) {
                    EntityUtil.fieldUpdated(this.changeDescription, field, oldValue, newValue);
                }
                return true;
            }
            return false;
        }

        public final <K> boolean recordListChange(String field, List<K> origList, List<K> updatedList, List<K> addedItems, List<K> deletedItems, BiPredicate<K, K> typeMatch) {
            origList = CommonUtil.listOrEmpty(origList);
            updatedList = CommonUtil.listOrEmpty(updatedList);
            ArrayList updatedItems = new ArrayList();
            for (Object stored : origList) {
                Object u = updatedList.stream().filter(c -> typeMatch.test(c, stored)).findAny().orElse(null);
                if (u != null) continue;
                deletedItems.add(stored);
            }
            for (Object U : updatedList) {
                Object stored = origList.stream().filter(c -> typeMatch.test(c, U)).findAny().orElse(null);
                if (stored == null) {
                    addedItems.add(U);
                    continue;
                }
                if (typeMatch.test(stored, U)) continue;
                updatedItems.add(U);
            }
            if (!addedItems.isEmpty()) {
                EntityUtil.fieldAdded(this.changeDescription, field, JsonUtils.pojoToJson(addedItems));
            }
            if (!updatedItems.isEmpty()) {
                EntityUtil.fieldUpdated(this.changeDescription, field, JsonUtils.pojoToJson(origList), JsonUtils.pojoToJson(updatedItems));
            }
            if (!deletedItems.isEmpty()) {
                EntityUtil.fieldDeleted(this.changeDescription, field, JsonUtils.pojoToJson(deletedItems));
            }
            return !addedItems.isEmpty() || !deletedItems.isEmpty();
        }

        public final void updateToRelationships(String field, String fromEntityType, UUID fromId, Relationship relationshipType, String toEntityType, List<EntityReference> origToRefs, List<EntityReference> updatedToRefs, boolean bidirectional) {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            if (!this.recordListChange(field, origToRefs, updatedToRefs, added, deleted, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteFrom(fromId, fromEntityType, relationshipType, toEntityType);
            if (bidirectional) {
                this.this$0.deleteTo(fromId, fromEntityType, relationshipType, toEntityType);
            }
            for (EntityReference ref : updatedToRefs) {
                this.this$0.addRelationship(fromId, ref.getId(), fromEntityType, toEntityType, relationshipType, bidirectional);
            }
            updatedToRefs.sort(EntityUtil.compareEntityReference);
            origToRefs.sort(EntityUtil.compareEntityReference);
        }

        public final void updateToRelationship(String field, String fromEntityType, UUID fromId, Relationship relationshipType, String toEntityType, EntityReference origToRef, EntityReference updatedToRef, boolean bidirectional) {
            if (!this.recordChange(field, origToRef, updatedToRef, true, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteFrom(fromId, fromEntityType, relationshipType, toEntityType);
            if (bidirectional) {
                this.this$0.deleteTo(fromId, fromEntityType, relationshipType, toEntityType);
            }
            this.this$0.addRelationship(fromId, updatedToRef.getId(), fromEntityType, toEntityType, relationshipType, bidirectional);
        }

        public final void updateFromRelationships(String field, String fromEntityType, List<EntityReference> originFromRefs, List<EntityReference> updatedFromRefs, Relationship relationshipType, String toEntityType, UUID toId) {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            if (!this.recordListChange(field, originFromRefs, updatedFromRefs, added, deleted, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteTo(toId, toEntityType, relationshipType, fromEntityType);
            for (EntityReference ref : updatedFromRefs) {
                this.this$0.addRelationship(ref.getId(), toId, fromEntityType, toEntityType, relationshipType);
            }
            updatedFromRefs.sort(EntityUtil.compareEntityReference);
            originFromRefs.sort(EntityUtil.compareEntityReference);
        }

        public final void updateFromRelationship(String field, String fromEntityType, EntityReference originFromRef, EntityReference updatedFromRef, Relationship relationshipType, String toEntityType, UUID toId) {
            if (!this.recordChange(field, originFromRef, updatedFromRef, true, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteTo(toId, toEntityType, relationshipType, fromEntityType);
            this.this$0.addRelationship(updatedFromRef.getId(), toId, fromEntityType, toEntityType, relationshipType);
        }

        public final void storeUpdate() {
            if (this.updateVersion(this.original.getVersion())) {
                this.storeEntityHistory();
                this.storeNewVersion();
            } else if (this.entityChanged) {
                if (this.updated.getVersion().equals(this.changeDescription.getPreviousVersion())) {
                    this.updated.setChangeDescription(this.original.getChangeDescription());
                }
                this.storeNewVersion();
            } else {
                this.updated.setChangeDescription(this.original.getChangeDescription());
                this.updated.setUpdatedBy(this.original.getUpdatedBy());
                this.updated.setUpdatedAt(this.original.getUpdatedAt());
                if (this.previous != null && this.previous.getVersion().equals(this.updated.getVersion())) {
                    this.storeNewVersion();
                    this.removeEntityHistory(this.updated.getVersion());
                }
            }
        }

        private void storeEntityHistory() {
            String extensionName = EntityUtil.getVersionExtension(this.this$0.entityType, this.original.getVersion());
            this.this$0.daoCollection.entityExtensionDAO().insert(this.original.getId(), extensionName, this.this$0.entityType, JsonUtils.pojoToJson(this.original));
        }

        private void removeEntityHistory(Double version) {
            String extensionName = EntityUtil.getVersionExtension(this.this$0.entityType, version);
            this.this$0.daoCollection.entityExtensionDAO().delete(this.original.getId(), extensionName);
        }

        private void storeNewVersion() {
            this.this$0.storeEntity(this.updated, true);
        }

        public final boolean updatedByBot() {
            return Boolean.TRUE.equals(this.updatingUser.getIsBot());
        }

        @VisibleForTesting
        public static void setSessionTimeout(long timeout) {
            sessionTimeoutMillis = timeout;
        }

        private boolean consolidateChanges(T original, T updated, Operation operation) {
            return original.getVersion() > 0.1 && operation == Operation.PATCH && !Boolean.TRUE.equals(original.getDeleted()) && !operation.isDelete() && original.getUpdatedBy().equals(updated.getUpdatedBy()) && updated.getUpdatedAt() - original.getUpdatedAt() <= sessionTimeoutMillis;
        }

        private T getPreviousVersion(T original) {
            String extensionName = EntityUtil.getVersionExtension(this.this$0.entityType, original.getChangeDescription().getPreviousVersion());
            String json = this.this$0.daoCollection.entityExtensionDAO().getExtension(original.getId(), extensionName);
            return (EntityInterface)JsonUtils.readValue(json, this.this$0.entityClass);
        }
    }

    public static enum Operation {
        PUT,
        PATCH,
        SOFT_DELETE;


        public boolean isPatch() {
            return this == PATCH;
        }

        public boolean isPut() {
            return this == PUT;
        }

        public boolean isDelete() {
            return this == SOFT_DELETE;
        }
    }

    public static class DescriptionTaskWorkflow
    extends FeedRepository.TaskWorkflow {
        DescriptionTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            EntityInterface aboutEntity = this.threadContext.getAboutEntity();
            aboutEntity.setDescription(resolveTask.getNewValue());
            return aboutEntity;
        }
    }

    public static class TagTaskWorkflow
    extends FeedRepository.TaskWorkflow {
        TagTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            EntityInterface aboutEntity = this.threadContext.getAboutEntity();
            aboutEntity.setTags(tags);
            return aboutEntity;
        }
    }

    static class EntityLoaderWithName
    extends CacheLoader<Pair<String, String>, EntityInterface> {
        EntityLoaderWithName() {
        }

        @NonNull
        public EntityInterface load(@NotNull Pair<String, String> fqnPair) {
            String entityType = (String)fqnPair.getLeft();
            String fqn = (String)fqnPair.getRight();
            EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
            return repository.getDao().findEntityByName(fqn, Include.ALL);
        }
    }

    static class EntityLoaderWithId
    extends CacheLoader<Pair<String, UUID>, EntityInterface> {
        EntityLoaderWithId() {
        }

        @NonNull
        public EntityInterface load(@NotNull Pair<String, UUID> idPair) {
            String entityType = (String)idPair.getLeft();
            UUID id = (UUID)idPair.getRight();
            EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
            return repository.getDao().findEntityById(id, Include.ALL);
        }
    }

    static abstract class ColumnEntityUpdater
    extends EntityUpdater {
        final /* synthetic */ EntityRepository this$0;

        protected ColumnEntityUpdater(T original, T updated, Operation operation) {
            this.this$0 = this$0;
            super((EntityRepository)this$0, original, updated, operation);
        }

        public void updateColumns(String fieldName, List<Column> origColumns, List<Column> updatedColumns, BiPredicate<Column, Column> columnMatch) {
            ArrayList deletedColumns = new ArrayList();
            ArrayList addedColumns = new ArrayList();
            this.recordListChange(fieldName, origColumns, updatedColumns, addedColumns, deletedColumns, columnMatch);
            Map addedColumnMap = addedColumns.stream().collect(Collectors.toMap(Column::getName, Function.identity()));
            for (Column deleted2 : deletedColumns) {
                if (!addedColumnMap.containsKey(deleted2.getName())) continue;
                Column addedColumn = (Column)addedColumnMap.get(deleted2.getName());
                if (CommonUtil.nullOrEmpty((String)addedColumn.getDescription())) {
                    addedColumn.setDescription(deleted2.getDescription());
                }
                if (!CommonUtil.nullOrEmpty((List)addedColumn.getTags()) || !CommonUtil.nullOrEmpty((List)deleted2.getTags())) continue;
                addedColumn.setTags(deleted2.getTags());
            }
            deletedColumns.forEach(deleted -> this.this$0.daoCollection.tagUsageDAO().deleteTagsByTarget(deleted.getFullyQualifiedName()));
            for (Column added : addedColumns) {
                this.this$0.applyTags(added.getTags(), added.getFullyQualifiedName());
            }
            for (Column updated : updatedColumns) {
                Column stored = origColumns.stream().filter(c -> columnMatch.test((Column)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateColumnDescription(stored, updated);
                this.updateColumnDisplayName(stored, updated);
                this.updateColumnDataLength(stored, updated);
                this.updateColumnPrecision(stored, updated);
                this.updateColumnScale(stored, updated);
                this.updateTags(stored.getFullyQualifiedName(), EntityUtil.getFieldName(fieldName, updated.getName(), "tags"), stored.getTags(), updated.getTags());
                this.updateColumnConstraint(stored, updated);
                if (updated.getChildren() == null || stored.getChildren() == null) continue;
                String childrenFieldName = EntityUtil.getFieldName(fieldName, updated.getName());
                this.updateColumns(childrenFieldName, stored.getChildren(), updated.getChildren(), columnMatch);
            }
            this.majorVersionChange = this.majorVersionChange || !deletedColumns.isEmpty();
        }

        private void updateColumnDescription(Column origColumn, Column updatedColumn) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origColumn.getDescription()) && this.updatedByBot()) {
                updatedColumn.setDescription(origColumn.getDescription());
                return;
            }
            String columnField = EntityUtil.getColumnField(origColumn, "description");
            this.recordChange(columnField, origColumn.getDescription(), updatedColumn.getDescription());
        }

        private void updateColumnDisplayName(Column origColumn, Column updatedColumn) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origColumn.getDisplayName()) && this.updatedByBot()) {
                updatedColumn.setDisplayName(origColumn.getDisplayName());
                return;
            }
            String columnField = EntityUtil.getColumnField(origColumn, "displayName");
            this.recordChange(columnField, origColumn.getDisplayName(), updatedColumn.getDisplayName());
        }

        private void updateColumnConstraint(Column origColumn, Column updatedColumn) {
            String columnField = EntityUtil.getColumnField(origColumn, "constraint");
            this.recordChange(columnField, origColumn.getConstraint(), updatedColumn.getConstraint());
        }

        protected void updateColumnDataLength(Column origColumn, Column updatedColumn) {
            String columnField = EntityUtil.getColumnField(origColumn, "dataLength");
            boolean updated = this.recordChange(columnField, origColumn.getDataLength(), updatedColumn.getDataLength());
            if (updated && (origColumn.getDataLength() == null || updatedColumn.getDataLength() < origColumn.getDataLength())) {
                this.majorVersionChange = true;
            }
        }

        private void updateColumnPrecision(Column origColumn, Column updatedColumn) {
            String columnField = EntityUtil.getColumnField(origColumn, "precision");
            boolean updated = this.recordChange(columnField, origColumn.getPrecision(), updatedColumn.getPrecision());
            if (origColumn.getPrecision() != null && updated && (updatedColumn.getPrecision() == null || updatedColumn.getPrecision() < origColumn.getPrecision())) {
                this.majorVersionChange = true;
            }
        }

        private void updateColumnScale(Column origColumn, Column updatedColumn) {
            String columnField = EntityUtil.getColumnField(origColumn, "scale");
            boolean updated = this.recordChange(columnField, origColumn.getScale(), updatedColumn.getScale());
            if (origColumn.getScale() != null && updated && (updatedColumn.getScale() == null || updatedColumn.getScale() < origColumn.getScale())) {
                this.majorVersionChange = true;
            }
        }
    }
}

