/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.datainsight;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.dataInsight.CreateDataInsightChart;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.type.DataReportIndex;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/analytics/dataInsights/charts")
@Tag(name="Data Insights", description="APIs related to Data Insights data and charts.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="analytics")
public class DataInsightChartResource
extends EntityResource<DataInsightChart, DataInsightChartRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightChartResource.class);
    public static final String COLLECTION_PATH = "/v1/analytics/dataInsights/charts";
    public static final String FIELDS = "owner";
    private final SearchRepository searchRepository = Entity.getSearchRepository();

    public DataInsightChartResource(Authorizer authorizer) {
        super("dataInsightChart", authorizer);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List dataInsightCharts = ((DataInsightChartRepository)this.repository).getEntitiesFromSeedData(".*json/data/dataInsight/.*\\.json$");
        for (DataInsightChart dataInsightChart : dataInsightCharts) {
            ((DataInsightChartRepository)this.repository).initializeEntity(dataInsightChart);
        }
    }

    @GET
    @Operation(operationId="listDataInsightChart", summary="List data insight charts", description="Get a list of data insight charts", responses={@ApiResponse(responseCode="200", description="List of data insight charts", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChartList.class))})})
    public ResultList<DataInsightChart> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number data insight chart returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of data insight chart before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of data insight chart after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listDataInsightChartVersion", summary="List data insight chart versions", description="Get a list of all the versions of a data insight chart identified by `id`", responses={@ApiResponse(responseCode="200", description="List of data insight chart versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the data insight chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="listDataInsightChartId", summary="Get a data insight chart by Id", description="Get a Data Insight Chart by `Id`.", responses={@ApiResponse(responseCode="200", description="The Data Insight Chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="404", description="Data Insight Chart for instance {id} is not found")})
    public DataInsightChart get(@Context UriInfo uriInfo, @Parameter(description="Id of the data insight chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DataInsightChart)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getDataInsightChartByName", summary="Get a data insight chart by fully qualified name", description="Get a data insight chart by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The data insight chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="404", description="Data Insight Chart for instance {fqn} is not found")})
    public DataInsightChart getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the data insight chart", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DataInsightChart)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDataInsightChartVersion", summary="Get a version of the data insight chart", description="Get a version of the data insight by given `Id`", responses={@ApiResponse(responseCode="200", description="DataInsight", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="404", description="Data Insight Chart for instance {id} and version {version} is not found")})
    public DataInsightChart getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the data insight chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Data Insight Chart version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (DataInsightChart)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDataInsightChart", summary="Create a data insight chart", description="Create a data insight chart.", responses={@ApiResponse(responseCode="200", description="The data insight chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDataInsightChart create) {
        DataInsightChart dataInsightChart = this.getDataInsightChart(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, dataInsightChart);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDataInsightChart", summary="Update a data insight chart", description="Update an existing data insight chart using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the data insight chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchDataInsightChart", summary="Update a data insight chart by name.", description="Update an existing data insight chart using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the data insight chart", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDataInsightChart", summary="Update data insight chart", description="Create a data insight chart, if it does not exist or update an existing data insight chart.", responses={@ApiResponse(responseCode="200", description="The updated data insight chart ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDataInsightChart create) {
        DataInsightChart dataInsightChart = this.getDataInsightChart(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, dataInsightChart);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDataInsightChart", summary="Delete a data insight chart by Id", description="Delete a data insight chart by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Data insight chart for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the data insight chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteDataInsightChartByName", summary="Delete a data insight chart by fully qualified name", description="Delete a data insight chart by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Data insight chart for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the data insight chart", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted data insight chart", description="Restore a soft deleted data insight chart.", responses={@ApiResponse(responseCode="200", description="Successfully restored the DataInsightChart. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))})})
    public Response restoreDataInsightChart(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/aggregate")
    @Operation(operationId="getDataInsightChartResults", summary="Get aggregated data for a data insight chart", description="Get aggregated data for a data insight chart.", responses={@ApiResponse(responseCode="200", description="Data Insight Chart Results", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChartResultList.class))})})
    public Response listDataInsightChartResult(@Context SecurityContext securityContext, @Parameter(description="Get aggregated data for a specific chart name", schema=@Schema(implementation=DataInsightChartResult.DataInsightChartType.class)) @QueryParam(value="dataInsightChartName") @NonNull DataInsightChartResult.DataInsightChartType dataInsightChartName, @Parameter(description="Query filter for the aggregation") @QueryParam(value="queryFilter") String queryFilter, @Parameter(description="Limit the number of results returned.") @DefaultValue(value="10") @QueryParam(value="size") Integer size, @Parameter(description="Offset the results returned. (default = 0)") @DefaultValue(value="0") @QueryParam(value="from") Integer from, @Parameter(description="Specify the elasticsearch index to fetch data from", schema=@Schema(implementation=DataReportIndex.class)) @QueryParam(value="dataReportIndex") @NonNull String dataReportIndex, @Parameter(description="Tier filter. The value will be used to filter results", schema=@Schema(type="string", example="Tier.Tier1,Tier.Tier2,Tier.Tier3,Tier.Tier4,Tier.Tier5")) @QueryParam(value="tier") String tier, @Parameter(description="Team filter. The value will be used to filter results", schema=@Schema(type="string")) @QueryParam(value="team") String team, @Parameter(description="Organization filter. The value will be used to filter results", schema=@Schema(type="string")) @QueryParam(value="organization") String organization, @Parameter(description="Filter after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") Long endTs) throws IOException, ParseException {
        if (dataInsightChartName == null) {
            throw new NullPointerException("dataInsightChartName is marked non-null but is null");
        }
        if (dataReportIndex == null) {
            throw new NullPointerException("dataReportIndex is marked non-null but is null");
        }
        OperationContext operationContext = new OperationContext("dataInsightChart", MetadataOperation.VIEW_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContext());
        return this.searchRepository.listDataInsightChartResult(startTs, endTs, tier, team, dataInsightChartName, size, from, queryFilter, dataReportIndex);
    }

    private DataInsightChart getDataInsightChart(CreateDataInsightChart create, String user) {
        return ((DataInsightChartRepository)this.repository).copy(new DataInsightChart(), (CreateEntity)create, user).withName(create.getName()).withDescription(create.getDescription()).withDataIndexType(create.getDataIndexType()).withDimensions(create.getDimensions()).withMetrics(create.getMetrics()).withDisplayName(create.getDisplayName());
    }

    public static class DataInsightChartResultList
    extends ResultList<DataInsightChartResult> {
    }

    public static class DataInsightChartList
    extends ResultList<DataInsightChart> {
    }
}

