/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.topics;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateTopic;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.topic.TopicSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TopicRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/topics")
@Tag(name="Topics", description="A `Topic` is a feed or an event stream in a `Messaging Service` into which publishers publish messages and consumed by consumers.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="topics")
public class TopicResource
extends EntityResource<Topic, TopicRepository> {
    public static final String COLLECTION_PATH = "v1/topics/";
    static final String FIELDS = "owner,followers,tags,extension,domain,dataProducts,sourceHash";

    @Override
    public Topic addHref(UriInfo uriInfo, Topic topic) {
        super.addHref(uriInfo, topic);
        Entity.withHref(uriInfo, topic.getService());
        return topic;
    }

    public TopicResource(Authorizer authorizer) {
        super("topic", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("sampleData", MetadataOperation.VIEW_SAMPLE_DATA);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_SAMPLE_DATA, MetadataOperation.EDIT_SAMPLE_DATA});
    }

    @GET
    @Operation(operationId="listTopics", summary="List topics", description="Get a list of topics, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of topics", content={@Content(mediaType="application/json", schema=@Schema(implementation=TopicList.class))})})
    public ResultList<Topic> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter topics by service name", schema=@Schema(type="string", example="kafkaWestCoast")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number topics returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of topics before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of topics after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTopicVersion", summary="List topic versions", description="Get a list of all the versions of a topic identified by `id`", responses={@ApiResponse(responseCode="200", description="List of topic versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a topic by id", description="Get a topic by `id`.", responses={@ApiResponse(responseCode="200", description="The topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))}), @ApiResponse(responseCode="404", description="Topic for instance {id} is not found")})
    public Topic get(@Context UriInfo uriInfo, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Topic)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getTopicByFQN", summary="Get a topic by fully qualified name", description="Get a topic by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))}), @ApiResponse(responseCode="404", description="Topic for instance {fqn} is not found")})
    public Topic getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the topic", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Topic)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTopicVersion", summary="Get a version of the topic", description="Get a version of the topic by given `id`", responses={@ApiResponse(responseCode="200", description="topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))}), @ApiResponse(responseCode="404", description="Topic for instance {id} and version {version} is not found")})
    public Topic getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Topic version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Topic)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createTopic", summary="Create a topic", description="Create a topic under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTopic create) {
        Topic topic = this.getTopic(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, topic);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTopic", summary="Update a topic", description="Update an existing topic using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchTopic", summary="Update a topic using name.", description="Update an existing topic using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the topic", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTopic", summary="Update topic", description="Create a topic, it it does not exist or update an existing topic.", responses={@ApiResponse(responseCode="200", description="The updated topic ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTopic create) {
        Topic topic = this.getTopic(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, topic);
    }

    @PUT
    @Path(value="/{id}/sampleData")
    @Operation(operationId="addSampleData", summary="Add sample data", description="Add sample data to the topic.", responses={@ApiResponse(responseCode="200", description="The topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))})})
    public Topic addSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TopicSampleData sampleData) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_SAMPLE_DATA);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Topic topic = ((TopicRepository)this.repository).addSampleData(id, sampleData);
        return this.addHref(uriInfo, topic);
    }

    @GET
    @Path(value="/{id}/sampleData")
    @Operation(operationId="getSampleData", summary="Get sample data", description="Get sample data from the topic.", responses={@ApiResponse(responseCode="200", description="Successfully obtained the Topic", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))})})
    public Topic getSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_SAMPLE_DATA);
        ResourceContext resourceContext = this.getResourceContextById(id);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        boolean authorizePII = this.authorizer.authorizePII(securityContext, resourceContext.getOwner());
        Topic topic = ((TopicRepository)this.repository).getSampleData(id, authorizePII);
        return this.addHref(uriInfo, topic);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollower", summary="Add a follower", description="Add a user identified by `userId` as followed of this topic", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="Topic for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) {
        return ((TopicRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(summary="Remove a follower", description="Remove the user identified `userId` as a follower of the topic.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) {
        return ((TopicRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, UUID.fromString(userId)).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((TopicRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTopic", summary="Delete a topic by id", description="Delete a topic by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Topic for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the topic", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteTopicByFQN", summary="Delete a topic by fully qualified name", description="Delete a topic by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Topic for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the topic", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted topic", description="Restore a soft deleted topic.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Topic. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))})})
    public Response restoreTopic(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Topic getTopic(CreateTopic create, String user) {
        return ((TopicRepository)this.repository).copy(new Topic(), (CreateEntity)create, user).withService(this.getEntityReference("messagingService", create.getService())).withPartitions(create.getPartitions()).withMessageSchema(create.getMessageSchema()).withCleanupPolicies(create.getCleanupPolicies()).withMaximumMessageSize(create.getMaximumMessageSize()).withMinimumInSyncReplicas(create.getMinimumInSyncReplicas()).withRetentionSize(create.getRetentionSize()).withRetentionTime(create.getRetentionTime()).withReplicationFactor(create.getReplicationFactor()).withTopicConfig(create.getTopicConfig()).withSourceUrl(create.getSourceUrl()).withSourceHash(create.getSourceHash());
    }

    public static class TopicList
    extends ResultList<Topic> {
    }
}

