/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LineageDetails;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.LineageRepository;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface SearchIndex {
    public static final Set<String> DEFAULT_EXCLUDED_FIELDS = Set.of("changeDescription");

    default public Map<String, Object> buildSearchIndexDoc() {
        Map<String, Object> esDoc = JsonUtils.getMap(this.getEntity());
        this.removeNonIndexableFields(esDoc);
        return this.buildSearchIndexDocInternal(esDoc);
    }

    default public void removeNonIndexableFields(Map<String, Object> esDoc) {
        SearchIndexUtils.removeNonIndexableFields(esDoc, DEFAULT_EXCLUDED_FIELDS);
        SearchIndexUtils.removeNonIndexableFields(esDoc, this.getExcludedFields());
    }

    public Object getEntity();

    default public Set<String> getExcludedFields() {
        return Collections.emptySet();
    }

    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> var1);

    default public List<SearchSuggest> getSuggest() {
        return null;
    }

    default public Map<String, Object> getCommonAttributesMap(EntityInterface entity, String entityType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<SearchSuggest> suggest = this.getSuggest();
        map.put("entityType", entityType);
        map.put("owner", this.getEntityWithDisplayName(entity.getOwner()));
        map.put("domain", this.getEntityWithDisplayName(entity.getDomain()));
        map.put("followers", SearchIndexUtils.parseFollowers(entity.getFollowers()));
        map.put("totalVotes", CommonUtil.nullOrEmpty((Object)entity.getVotes()) ? 0 : entity.getVotes().getUpVotes() - entity.getVotes().getDownVotes());
        map.put("descriptionStatus", this.getDescriptionStatus(entity));
        map.put("suggest", suggest);
        map.put("fqnParts", this.getFQNParts(entity.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        return map;
    }

    default public Set<String> getFQNParts(String fqn, List<String> fqnSplits) {
        HashSet<String> fqnParts = new HashSet<String>();
        fqnParts.add(fqn);
        String parent = FullyQualifiedName.getParentFQN(fqn);
        while (parent != null) {
            fqnParts.add(parent);
            parent = FullyQualifiedName.getParentFQN(parent);
        }
        fqnParts.addAll(fqnSplits);
        return fqnParts;
    }

    default public EntityReference getEntityWithDisplayName(EntityReference entity) {
        EntityReference cloneEntity;
        if (entity == null) {
            return null;
        }
        cloneEntity.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneEntity = JsonUtils.deepCopy(entity, EntityReference.class)).getDisplayName()) ? cloneEntity.getName() : cloneEntity.getDisplayName());
        return cloneEntity;
    }

    default public String getDescriptionStatus(EntityInterface entity) {
        return CommonUtil.nullOrEmpty((String)entity.getDescription()) ? "INCOMPLETE" : "COMPLETE";
    }

    public static List<Map<String, Object>> getLineageData(EntityReference entity) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        CollectionDAO dao = Entity.getCollectionDAO();
        List<CollectionDAO.EntityRelationshipRecord> toRelationshipsRecords = dao.relationshipDAO().findTo(entity.getId(), entity.getType(), Relationship.UPSTREAM.ordinal());
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : toRelationshipsRecords) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            data.add(LineageRepository.buildRelationshipDetailsMap(entity, ref, lineageDetails));
        }
        List<CollectionDAO.EntityRelationshipRecord> fromRelationshipsRecords = dao.relationshipDAO().findFrom(entity.getId(), entity.getType(), Relationship.UPSTREAM.ordinal());
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : fromRelationshipsRecords) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            data.add(LineageRepository.buildRelationshipDetailsMap(ref, entity, lineageDetails));
        }
        return data;
    }

    public static Map<String, Float> getDefaultFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(10.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(10.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("displayName.keyword", Float.valueOf(8.0f));
        fields.put("name.keyword", Float.valueOf(8.0f));
        fields.put("description", Float.valueOf(2.0f));
        fields.put("fullyQualifiedName", Float.valueOf(5.0f));
        fields.put("fqnParts", Float.valueOf(5.0f));
        return fields;
    }

    public static Map<String, Float> getAllFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.putAll(TableIndex.getFields());
        fields.putAll(DashboardIndex.getFields());
        fields.putAll(DashboardDataModelIndex.getFields());
        fields.putAll(PipelineIndex.getFields());
        fields.putAll(TopicIndex.getFields());
        fields.putAll(MlModelIndex.getFields());
        fields.putAll(ContainerIndex.getFields());
        fields.putAll(SearchEntityIndex.getFields());
        fields.putAll(GlossaryTermIndex.getFields());
        fields.putAll(TagIndex.getFields());
        fields.putAll(DataProductIndex.getFields());
        return fields;
    }
}

