/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record StoredProcedureIndex(StoredProcedure storedProcedure) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.storedProcedure;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.storedProcedure, "storedProcedure");
        doc.putAll(commonAttributes);
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("storedProcedure", (EntityInterface)this.storedProcedure));
        doc.put("tags", parseTags.getTags());
        doc.put("lineage", SearchIndex.getLineageData(this.storedProcedure.getEntityReference()));
        doc.put("tier", parseTags.getTierTag());
        doc.put("service", this.getEntityWithDisplayName(this.storedProcedure.getService()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

