/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.TestSuiteIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record TestCaseResolutionStatusIndex(TestCaseResolutionStatus testCaseResolutionStatus) implements SearchIndex
{
    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testCaseResolutionStatus.getTestCaseReference().getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testCaseResolutionStatus.getTestCaseReference().getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testCaseResolutionStatus.getTestCaseReference().getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        this.setParentRelationships(doc);
        return doc;
    }

    @Override
    public Object getEntity() {
        return this.testCaseResolutionStatus;
    }

    private void setParentRelationships(Map<String, Object> doc) {
        EntityReference testCaseReference = this.testCaseResolutionStatus.getTestCaseReference();
        TestCase testCase = (TestCase)Entity.getEntityOrNull(testCaseReference, "testSuite", Include.ALL);
        if (testCase == null) {
            return;
        }
        doc.put("testCase", testCase.getEntityReference());
        TestSuite testSuite = (TestSuite)Entity.getEntityOrNull(testCase.getTestSuite(), "", Include.ALL);
        if (testSuite == null) {
            return;
        }
        doc.put("testSuite", testSuite.getEntityReference());
        TestSuiteIndex.addTestSuiteParentEntityRelations(testSuite.getExecutableEntityReference(), doc);
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("testCaseResolutionStatusType", Float.valueOf(1.0f));
        fields.put("testCaseReference.displayName", Float.valueOf(15.0f));
        fields.put("testCaseReference.name", Float.valueOf(10.0f));
        fields.put("testCaseReference.description", Float.valueOf(1.0f));
        fields.put("testCaseResolutionStatusDetails.resolved.testCaseFailureComment", Float.valueOf(10.0f));
        return fields;
    }
}

