/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketNotificationHandler.class);
    private final ExecutorService threadScheduler = Executors.newFixedThreadPool(1);

    public void processNotifications(ContainerResponseContext responseContext) {
        this.threadScheduler.submit(() -> {
            try {
                this.handleNotifications(responseContext);
            }
            catch (Exception ex) {
                LOG.error("[NotificationHandler] Failed to use mapper in converting to Json", (Throwable)ex);
            }
        });
    }

    private void handleNotifications(ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        if (responseCode == Response.Status.CREATED.getStatusCode() && responseContext.getEntity() != null && responseContext.getEntity().getClass().equals(Thread.class)) {
            Thread thread = (Thread)responseContext.getEntity();
            switch (thread.getType()) {
                case Task: {
                    WebsocketNotificationHandler.handleTaskNotification(thread);
                    break;
                }
                case Conversation: {
                    this.handleConversationNotification(thread);
                    break;
                }
                case Announcement: {
                    this.handleAnnouncementNotification(thread);
                }
            }
        }
    }

    public static void handleTaskNotification(Thread thread) {
        String jsonThread = JsonUtils.pojoToJson(thread);
        if (thread.getPostsCount() == 0) {
            List assignees = thread.getTask().getAssignees();
            HashSet<UUID> receiversList = new HashSet<UUID>();
            assignees.forEach(e -> {
                if ("user".equals(e.getType())) {
                    receiversList.add(e.getId());
                } else if ("team".equals(e.getType())) {
                    List<CollectionDAO.EntityRelationshipRecord> records = Entity.getCollectionDAO().relationshipDAO().findTo(e.getId(), "team", Relationship.HAS.ordinal(), "user");
                    records.forEach(eRecord -> receiversList.add(eRecord.getId()));
                }
            });
            WebSocketManager.getInstance().sendToManyWithUUID(receiversList, "taskChannel", jsonThread);
        } else {
            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
            List<MessageParser.EntityLink> mentions = MessageParser.getEntityLinks(latestPost.getMessage());
            WebsocketNotificationHandler.notifyMentionedUsers(mentions, jsonThread);
        }
    }

    private void handleAnnouncementNotification(Thread thread) {
        String jsonThread = JsonUtils.pojoToJson(thread);
        AnnouncementDetails announcementDetails = thread.getAnnouncement();
        Long currentTimestamp = Instant.now().getEpochSecond();
        if (announcementDetails.getStartTime() <= currentTimestamp && currentTimestamp <= announcementDetails.getEndTime()) {
            WebSocketManager.getInstance().broadCastMessageToAll("announcementChannel", jsonThread);
        }
    }

    private void handleConversationNotification(Thread thread) {
        List<MessageParser.EntityLink> mentions;
        String jsonThread = JsonUtils.pojoToJson(thread);
        WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
        if (thread.getPostsCount() == 0) {
            mentions = MessageParser.getEntityLinks(thread.getMessage());
        } else {
            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
            mentions = MessageParser.getEntityLinks(latestPost.getMessage());
        }
        WebsocketNotificationHandler.notifyMentionedUsers(mentions, jsonThread);
    }

    private static void notifyMentionedUsers(List<MessageParser.EntityLink> mentions, String jsonThread) {
        mentions.forEach(entityLink -> {
            String fqn = entityLink.getEntityFQN();
            if ("user".equals(entityLink.getEntityType())) {
                User user = (User)Entity.getCollectionDAO().userDAO().findEntityByName(fqn);
                WebSocketManager.getInstance().sendToOne(user.getId(), "mentionChannel", jsonThread);
            } else if ("team".equals(entityLink.getEntityType())) {
                Team team = (Team)Entity.getCollectionDAO().teamDAO().findEntityByName(fqn);
                List<CollectionDAO.EntityRelationshipRecord> records = Entity.getCollectionDAO().relationshipDAO().findTo(team.getId(), "team", Relationship.HAS.ordinal(), "user");
                WebSocketManager.getInstance().sendToManyWithString(records, "mentionChannel", jsonThread);
            }
        });
    }
}

