/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.scheduler;

import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomJobFactory
extends SimpleJobFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CustomJobFactory.class);
    private final CollectionDAO collectionDAO;
    private final SearchRepository searchRepository;

    public CustomJobFactory(CollectionDAO collectionDAO, SearchRepository searchRepository) {
        this.collectionDAO = collectionDAO;
        this.searchRepository = searchRepository;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler Scheduler2) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class jobClass = jobDetail.getJobClass();
        try {
            LOG.debug("Producing instance of Job '" + jobDetail.getKey() + "', class=" + jobClass.getName());
            return (Job)jobClass.getDeclaredConstructor(CollectionDAO.class, SearchRepository.class).newInstance(this.collectionDAO, this.searchRepository);
        }
        catch (Exception var7) {
            throw new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", (Throwable)var7);
        }
    }
}

