/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import es.org.elasticsearch.ElasticsearchStatusException;
import es.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import es.org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import es.org.elasticsearch.action.bulk.BulkItemResponse;
import es.org.elasticsearch.action.bulk.BulkRequest;
import es.org.elasticsearch.action.bulk.BulkResponse;
import es.org.elasticsearch.action.delete.DeleteRequest;
import es.org.elasticsearch.action.get.GetRequest;
import es.org.elasticsearch.action.get.GetResponse;
import es.org.elasticsearch.action.search.SearchResponse;
import es.org.elasticsearch.action.support.WriteRequest;
import es.org.elasticsearch.action.support.master.AcknowledgedResponse;
import es.org.elasticsearch.action.update.UpdateRequest;
import es.org.elasticsearch.client.RequestOptions;
import es.org.elasticsearch.client.RestClient;
import es.org.elasticsearch.client.RestClientBuilder;
import es.org.elasticsearch.client.RestHighLevelClient;
import es.org.elasticsearch.client.RestHighLevelClientBuilder;
import es.org.elasticsearch.client.indices.CreateIndexRequest;
import es.org.elasticsearch.client.indices.CreateIndexResponse;
import es.org.elasticsearch.client.indices.GetIndexRequest;
import es.org.elasticsearch.client.indices.PutMappingRequest;
import es.org.elasticsearch.common.lucene.search.function.CombineFunction;
import es.org.elasticsearch.common.settings.Settings;
import es.org.elasticsearch.common.unit.Fuzziness;
import es.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import es.org.elasticsearch.core.TimeValue;
import es.org.elasticsearch.index.query.BoolQueryBuilder;
import es.org.elasticsearch.index.query.MatchQueryBuilder;
import es.org.elasticsearch.index.query.MultiMatchQueryBuilder;
import es.org.elasticsearch.index.query.Operator;
import es.org.elasticsearch.index.query.QueryBuilder;
import es.org.elasticsearch.index.query.QueryBuilders;
import es.org.elasticsearch.index.query.QueryStringQueryBuilder;
import es.org.elasticsearch.index.query.RangeQueryBuilder;
import es.org.elasticsearch.index.query.ScriptQueryBuilder;
import es.org.elasticsearch.index.query.TermQueryBuilder;
import es.org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import es.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import es.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import es.org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import es.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import es.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import es.org.elasticsearch.rest.RestStatus;
import es.org.elasticsearch.script.Script;
import es.org.elasticsearch.script.ScriptType;
import es.org.elasticsearch.search.SearchHit;
import es.org.elasticsearch.search.SearchHits;
import es.org.elasticsearch.search.SearchModule;
import es.org.elasticsearch.search.aggregations.AggregationBuilder;
import es.org.elasticsearch.search.aggregations.AggregationBuilders;
import es.org.elasticsearch.search.aggregations.BucketOrder;
import es.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import es.org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import es.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import es.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import es.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import es.org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import es.org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import es.org.elasticsearch.search.builder.SearchSourceBuilder;
import es.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import es.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import es.org.elasticsearch.search.sort.FieldSortBuilder;
import es.org.elasticsearch.search.sort.NestedSortBuilder;
import es.org.elasticsearch.search.sort.SortBuilder;
import es.org.elasticsearch.search.sort.SortBuilders;
import es.org.elasticsearch.search.sort.SortMode;
import es.org.elasticsearch.search.sort.SortOrder;
import es.org.elasticsearch.search.suggest.Suggest;
import es.org.elasticsearch.search.suggest.SuggestBuilder;
import es.org.elasticsearch.search.suggest.SuggestBuilders;
import es.org.elasticsearch.search.suggest.SuggestionBuilder;
import es.org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import es.org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import es.org.elasticsearch.xcontent.DeprecationHandler;
import es.org.elasticsearch.xcontent.NamedXContentRegistry;
import es.org.elasticsearch.xcontent.XContentParser;
import es.org.elasticsearch.xcontent.XContentType;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.DataInsightInterface;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.entity.data.EntityHierarchy__1;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.sdk.exception.SearchException;
import org.openmetadata.sdk.exception.SearchIndexNotFoundException;
import org.openmetadata.service.Entity;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.exception.CatalogGenericExceptionMapper;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.search.EntityBuilderConstant;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.SearchSortFilter;
import org.openmetadata.service.search.elasticsearch.ElasticSearchEntitiesProcessor;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUnusedAssetsCountAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUsedvsUnusedAssetsCountAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUsedvsUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchDailyActiveUsersAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchEntitiesDescriptionAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchEntitiesOwnerAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchMostActiveUsersAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchMostViewedEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchPageViewsByEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchServicesDescriptionAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchServicesOwnerAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchTotalEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchTotalEntitiesByTierAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchUnusedAssetsAggregator;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.DomainIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.QueryIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.StoredProcedureIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.TestCaseResolutionStatusIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements SearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClient.class);
    private final RestHighLevelClient client;
    private final boolean isClientAvailable;
    private static final NamedXContentRegistry xContentRegistry;
    private final String clusterAlias;
    private static final Set<String> FIELDS_TO_REMOVE;

    public ElasticSearchClient(ElasticSearchConfiguration config) {
        this.client = this.createElasticSearchClient(config);
        this.clusterAlias = config != null ? config.getClusterAlias() : "";
        this.isClientAvailable = this.client != null;
    }

    @Override
    public boolean isClientAvailable() {
        return this.isClientAvailable;
    }

    @Override
    public boolean indexExists(String indexName) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{indexName});
            gRequest.local(false);
            return this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to check if index %s exists due to", indexName), (Throwable)e);
            return false;
        }
    }

    @Override
    public void createIndex(IndexMapping indexMapping, String indexMappingContent) {
        if (Boolean.TRUE.equals(this.isClientAvailable)) {
            try {
                CreateIndexRequest request = new CreateIndexRequest(indexMapping.getIndexName(this.clusterAlias));
                request.source(indexMappingContent, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.debug("{} Created {}", (Object)indexMapping.getIndexName(this.clusterAlias), (Object)createIndexResponse.isAcknowledged());
                this.createAliases(indexMapping);
            }
            catch (Exception e) {
                LOG.error(String.format("Failed to create index for %s due to", indexMapping.getIndexName(this.clusterAlias)), (Throwable)e);
            }
        } else {
            LOG.error("Failed to create Elastic Search index as client is not property configured, Please check your OpenMetadata configuration");
        }
    }

    @Override
    public void createAliases(IndexMapping indexMapping) {
        try {
            HashSet<String> aliases = new HashSet<String>(indexMapping.getParentAliases(this.clusterAlias));
            aliases.add(indexMapping.getAlias(this.clusterAlias));
            IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(indexMapping.getIndexName(this.clusterAlias)).aliases(aliases.toArray(new String[0]));
            IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
            aliasesRequest.addAliasAction(aliasAction);
            this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to create alias for %s due to", indexMapping.getAlias(this.clusterAlias)), (Throwable)e);
        }
    }

    @Override
    public void updateIndex(IndexMapping indexMapping, String indexMappingContent) {
        try {
            PutMappingRequest request = new PutMappingRequest(new String[]{indexMapping.getIndexName(this.clusterAlias)});
            JsonNode readProperties = JsonUtils.readTree(indexMappingContent).get("mappings");
            request.source(JsonUtils.getMap(readProperties));
            AcknowledgedResponse putMappingResponse = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
            LOG.debug("{} Updated {}", (Object)indexMapping.getIndexMappingFile(), (Object)putMappingResponse.isAcknowledged());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to Update Elastic Search index %s", indexMapping.getIndexName(this.clusterAlias)));
        }
    }

    @Override
    public void deleteIndex(IndexMapping indexMapping) {
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(indexMapping.getIndexName(this.clusterAlias));
            AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
            LOG.debug("{} Deleted {}", (Object)indexMapping.getIndexName(this.clusterAlias), (Object)deleteIndexResponse.isAcknowledged());
        }
        catch (Exception e) {
            LOG.error("Failed to delete Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public Response search(SearchRequest request) throws IOException {
        QueryBuilder filter;
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.getSearchSourceBuilder(request.getIndex(), request.getQuery(), request.getFrom(), request.getSize());
        if (!CommonUtil.nullOrEmpty((String)request.getQueryFilter()) && !request.getQueryFilter().equals("{}")) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getQueryFilter());
                filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getPostFilter())) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getPostFilter());
                filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (request.getIndex().equalsIgnoreCase("all") || request.getIndex().equalsIgnoreCase("dataAsset")) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.isDeleted())));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")));
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (request.getIndex().equalsIgnoreCase("domain_search_index") || request.getIndex().equalsIgnoreCase("data_product_search_index") || request.getIndex().equalsIgnoreCase("query_search_index") || request.getIndex().equalsIgnoreCase("knowledge_page_search_index") || request.getIndex().equalsIgnoreCase("raw_cost_analysis_report_data_index") || request.getIndex().equalsIgnoreCase("aggregated_cost_analysis_report_data_index")) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()));
        } else {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.isDeleted())));
        }
        if (!CommonUtil.nullOrEmpty((String)request.getSortFieldParam()) && !request.isGetHierarchy()) {
            searchSourceBuilder.sort(request.getSortFieldParam(), SortOrder.fromString((String)request.getSortOrder()));
        }
        if (request.getIndex().equalsIgnoreCase("glossary_term_search_index")) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")));
            if (request.isGetHierarchy()) {
                BoolQueryBuilder baseQuery = QueryBuilders.boolQuery().should(searchSourceBuilder.query()).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"fullyQualifiedName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"name", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"displayName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"glossary.fullyQualifiedName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"glossary.displayName", (Object)request.getQuery())).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")).minimumShouldMatch(1);
                searchSourceBuilder.query((QueryBuilder)baseQuery);
                SearchResponse searchResponse = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT);
                BoolQueryBuilder parentTermQueryBuilder = QueryBuilders.boolQuery();
                Terms parentTerms = (Terms)searchResponse.getAggregations().get("fqnParts_agg");
                if (!parentTerms.getBuckets().isEmpty() && !request.getQuery().equals("*")) {
                    parentTerms.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).forEach(parentTerm -> parentTermQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"fullyQualifiedName", (Object)parentTerm)));
                    searchSourceBuilder.query((QueryBuilder)parentTermQueryBuilder.minimumShouldMatch(1).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")));
                }
                searchSourceBuilder.sort(SortBuilders.fieldSort((String)"fullyQualifiedName").order(SortOrder.ASC));
            }
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(request.isFetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        if (request.isTrackTotalHits()) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(EntityBuilderConstant.MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        try {
            SearchResponse searchResponse = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT);
            if (!request.isGetHierarchy()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)searchResponse.toString()).build();
            }
            List<?> response = this.buildSearchHierarchy(request, searchResponse);
            return Response.status((Response.Status)Response.Status.OK).entity(response).build();
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new SearchIndexNotFoundException(String.format("Failed to to find index %s", request.getIndex()));
            }
            throw new SearchException(String.format("Search failed due to %s", e.getMessage()));
        }
    }

    @Override
    public Response getDocByID(String indexName, String entityId) throws IOException {
        try {
            GetRequest request = new GetRequest(indexName, entityId);
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            if (response.isExists()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)response.toString()).build();
            }
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new SearchIndexNotFoundException(String.format("Failed to to find doc with id %s", entityId));
            }
            throw new SearchException(String.format("Search failed due to %s", e.getMessage()));
        }
        return CatalogGenericExceptionMapper.getResponse(Response.Status.NOT_FOUND, "Document not found.");
    }

    public List<?> buildSearchHierarchy(SearchRequest request, SearchResponse searchResponse) {
        List<Object> response = new ArrayList();
        if (request.getIndex().equalsIgnoreCase("glossary_term_search_index")) {
            response = this.buildGlossaryTermSearchHierarchy(searchResponse);
        }
        return response;
    }

    public List<EntityHierarchy__1> buildGlossaryTermSearchHierarchy(SearchResponse searchResponse) {
        LinkedHashMap<String, Object> termMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, EntityHierarchy__1> rootTerms = new LinkedHashMap<String, EntityHierarchy__1>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            EntityHierarchy__1 glossaryInfo;
            String jsonSource = hit.getSourceAsString();
            EntityHierarchy__1 term2 = JsonUtils.readValue(jsonSource, EntityHierarchy__1.class);
            EntityHierarchy__1 entityHierarchy__1 = glossaryInfo = JsonUtils.readTree(jsonSource).path("glossary").isMissingNode() ? null : JsonUtils.convertValue((Object)JsonUtils.readTree(jsonSource).path("glossary"), EntityHierarchy__1.class);
            if (glossaryInfo != null) {
                rootTerms.putIfAbsent(glossaryInfo.getFullyQualifiedName(), glossaryInfo);
            }
            term2.setChildren(new ArrayList());
            termMap.putIfAbsent(term2.getFullyQualifiedName(), term2);
        }
        termMap.putAll(rootTerms);
        termMap.values().forEach(term -> {
            String parentFQN = FullyQualifiedName.getParentFQN(term.getFullyQualifiedName());
            String termFQN = term.getFullyQualifiedName();
            if (parentFQN != null && termMap.containsKey(parentFQN)) {
                EntityHierarchy__1 parentTerm = (EntityHierarchy__1)termMap.get(parentFQN);
                List children = parentTerm.getChildren();
                children.removeIf(child -> child.getFullyQualifiedName().equals(term.getFullyQualifiedName()));
                children.add(term);
                parentTerm.setChildren(children);
            } else if (rootTerms.containsKey(termFQN)) {
                EntityHierarchy__1 rootTerm = (EntityHierarchy__1)rootTerms.get(termFQN);
                rootTerm.setChildren(term.getChildren());
            }
        });
        return new ArrayList<EntityHierarchy__1>(rootTerms.values());
    }

    @Override
    public SearchClient.SearchResultListMapper listWithOffset(String filter, int limit, int offset, String index, SearchSortFilter searchSortFilter, String q) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (!CommonUtil.nullOrEmpty((String)q)) {
            searchSourceBuilder = ElasticSearchClient.getSearchSourceBuilder(index, q, offset, limit);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (!filter.isEmpty()) {
            try {
                XContentParser queryParser = this.createXContentParser(filter);
                XContentParser sourceParser = this.createXContentParser(filter);
                QueryBuilder queryFromXContent = SearchSourceBuilder.fromXContent((XContentParser)queryParser).query();
                FetchSourceContext sourceFromXContent = SearchSourceBuilder.fromXContent((XContentParser)sourceParser).fetchSource();
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                boolQuery = CommonUtil.nullOrEmpty((String)q) ? boolQuery.filter(queryFromXContent) : boolQuery.must(searchSourceBuilder.query()).filter(queryFromXContent);
                searchSourceBuilder.query((QueryBuilder)boolQuery);
                searchSourceBuilder.fetchSource(sourceFromXContent);
            }
            catch (Exception e) {
                throw new IOException("Failed to parse query filter: %s", e);
            }
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        searchSourceBuilder.from(offset);
        searchSourceBuilder.size(limit);
        if (searchSortFilter.isSorted().booleanValue()) {
            FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)searchSortFilter.getSortField()).order(SortOrder.fromString((String)searchSortFilter.getSortType()));
            if (searchSortFilter.isNested().booleanValue()) {
                NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(searchSortFilter.getSortNestedPath());
                fieldSortBuilder.setNestedSort(nestedSortBuilder);
                fieldSortBuilder.sortMode(SortMode.valueOf((String)searchSortFilter.getSortNestedMode().toUpperCase()));
            }
            searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
        }
        try {
            SearchResponse response = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT);
            SearchHits searchHits = response.getHits();
            SearchHit[] hits = searchHits.getHits();
            Arrays.stream(hits).forEach(hit -> results.add(hit.getSourceAsMap()));
            return new SearchClient.SearchResultListMapper(results, searchHits.getTotalHits().value);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new SearchIndexNotFoundException(String.format("Failed to to find index %s", index));
            }
            throw new SearchException(String.format("Search failed due to %s", e.getDetailedMessage()));
        }
    }

    @Override
    public Map<String, Object> searchLineageInternal(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        HashSet<Map<String, Object>> edges = new HashSet<Map<String, Object>>();
        HashSet<Map<String, Object>> nodes = new HashSet<Map<String, Object>>();
        if (entityType.equalsIgnoreCase("pipeline") || entityType.equalsIgnoreCase("storedProcedure")) {
            return this.searchPipelineLineage(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, responseMap);
        }
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{"all"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"fullyQualifiedName", (String)fqn)));
        searchRequest.source(searchSourceBuilder.size(1000));
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            responseMap.put("entity", tempMap);
        }
        this.getLineage(fqn, downstreamDepth, edges, nodes, queryFilter, "lineage.fromEntity.fqn.keyword", deleted);
        this.getLineage(fqn, upstreamDepth, edges, nodes, queryFilter, "lineage.toEntity.fqn.keyword", deleted);
        responseMap.put("edges", edges);
        responseMap.put("nodes", nodes);
        return responseMap;
    }

    @Override
    public Response searchLineage(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        Map<String, Object> responseMap = this.searchLineageInternal(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, entityType);
        return Response.status((Response.Status)Response.Status.OK).entity(responseMap).build();
    }

    private void getLineage(String fqn, int depth, Set<Map<String, Object>> edges, Set<Map<String, Object>> nodes, String queryFilter, String direction, boolean deleted) throws IOException {
        if (depth <= 0) {
            return;
        }
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{"all"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)direction, (String)fqn)));
        if (CommonUtil.nullOrEmpty((Object)deleted)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)direction, (String)fqn)).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)deleted)));
        }
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchRequest.source(searchSourceBuilder.size(1000));
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            List lineage = (List)hit.getSourceAsMap().get("lineage");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            nodes.add(tempMap);
            for (Map lin : lineage) {
                HashMap fromEntity = (HashMap)lin.get("fromEntity");
                HashMap toEntity = (HashMap)lin.get("toEntity");
                if (direction.equalsIgnoreCase("lineage.fromEntity.fqn.keyword")) {
                    if (edges.contains(lin) || !((String)fromEntity.get("fqn")).equals(fqn)) continue;
                    edges.add(lin);
                    this.getLineage((String)toEntity.get("fqn"), depth - 1, edges, nodes, queryFilter, direction, deleted);
                    continue;
                }
                if (edges.contains(lin) || !((String)toEntity.get("fqn")).equals(fqn)) continue;
                edges.add(lin);
                this.getLineage((String)fromEntity.get("fqn"), depth - 1, edges, nodes, queryFilter, direction, deleted);
            }
        }
    }

    private Map<String, Object> searchPipelineLineage(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, Map<String, Object> responseMap) throws IOException {
        HashSet<Map<String, Object>> edges = new HashSet<Map<String, Object>>();
        HashSet<Map<String, Object>> nodes = new HashSet<Map<String, Object>>();
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{"all"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"lineage.pipeline.fullyQualifiedName.keyword", (String)fqn)));
        if (CommonUtil.nullOrEmpty((Object)deleted)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"lineage.pipeline.fullyQualifiedName.keyword", (String)fqn)).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)deleted)));
        }
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (QueryBuilder hit : searchResponse.getHits().getHits()) {
            List lineage = (List)hit.getSourceAsMap().get("lineage");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            nodes.add(tempMap);
            for (Map lin : lineage) {
                HashMap fromEntity = (HashMap)lin.get("fromEntity");
                HashMap toEntity = (HashMap)lin.get("toEntity");
                HashMap pipeline = (HashMap)lin.get("pipeline");
                if (pipeline == null || !((String)pipeline.get("fullyQualifiedName")).equalsIgnoreCase(fqn)) continue;
                edges.add(lin);
                this.getLineage((String)fromEntity.get("fqn"), upstreamDepth, edges, nodes, queryFilter, "lineage.toEntity.fqn.keyword", deleted);
                this.getLineage((String)toEntity.get("fqn"), downstreamDepth, edges, nodes, queryFilter, "lineage.fromEntity.fqn.keyword", deleted);
            }
        }
        if (edges.isEmpty()) {
            es.org.elasticsearch.action.search.SearchRequest searchRequestForEntity = new es.org.elasticsearch.action.search.SearchRequest(new String[]{"all"});
            SearchSourceBuilder searchSourceBuilderForEntity = new SearchSourceBuilder();
            searchSourceBuilderForEntity.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"fullyQualifiedName", (String)fqn)));
            searchRequestForEntity.source(searchSourceBuilderForEntity.size(1000));
            SearchResponse searchResponseForEntity = this.client.search(searchRequestForEntity, RequestOptions.DEFAULT);
            for (SearchHit hit : searchResponseForEntity.getHits().getHits()) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
                tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
                responseMap.put("entity", tempMap);
            }
        }
        responseMap.put("edges", edges);
        responseMap.put("nodes", nodes);
        return responseMap;
    }

    @Override
    public Response searchBySourceUrl(String sourceUrl) throws IOException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"sourceUrl", (String)sourceUrl)));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response searchByField(String fieldName, String fieldValue, String index) throws IOException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)fieldValue));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(filter);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()).includeExclude(new IncludeExclude(value.toLowerCase(), null)).order(BucketOrder.key((boolean)true))).query((QueryBuilder)boolQueryBuilder).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    public static List<AggregationBuilder> buildAggregation(JsonObject aggregations) {
        ArrayList<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>();
        for (String key : aggregations.keySet()) {
            JsonObject aggregation = aggregations.getJsonObject(key);
            Set keySet = aggregation.keySet();
            Iterator iterator = keySet.iterator();
            block11: while (iterator.hasNext()) {
                String aggregationType;
                switch (aggregationType = (String)iterator.next()) {
                    case "terms": {
                        JsonObject termAggregation = aggregation.getJsonObject(aggregationType);
                        TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(termAggregation.getString("field"));
                        aggregationBuilders.add((AggregationBuilder)termsAggregationBuilder);
                        break;
                    }
                    case "nested": {
                        JsonObject nestedAggregation = aggregation.getJsonObject("nested");
                        NestedAggregationBuilder nestedAggregationBuilder = AggregationBuilders.nested((String)nestedAggregation.getString("path"), (String)nestedAggregation.getString("path"));
                        JsonObject nestedAggregations = aggregation.getJsonObject("aggs");
                        List<AggregationBuilder> nestedAggregationBuilders = ElasticSearchClient.buildAggregation(nestedAggregations);
                        for (AggregationBuilder nestedAggregationBuilder1 : nestedAggregationBuilders) {
                            nestedAggregationBuilder.subAggregation(nestedAggregationBuilder1);
                        }
                        aggregationBuilders.add((AggregationBuilder)nestedAggregationBuilder);
                        break;
                    }
                    case "aggs": {
                        if (keySet.contains("nested")) break;
                        JsonObject subAggregation = aggregation.getJsonObject("aggs");
                        if (CommonUtil.nullOrEmpty(aggregationBuilders)) break;
                        AggregationBuilder aggregationBuilder = (AggregationBuilder)aggregationBuilders.get(aggregationBuilders.size() - 1);
                        List<AggregationBuilder> subAggregationBuilders = ElasticSearchClient.buildAggregation(subAggregation);
                        for (AggregationBuilder subAggregationBuilder : subAggregationBuilders) {
                            aggregationBuilder.subAggregation(subAggregationBuilder);
                        }
                        continue block11;
                    }
                }
            }
        }
        return aggregationBuilders;
    }

    @Override
    public JsonObject aggregate(String query, String index, JsonObject aggregationJson) throws IOException {
        JsonObject aggregations = aggregationJson.getJsonObject("aggregations");
        if (aggregations == null) {
            return null;
        }
        List<AggregationBuilder> aggregationBuilder = ElasticSearchClient.buildAggregation(aggregations);
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (query != null) {
            XContentParser queryParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
            QueryBuilder parsedQuery = SearchSourceBuilder.fromXContent((XContentParser)queryParser).query();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(parsedQuery);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        searchSourceBuilder.size(0).timeout(new TimeValue(30L, TimeUnit.SECONDS));
        for (AggregationBuilder aggregation : aggregationBuilder) {
            searchSourceBuilder.aggregation(aggregation);
        }
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        JsonObject jsonResponse = JsonUtils.readJson(response).asJsonObject();
        return jsonResponse.getJsonObject("aggregations");
    }

    private static ScriptScoreFunctionBuilder boostScore() {
        return ScoreFunctionBuilders.scriptFunction((String)"double score = _score;if (doc.containsKey('totalVotes') && doc['totalVotes'].value != null) { score = score + doc['totalVotes'].value; }if (doc.containsKey('usageSummary') && doc['usageSummary.weeklyStats.count'].value != null) { score = score + doc['usageSummary.weeklyStats.count'].value; }if (doc.containsKey('tier.tagFQN') && !doc['tier.tagFQN'].empty) { if (doc['tier.tagFQN'].value == 'Tier.Tier2') { score = score + 10; } else if (doc['tier.tagFQN'].value == 'Tier.Tier1') { score = score + 20; }}return score;");
    }

    private static HighlightBuilder buildHighlights(List<String> fields) {
        List<String> defaultFields = List.of("displayName", "name", "description", "displayName.ngram", "name.ngram");
        defaultFields = Stream.concat(defaultFields.stream(), fields.stream()).toList();
        HighlightBuilder hb = new HighlightBuilder();
        for (String field : defaultFields) {
            HighlightBuilder.Field highlightField = new HighlightBuilder.Field(field);
            highlightField.highlighterType("unified");
            hb.field(highlightField);
        }
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return hb;
    }

    @Override
    public Response suggest(SearchRequest request) throws IOException {
        String fieldName = request.getFieldName();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(request.getQuery(), Fuzziness.AUTO).size(request.getSize())).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(String.valueOf(request.isDeleted())).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(request.isFetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(request.getIndex())}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private static SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, PipelineIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("tasks.name", "tasks.description"));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tasks.displayName.keyword").field("tasks.displayName.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, MlModelIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("mlFeatures.name", "mlFeatures.description"));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, TopicIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name.keyword").field("messageSchema.schemaFields.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fieldNames").field("fieldNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, DashboardIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("charts.name", "charts.description"));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModels.displayName.keyword").field("dataModels.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"project.keyword").field("project.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"charts.displayName.keyword").field("charts.displayName.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildSearchAcrossIndexesBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, SearchIndex.getAllFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildGenericDataAssetSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, SearchIndex.getDefaultFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, TableIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("columns.name", "columns.description", "columns.children.name"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.displayName.keyword").field("database.displayName.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.displayName.keyword").field("databaseSchema.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tableType").field("tableType"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildUserOrTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, UserIndex.getFields());
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, GlossaryTermIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("synonyms"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"glossary.name.keyword").field("glossary.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"fqnParts_agg").field("fqnParts")).size(1000));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, TagIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"classification.name.keyword").field("classification.name.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildContainerSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, ContainerIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("dataModel.columns.name", "dataModel.columns.description", "dataModel.columns.children.name"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModel.columns.name.keyword").field("dataModel.columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildQuerySearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, QueryIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildTestCaseSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, TestCaseIndex.getFields());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(List.of("testSuite.name", "testSuite.description"));
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildStoredProcedureSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, StoredProcedureIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardDataModelsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, DashboardDataModelIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModelType").field("dataModelType")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"project.keyword").field("project.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDomainsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, DomainIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildCostAnalysisReportDataSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildSearchEntitySearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, SearchEntityIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fields.name.keyword").field("fields.name.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTestCaseResolutionStatusSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, TestCaseResolutionStatusIndex.getFields());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildServiceSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, SearchIndex.getDefaultFields());
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildDataProductSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = ElasticSearchClient.buildSearchQueryBuilder(query, DataProductIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (ScoreFunctionBuilder)ElasticSearchClient.boostScore());
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder hb = ElasticSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static QueryStringQueryBuilder buildSearchQueryBuilder(String query, Map<String, Float> fields) {
        return QueryBuilders.queryStringQuery((String)query).fields(fields).type(MultiMatchQueryBuilder.Type.MOST_FIELDS).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO).tieBreaker(0.9f);
    }

    private static SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(SearchIndex.getAllFields()).fuzziness(Fuzziness.AUTO);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.displayName.keyword").field("service.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("entityType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"owner.displayName.keyword").field("owner.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"domain.displayName.keyword").field("domain.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"index_count").field("_index")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()));
        return builder;
    }

    private static SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    @Override
    public ElasticSearchConfiguration.SearchType getSearchType() {
        return ElasticSearchConfiguration.SearchType.ELASTICSEARCH;
    }

    @Override
    public void createEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            updateRequest.docAsUpsert(true);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void createTimeSeriesEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            updateRequest.docAsUpsert(true);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void deleteByScript(String indexName, String scriptTxt, Map<String, Object> params) {
        if (this.isClientAvailable) {
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, params);
            ScriptQueryBuilder scriptQuery = new ScriptQueryBuilder(script);
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            deleteByQueryRequest.setQuery((QueryBuilder)scriptQuery);
            this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void deleteEntity(String indexName, String docId) {
        if (this.isClientAvailable) {
            DeleteRequest deleteRequest = new DeleteRequest(indexName, docId);
            this.deleteEntityFromElasticSearch(deleteRequest);
        }
    }

    @Override
    public void deleteEntityByFields(List<String> indexName, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(indexName.toArray(new String[indexName.size()]));
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            deleteByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreEntity(String indexName, String docId, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateRequest.script(script);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreChildren(List<String> indexName, String scriptTxt, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(indexName.toArray(new String[indexName.size()]));
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            updateByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    @Override
    public void updateEntity(String indexName, String docId, Map<String, Object> doc, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, JsonUtils.getMap(doc));
            updateRequest.scriptedUpsert(true);
            updateRequest.script(script);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void reindexAcrossIndices(String matchingKey, EntityReference sourceRef) {
        if (this.isClientAvailable) {
            this.getAsyncExecutor().submit(() -> {
                try {
                    int from = 0;
                    boolean hasMoreResults = true;
                    while (hasMoreResults) {
                        List<EntityReference> entities = ReindexingUtil.findReferenceInElasticSearchAcrossAllIndexes(matchingKey, sourceRef.getFullyQualifiedName(), from);
                        this.processEntitiesForReindex(entities);
                        from += entities.size();
                        hasMoreResults = !entities.isEmpty();
                    }
                }
                catch (Exception ex) {
                    LOG.error("Reindexing Across Entities Failed", (Throwable)ex);
                }
            });
        }
    }

    private void processEntitiesForReindex(List<EntityReference> references) throws IOException {
        if (!references.isEmpty()) {
            BulkRequest bulkRequests = new BulkRequest();
            for (EntityReference entityRef : references) {
                UpdateRequest request = ElasticSearchEntitiesProcessor.getUpdateRequest(entityRef.getType(), (EntityInterface)Entity.getEntity(entityRef, "*", Include.ALL));
                bulkRequests.add(request);
            }
            if (this.isClientAvailable) {
                this.client.bulk(bulkRequests, RequestOptions.DEFAULT);
            }
        }
    }

    private void updateChildren(UpdateByQueryRequest updateByQueryRequest, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder((String)fieldAndValue.getKey(), fieldAndValue.getValue()).operator(Operator.AND));
        Script script = new Script(ScriptType.INLINE, "painless", (String)updates.getKey(), JsonUtils.getMap(updates.getValue() == null ? new HashMap() : updates.getValue()));
        updateByQueryRequest.setScript(script);
        this.updateElasticSearchByQuery(updateByQueryRequest);
    }

    @Override
    public void updateChildren(String indexName, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            this.updateChildren(updateByQueryRequest, fieldAndValue, updates);
        }
    }

    @Override
    public void updateChildren(List<String> indexName, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(indexName.toArray(new String[indexName.size()]));
            this.updateChildren(updateByQueryRequest, fieldAndValue, updates);
        }
    }

    @Override
    public void updateLineage(String indexName, Pair<String, String> fieldAndValue, Map<String, Object> lineageData) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder((String)fieldAndValue.getKey(), fieldAndValue.getValue()).operator(Operator.AND));
            Map<String, Map<String, Object>> params = Collections.singletonMap("lineageData", lineageData);
            Script script = new Script(ScriptType.INLINE, "painless", "boolean docIdExists = false; for (int i = 0; i < ctx._source.lineage.size(); i++) { if (ctx._source.lineage[i].doc_id.equalsIgnoreCase(params.lineageData.doc_id)) { ctx._source.lineage[i] = params.lineageData; docIdExists = true; break;}}if (!docIdExists) {ctx._source.lineage.add(params.lineageData);}", params);
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    public void updateElasticSearch(UpdateRequest updateRequest) {
        if (updateRequest != null && this.isClientAvailable) {
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
    }

    private void updateElasticSearchByQuery(UpdateByQueryRequest updateByQueryRequest) {
        if (updateByQueryRequest != null && this.isClientAvailable) {
            updateByQueryRequest.setRefresh(true);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateByQueryRequest);
            this.client.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close elastic search", (Throwable)e);
        }
    }

    private void deleteEntityFromElasticSearch(DeleteRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    private void deleteEntityFromElasticSearchByQuery(DeleteByQueryRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefresh(true);
            this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest data, RequestOptions options) throws IOException {
        return this.client.bulk(data, RequestOptions.DEFAULT);
    }

    @Override
    public int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    @Override
    public TreeMap<Long, List<Object>> getSortedDate(String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        es.org.elasticsearch.action.search.SearchRequest searchRequestTotalAssets = ElasticSearchClient.buildSearchRequest(scheduleTime, currentTime, null, team, chartType, null, null, null, indexName);
        SearchResponse searchResponseTotalAssets = this.client.search(searchRequestTotalAssets, RequestOptions.DEFAULT);
        DataInsightChartResult processedDataTotalAssets = ElasticSearchClient.processDataInsightChartResult(searchResponseTotalAssets, chartType);
        TreeMap<Long, List<Object>> dateWithDataMap = new TreeMap<Long, List<Object>>();
        for (Object data : processedDataTotalAssets.getData()) {
            DataInsightInterface convertedData = (DataInsightInterface)data;
            Long timestamp = convertedData.getTimestamp();
            List<Object> totalEntitiesByTypeList = new ArrayList<DataInsightInterface>();
            if (dateWithDataMap.containsKey(timestamp)) {
                totalEntitiesByTypeList = dateWithDataMap.get(timestamp);
            }
            totalEntitiesByTypeList.add(convertedData);
            dateWithDataMap.put(timestamp, totalEntitiesByTypeList);
        }
        return dateWithDataMap;
    }

    @Override
    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) throws IOException, ParseException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = ElasticSearchClient.buildSearchRequest(startTs, endTs, tier, team, dataInsightChartName, size, from, queryFilter, dataReportIndex);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ElasticSearchClient.processDataInsightChartResult(searchResponse, dataInsightChartName)).build();
    }

    private static DataInsightChartResult processDataInsightChartResult(SearchResponse searchResponse, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws ParseException {
        DataInsightAggregatorInterface processor = ElasticSearchClient.createDataAggregator(searchResponse, dataInsightChartType);
        return processor.process(dataInsightChartType);
    }

    private static DataInsightAggregatorInterface createDataAggregator(SearchResponse aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws IllegalArgumentException {
        return switch (dataInsightChartType) {
            default -> throw new IncompatibleClassChangeError();
            case DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE -> new ElasticSearchEntitiesDescriptionAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION -> new ElasticSearchServicesDescriptionAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE -> new ElasticSearchEntitiesOwnerAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_SERVICES_WITH_OWNER -> new ElasticSearchServicesOwnerAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TYPE -> new ElasticSearchTotalEntitiesAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TIER -> new ElasticSearchTotalEntitiesByTierAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.DAILY_ACTIVE_USERS -> new ElasticSearchDailyActiveUsersAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.PAGE_VIEWS_BY_ENTITIES -> new ElasticSearchPageViewsByEntitiesAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.MOST_ACTIVE_USERS -> new ElasticSearchMostActiveUsersAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.MOST_VIEWED_ENTITIES -> new ElasticSearchMostViewedEntitiesAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.UNUSED_ASSETS -> new ElasticSearchUnusedAssetsAggregator(aggregations.getHits());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_SIZE -> new ElasticSearchAggregatedUnusedAssetsSizeAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_COUNT -> new ElasticSearchAggregatedUnusedAssetsCountAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT -> new ElasticSearchAggregatedUsedvsUnusedAssetsCountAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE -> new ElasticSearchAggregatedUsedvsUnusedAssetsSizeAggregator(aggregations.getAggregations());
        };
    }

    private static es.org.elasticsearch.action.search.SearchRequest buildSearchRequest(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) {
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.buildQueryFilter(startTs, endTs, tier, team, queryFilter, dataInsightChartName.value());
        if (!dataInsightChartName.toString().equalsIgnoreCase(DataInsightChartResult.DataInsightChartType.UNUSED_ASSETS.toString())) {
            AggregationBuilder aggregationBuilder = ElasticSearchClient.buildQueryAggregation(dataInsightChartName);
            searchSourceBuilder.aggregation(aggregationBuilder);
            searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        } else {
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.from(from.intValue());
            searchSourceBuilder.size(size.intValue());
            searchSourceBuilder.sort("data.lifeCycle.accessed.timestamp", SortOrder.DESC);
        }
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{dataReportIndex});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String queryFilter, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && DataInsightChartRepository.SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.team", teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && DataInsightChartRepository.SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.entityTier", tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        if (!DataInsightChartRepository.SUPPORTS_NULL_DATE_RANGE.contains(dataInsightChartName)) {
            if (startTs == null || endTs == null) {
                throw new IllegalArgumentException(String.format("Start and End date are required for chart type %s ", dataInsightChartName));
            }
            RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTs).lte((Object)endTs);
            searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        }
        searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        return searchSourceBuilder;
    }

    private static AggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"timestamp").field("timestamp")).calendarInterval(DateHistogramInterval.DAY);
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"entityCount").field("data.entityCount");
        switch (dataInsightChartName) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case AGGREGATED_UNUSED_ASSETS_SIZE: 
            case AGGREGATED_UNUSED_ASSETS_COUNT: {
                boolean isSize = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_SIZE);
                String[] types = new String[]{"frequentlyUsedDataAssets", "unusedDataAssets"};
                String fieldType = isSize ? "size" : "count";
                for (String type : types) {
                    SumAggregationBuilder threeDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sThreeDays", type)).field(String.format("data.%s.%s.threeDays", type, fieldType));
                    SumAggregationBuilder sevenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sSevenDays", type)).field(String.format("data.%s.%s.sevenDays", type, fieldType));
                    SumAggregationBuilder fourteenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sFourteenDays", type)).field(String.format("data.%s.%s.fourteenDays", type, fieldType));
                    SumAggregationBuilder thirtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sThirtyDays", type)).field(String.format("data.%s.%s.thirtyDays", type, fieldType));
                    SumAggregationBuilder sixtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sSixtyDays", type)).field(String.format("data.%s.%s.sixtyDays", type, fieldType));
                    ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)threeDaysAgg)).subAggregation((AggregationBuilder)sevenDaysAgg)).subAggregation((AggregationBuilder)fourteenDaysAgg)).subAggregation((AggregationBuilder)thirtyDaysAgg)).subAggregation((AggregationBuilder)sixtyDaysAgg);
                }
                return dateHistogramAggregationBuilder;
            }
            case AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT: 
            case AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE: {
                boolean isSizeReport = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE);
                String totalFieldString = isSizeReport ? "totalSize" : "totalCount";
                SumAggregationBuilder totalUnusedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUnused").field(String.format("data.unusedDataAssets.%s", totalFieldString));
                SumAggregationBuilder totalUsedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUsed").field(String.format("data.frequentlyUsedDataAssets.%s", totalFieldString));
                return ((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)totalUnusedAssets)).subAggregation((AggregationBuilder)totalUsedAssets);
            }
            case PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_SERVICES_WITH_OWNER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TIER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityTier").field("data.entityTier")).missing((Object)"NoTier")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityFqn").field("data.entityFqn")).size(10).order(BucketOrder.aggregation((String)"pageViews", (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owner").field("data.owner");
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType");
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityHref").field("data.entityHref");
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"userName").field("data.userName")).size(10).order(BucketOrder.aggregation((String)"sessions", (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"team").field("data.team");
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessions").field("data.totalSessions");
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.totalPageView");
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastSession").field("data.lastSession");
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessionDuration").field("data.totalSessionDuration");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }

    public RestHighLevelClient createElasticSearchClient(ElasticSearchConfiguration esConfig) {
        if (esConfig != null) {
            try {
                RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
                if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                    SSLContext sslContext = this.createElasticSearchSSLContext(esConfig);
                    restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchClient.lambda$createElasticSearchClient$8((CredentialsProvider)credentialsProvider, sslContext, esConfig, arg_0));
                }
                restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
                return new RestHighLevelClientBuilder(restClientBuilder.build()).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            }
            catch (Exception e) {
                LOG.error("Failed to create elastic search client ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static SearchSourceBuilder getSearchSourceBuilder(String index, String q, int from, int size) {
        return switch (index) {
            case "topic_search_index", "topic" -> ElasticSearchClient.buildTopicSearchBuilder(q, from, size);
            case "dashboard_search_index", "dashboard" -> ElasticSearchClient.buildDashboardSearchBuilder(q, from, size);
            case "pipeline_search_index", "pipeline" -> ElasticSearchClient.buildPipelineSearchBuilder(q, from, size);
            case "mlmodel_search_index", "mlmodel" -> ElasticSearchClient.buildMlModelSearchBuilder(q, from, size);
            case "table_search_index", "table" -> ElasticSearchClient.buildTableSearchBuilder(q, from, size);
            case "database_schema_search_index", "databaseSchema", "database_search_index", "database" -> ElasticSearchClient.buildGenericDataAssetSearchBuilder(q, from, size);
            case "user_search_index", "user", "team_search_index", "team" -> ElasticSearchClient.buildUserOrTeamSearchBuilder(q, from, size);
            case "glossary_term_search_index", "glossaryTerm" -> ElasticSearchClient.buildGlossaryTermSearchBuilder(q, from, size);
            case "tag_search_index", "tag" -> ElasticSearchClient.buildTagSearchBuilder(q, from, size);
            case "container_search_index", "container" -> ElasticSearchClient.buildContainerSearchBuilder(q, from, size);
            case "query_search_index", "query" -> ElasticSearchClient.buildQuerySearchBuilder(q, from, size);
            case "test_case_search_index", "testCase", "test_suite_search_index", "testSuite" -> ElasticSearchClient.buildTestCaseSearch(q, from, size);
            case "stored_procedure_search_index", "storedProcedure" -> ElasticSearchClient.buildStoredProcedureSearch(q, from, size);
            case "dashboard_data_model_search_index", "dashboardDataModel" -> ElasticSearchClient.buildDashboardDataModelsSearch(q, from, size);
            case "search_entity_search_index", "searchIndex" -> ElasticSearchClient.buildSearchEntitySearch(q, from, size);
            case "domain_search_index", "domain" -> ElasticSearchClient.buildDomainsSearch(q, from, size);
            case "raw_cost_analysis_report_data_index", "aggregated_cost_analysis_report_data_index" -> ElasticSearchClient.buildCostAnalysisReportDataSearch(q, from, size);
            case "data_product_search_index" -> ElasticSearchClient.buildDataProductSearch(q, from, size);
            case "test_case_resolution_status_search_index" -> ElasticSearchClient.buildTestCaseResolutionStatusSearch(q, from, size);
            case "mlmodel_service_search_index", "database_service_search_index", "messaging_service_index", "dashboard_service_index", "pipeline_service_index", "storage_service_index", "search_service_index", "metadata_service_index" -> ElasticSearchClient.buildServiceSearchBuilder(q, from, size);
            case "all", "dataAsset" -> ElasticSearchClient.buildSearchAcrossIndexesBuilder(q, from, size);
            default -> ElasticSearchClient.buildAggregateSearchBuilder(q, from, size);
        };
    }

    private XContentParser createXContentParser(String query) throws IOException {
        try {
            return XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        }
        catch (IOException e) {
            LOG.error("Failed to create XContentParser", (Throwable)e);
            throw e;
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticSearchClient$8(CredentialsProvider credentialsProvider, SSLContext sslContext, ElasticSearchConfiguration esConfig, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        if (esConfig.getKeepAliveTimeoutSecs() != null && esConfig.getKeepAliveTimeoutSecs() > 0) {
            httpAsyncClientBuilder.setKeepAliveStrategy((response, context) -> esConfig.getKeepAliveTimeoutSecs() * 1000);
        }
        return httpAsyncClientBuilder;
    }

    static {
        FIELDS_TO_REMOVE = Set.of("suggest", "service_suggest", "column_suggest", "schema_suggest", "database_suggest", "lifeCycle", "fqnParts", "chart_suggest", "field_suggest");
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, List.of());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

