/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.services.connections.database.IcebergConnection;
import org.openmetadata.schema.services.connections.database.iceberg.DynamoDbCatalogConnection;
import org.openmetadata.schema.services.connections.database.iceberg.GlueCatalogConnection;
import org.openmetadata.schema.services.connections.database.iceberg.HiveCatalogConnection;
import org.openmetadata.schema.services.connections.database.iceberg.IcebergCatalog;
import org.openmetadata.schema.services.connections.database.iceberg.RestCatalogConnection;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class IcebergConnectionClassConverter
extends ClassConverter {
    private static final List<Class<?>> CONNECTION_CLASSES = List.of(GlueCatalogConnection.class, DynamoDbCatalogConnection.class, HiveCatalogConnection.class, RestCatalogConnection.class);

    public IcebergConnectionClassConverter() {
        super(IcebergConnection.class);
    }

    @Override
    public Object convert(Object object) {
        IcebergConnection icebergConnection = (IcebergConnection)JsonUtils.convertValue(object, this.clazz);
        IcebergCatalog icebergCatalog = icebergConnection.getCatalog();
        this.tryToConvertOrFail(icebergCatalog.getConnection(), CONNECTION_CLASSES).ifPresent(arg_0 -> ((IcebergCatalog)icebergCatalog).setConnection(arg_0));
        icebergConnection.setCatalog(icebergCatalog);
        return icebergConnection;
    }
}

