/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openmetadata.service.exception.UnhandledServerException;

final class MultiUrlJwkProvider
implements JwkProvider {
    private final List<UrlJwkProvider> urlJwkProviders;
    private LoadingCache<String, Jwk> CACHE = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Jwk>(){

        public Jwk load(String key) throws Exception {
            SigningKeyNotFoundException lastException = new SigningKeyNotFoundException("JWT Token keyID doesn't match the configured keyID. This usually happens if you didn't configure proper publicKeyUrls under authentication configuration.", null);
            for (UrlJwkProvider jwkProvider : MultiUrlJwkProvider.this.urlJwkProviders) {
                try {
                    return jwkProvider.get(key);
                }
                catch (JwkException e) {
                    lastException.addSuppressed((Throwable)e);
                }
            }
            throw lastException;
        }
    });

    public MultiUrlJwkProvider(List<URL> publicKeyUris) {
        this.urlJwkProviders = publicKeyUris.stream().map(UrlJwkProvider::new).toList();
    }

    public Jwk get(String keyId) {
        try {
            return (Jwk)this.CACHE.get((Object)keyId);
        }
        catch (Exception e) {
            throw new UnhandledServerException(e.getMessage());
        }
    }
}

