/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.events.AlertFilteringInput;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.Argument;
import org.openmetadata.schema.entity.events.ArgumentsInput;
import org.openmetadata.schema.entity.events.EventFilterRule;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.EventSubscriptionOffset;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.EventsSubscriptionRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public final class AlertUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AlertUtil.class);

    private AlertUtil() {
    }

    public static <T> void validateExpression(String condition, Class<T> clz) {
        if (condition == null) {
            return;
        }
        Expression expression = CompiledRule.parseExpression(condition);
        AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(null);
        SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().withRootObject((Object)ruleEvaluator).build();
        try {
            expression.getValue((EvaluationContext)context, clz);
        }
        catch (Exception exception) {
            String message = exception.getMessage().replaceAll("on type .*$", "").replaceAll("on object .*$", "");
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToEvaluate(message));
        }
    }

    public static boolean evaluateAlertConditions(ChangeEvent changeEvent, List<EventFilterRule> alertFilterRules) {
        if (!alertFilterRules.isEmpty()) {
            String completeCondition = AlertUtil.buildCompleteCondition(alertFilterRules);
            AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(changeEvent);
            Expression expression = CompiledRule.parseExpression(completeCondition);
            SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().withRootObject((Object)ruleEvaluator).build();
            boolean result = Boolean.TRUE.equals(expression.getValue((EvaluationContext)context, Boolean.class));
            LOG.debug("Alert evaluated as Result : {}", (Object)result);
            return result;
        }
        return true;
    }

    public static String buildCompleteCondition(List<EventFilterRule> alertFilterRules) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < alertFilterRules.size(); ++i) {
            builder.append(AlertUtil.getWrappedCondition(alertFilterRules.get(i), i));
        }
        return builder.toString();
    }

    private static String getWrappedCondition(EventFilterRule rule, int index) {
        String prefixCondition = "";
        if (index != 0) {
            String rawCondition = AlertUtil.getRawCondition(rule.getPrefixCondition());
            prefixCondition = CommonUtil.nullOrEmpty((String)rawCondition) ? " && " : rawCondition;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (rule.getEffect() == ArgumentsInput.Effect.INCLUDE) {
            builder.append(rule.getCondition());
        } else {
            builder.append("!");
            builder.append(rule.getCondition());
        }
        builder.append(")");
        return String.format("%s%s", prefixCondition, builder);
    }

    private static String getRawCondition(ArgumentsInput.PrefixCondition prefixCondition) {
        if (prefixCondition.equals((Object)ArgumentsInput.PrefixCondition.AND)) {
            return " && ";
        }
        if (prefixCondition.equals((Object)ArgumentsInput.PrefixCondition.OR)) {
            return " || ";
        }
        return "";
    }

    public static boolean shouldTriggerAlert(ChangeEvent event, FilteringRules config) {
        if (config == null) {
            return true;
        }
        if (config.getResources().size() == 1 && ((String)config.getResources().get(0)).equals("all")) {
            return true;
        }
        if (event.getEntityType().equals("THREAD") && (((String)config.getResources().get(0)).equals("announcement") || ((String)config.getResources().get(0)).equals("task") || ((String)config.getResources().get(0)).equals("conversation"))) {
            Thread thread = AlertsRuleEvaluator.getThread(event);
            return ((String)config.getResources().get(0)).equalsIgnoreCase(thread.getType().value());
        }
        if (((String)config.getResources().get(0)).equals("testSuite")) {
            return event.getEntityType().equals("testSuite") || event.getEntityType().equals("testCase");
        }
        return config.getResources().contains(event.getEntityType());
    }

    public static SubscriptionStatus buildSubscriptionStatus(SubscriptionStatus.Status status, Long lastSuccessful, Long lastFailure, Integer statusCode, String reason, Long nextAttempt, Long timeStamp) {
        return new SubscriptionStatus().withStatus(status).withLastSuccessfulAt(lastSuccessful).withLastFailedAt(lastFailure).withLastFailedStatusCode(statusCode).withLastFailedReason(reason).withNextAttempt(nextAttempt).withTimestamp(timeStamp);
    }

    public static Map<ChangeEvent, Set<UUID>> getFilteredEvents(EventSubscription eventSubscription, Map<ChangeEvent, Set<UUID>> events) {
        return events.entrySet().stream().filter(entry -> AlertUtil.checkIfChangeEventIsAllowed((ChangeEvent)entry.getKey(), eventSubscription.getFilteringRules())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean checkIfChangeEventIsAllowed(ChangeEvent event, FilteringRules filteringRules) {
        boolean triggerChangeEvent = AlertUtil.shouldTriggerAlert(event, filteringRules);
        if (triggerChangeEvent && (triggerChangeEvent = AlertUtil.evaluateAlertConditions(event, filteringRules.getRules()))) {
            triggerChangeEvent = AlertUtil.evaluateAlertConditions(event, filteringRules.getActions());
        }
        return triggerChangeEvent;
    }

    public static EventSubscriptionOffset getStartingOffset(UUID eventSubscriptionId) {
        long eventSubscriptionOffset;
        String json = Entity.getCollectionDAO().eventSubscriptionDAO().getSubscriberExtension(eventSubscriptionId.toString(), "eventSubscription.Offset");
        if (json != null) {
            EventSubscriptionOffset offsetFromDb = JsonUtils.readValue(json, EventSubscriptionOffset.class);
            eventSubscriptionOffset = offsetFromDb.getOffset();
        } else {
            eventSubscriptionOffset = Entity.getCollectionDAO().changeEventDAO().getLatestOffset();
        }
        return new EventSubscriptionOffset().withOffset(Long.valueOf(eventSubscriptionOffset));
    }

    public static FilteringRules validateAndBuildFilteringConditions(List<String> resource, CreateEventSubscription.AlertType alertType, AlertFilteringInput input) {
        if (resource.size() != 1) {
            throw new BadRequestException("One resource can be specified. Zero or Multiple resources are not supported.");
        }
        if (alertType.equals((Object)CreateEventSubscription.AlertType.NOTIFICATION)) {
            Map<String, EventFilterRule> supportedFilters = AlertUtil.buildFilteringRulesMap(EventsSubscriptionRegistry.getEntityNotificationDescriptor(resource.get(0)).getSupportedFilters());
            if (input != null) {
                return new FilteringRules().withResources(resource).withRules(AlertUtil.buildRulesList(supportedFilters, input.getFilters())).withActions(Collections.emptyList());
            }
        } else if (alertType.equals((Object)CreateEventSubscription.AlertType.OBSERVABILITY)) {
            Map<String, EventFilterRule> supportedFilters = AlertUtil.buildFilteringRulesMap(EventsSubscriptionRegistry.getObservabilityDescriptor(resource.get(0)).getSupportedFilters());
            Map<String, EventFilterRule> supportedActions = AlertUtil.buildFilteringRulesMap(EventsSubscriptionRegistry.getObservabilityDescriptor(resource.get(0)).getSupportedActions());
            if (input != null) {
                return new FilteringRules().withResources(resource).withRules(AlertUtil.buildRulesList(supportedFilters, input.getFilters())).withActions(AlertUtil.buildRulesList(supportedActions, input.getActions()));
            }
        }
        return new FilteringRules().withResources(resource).withRules(Collections.emptyList()).withActions(Collections.emptyList());
    }

    private static Map<String, EventFilterRule> buildFilteringRulesMap(List<EventFilterRule> filteringRules) {
        return filteringRules.stream().collect(Collectors.toMap(EventFilterRule::getName, eventFilterRule -> JsonUtils.deepCopy(eventFilterRule, EventFilterRule.class)));
    }

    private static List<EventFilterRule> buildRulesList(Map<String, EventFilterRule> lookUp, List<ArgumentsInput> input) {
        ArrayList<EventFilterRule> rules = new ArrayList<EventFilterRule>();
        CommonUtil.listOrEmpty(input).forEach(argumentsInput -> rules.add(AlertUtil.getFilterRule(lookUp, argumentsInput, AlertUtil.buildInputArgumentsMap(argumentsInput))));
        return rules;
    }

    private static Map<String, List<String>> buildInputArgumentsMap(ArgumentsInput filter) {
        return filter.getArguments().stream().collect(Collectors.toMap(Argument::getName, Argument::getInput));
    }

    private static EventFilterRule getFilterRule(Map<String, EventFilterRule> supportedFilters, ArgumentsInput filterDetails, Map<String, List<String>> inputArgMap) {
        if (!supportedFilters.containsKey(filterDetails.getName())) {
            throw new BadRequestException("Give Resource doesn't support the filter " + filterDetails.getName());
        }
        EventFilterRule rule = supportedFilters.get(filterDetails.getName()).withEffect(filterDetails.getEffect());
        if (rule.getInputType().equals((Object)EventFilterRule.InputType.NONE)) {
            return rule;
        }
        String formulatedCondition = rule.getCondition();
        for (String argName : rule.getArguments()) {
            List<String> inputList = inputArgMap.get(argName);
            if (CommonUtil.nullOrEmpty(inputList)) {
                throw new BadRequestException("Input for argument " + argName + " is missing");
            }
            formulatedCondition = formulatedCondition.replace(String.format("${%s}", argName), String.format("{%s}", AlertUtil.convertInputListToString(inputList)));
        }
        return rule.withCondition(formulatedCondition);
    }

    public static String convertInputListToString(List<String> valueList) {
        if (CommonUtil.nullOrEmpty(valueList)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("'").append(valueList.get(0)).append("'");
        for (int i = 1; i < valueList.size(); ++i) {
            result.append(",'").append(valueList.get(i)).append("'");
        }
        return result.toString();
    }
}

