/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.monitoring;

import org.openmetadata.schema.monitoring.EventMonitorProvider;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;

public abstract class EventMonitor {
    private final String clusterPrefix;
    private final EventMonitorProvider eventMonitoringProvider;
    private final EventMonitorConfiguration eventMonitorConfiguration;

    protected EventMonitor(EventMonitorProvider eventMonitorProvider, EventMonitorConfiguration config, String clusterPrefix) {
        this.eventMonitoringProvider = eventMonitorProvider;
        this.clusterPrefix = clusterPrefix;
        this.eventMonitorConfiguration = config;
    }

    protected String buildMetricNamespace(String namespace) {
        return String.format("%s/%s", this.clusterPrefix, namespace);
    }

    protected abstract void pushMetric(ChangeEvent var1);

    protected abstract void close();

    public String getClusterPrefix() {
        return this.clusterPrefix;
    }

    public EventMonitorProvider getEventMonitoringProvider() {
        return this.eventMonitoringProvider;
    }

    public EventMonitorConfiguration getEventMonitorConfiguration() {
        return this.eventMonitorConfiguration;
    }
}

