/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.teams;

import at.favre.lib.crypto.bcrypt.BCrypt;
import freemarker.template.TemplateException;
import io.dropwizard.jersey.PATCH;
import io.dropwizard.jersey.errors.ErrorMessage;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jetbrains.annotations.Nullable;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.teams.CreateUser;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.auth.ChangePasswordRequest;
import org.openmetadata.schema.auth.CreatePersonalToken;
import org.openmetadata.schema.auth.EmailRequest;
import org.openmetadata.schema.auth.GenerateTokenRequest;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.auth.LoginRequest;
import org.openmetadata.schema.auth.LogoutRequest;
import org.openmetadata.schema.auth.PasswordResetRequest;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.RegistrationRequest;
import org.openmetadata.schema.auth.RevokePersonalTokenRequest;
import org.openmetadata.schema.auth.RevokeTokenRequest;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.auth.TokenRefreshRequest;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.CatalogPrincipal;
import org.openmetadata.service.security.auth.AuthenticatorHandler;
import org.openmetadata.service.security.auth.BotTokenCache;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.openmetadata.service.security.auth.UserTokenCache;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.security.saml.JwtTokenCacheManager;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.TokenUtil;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/users")
@Tag(name="Users", description="A `User` represents a user of OpenMetadata. A user can be part of 0 or more teams. A special type of user called Bot is used for automation. A user can be an owner of zero or more data assets. A user can also follow zero or more data assets.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="users", order=3, requiredForOps=true)
public class UserResource
extends EntityResource<User, UserRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(UserResource.class);
    public static final String COLLECTION_PATH = "v1/users/";
    public static final String USER_PROTECTED_FIELDS = "authenticationMechanism";
    private final JWTTokenGenerator jwtTokenGenerator = JWTTokenGenerator.getInstance();
    private final TokenRepository tokenRepository;
    private boolean isEmailServiceEnabled;
    private AuthenticationConfiguration authenticationConfiguration;
    private AuthorizerConfiguration authorizerConfiguration;
    private final AuthenticatorHandler authHandler;
    private boolean isSelfSignUpEnabled = false;
    static final String FIELDS = "profile,roles,teams,follows,owns,domain,personas,defaultPersona";

    @Override
    public User addHref(UriInfo uriInfo, User user) {
        super.addHref(uriInfo, user);
        Entity.withHref(uriInfo, user.getTeams());
        Entity.withHref(uriInfo, user.getRoles());
        Entity.withHref(uriInfo, user.getPersonas());
        Entity.withHref(uriInfo, user.getInheritedRoles());
        Entity.withHref(uriInfo, user.getOwns());
        Entity.withHref(uriInfo, user.getFollows());
        return user;
    }

    public UserResource(Authorizer authorizer, AuthenticatorHandler authenticatorHandler) {
        super("user", authorizer);
        this.allowedFields.remove(USER_PROTECTED_FIELDS);
        this.tokenRepository = Entity.getTokenRepository();
        UserTokenCache.initialize();
        this.authHandler = authenticatorHandler;
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("profile,roles,teams,follows,owns", MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.EDIT_TEAMS});
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        super.initialize(config);
        this.authenticationConfiguration = config.getAuthenticationConfiguration();
        this.authorizerConfiguration = config.getAuthorizerConfiguration();
        SmtpSettings smtpSettings = config.getSmtpSettings();
        this.isEmailServiceEnabled = smtpSettings != null && smtpSettings.getEnableSmtpServer() != false;
        ((UserRepository)this.repository).initializeUsers(config);
        this.isSelfSignUpEnabled = this.authenticationConfiguration.getEnableSelfSignup();
    }

    @GET
    @Valid
    @Operation(operationId="listUsers", summary="List users", description="Get a list of users. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserList.class))})})
    public ResultList<User> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns,domain,personas,defaultPersona")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter users by team", schema=@Schema(type="string", example="Legal")) @QueryParam(value="team") String teamParam, @Parameter(description="Limit the number users returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of users before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of users after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Returns list of admin users if set to true", schema=@Schema(type="boolean")) @QueryParam(value="isAdmin") Boolean isAdmin, @Parameter(description="Returns list of bot users if set to true", schema=@Schema(type="boolean")) @QueryParam(value="isBot") Boolean isBot, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)new ListFilter(include).addQueryParam("team", teamParam);
        if (isAdmin != null) {
            filter.addQueryParam("isAdmin", String.valueOf(isAdmin));
        }
        if (isBot != null) {
            filter.addQueryParam("isBot", String.valueOf(isBot));
        }
        ResultList<User> users = this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        users.getData().forEach(user -> this.decryptOrNullify(securityContext, (User)user));
        return users;
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllUserVersion", summary="List user versions", description="Get a list of all the versions of a user identified by `id`", responses={@ApiResponse(responseCode="200", description="List of user versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/generateRandomPwd")
    @Operation(operationId="generateRandomPwd", summary="Generate a random password", description="Generate a random password", responses={@ApiResponse(responseCode="200", description="Random pwd")})
    public Response generateRandomPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)PasswordUtil.generateRandomPassword()).build();
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(operationId="getUserByID", summary="Get a user", description="Get a user by `id`", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {id} is not found")})
    public User get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns,domain,personas,defaultPersona")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        User user = (User)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        this.decryptOrNullify(securityContext, user);
        return user;
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getUserByFQN", summary="Get a user by name", description="Get a user by `name`.", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {name} is not found")})
    public User getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the user", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns,domain,personas,defaultPersona")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        User user = (User)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        this.decryptOrNullify(securityContext, user);
        return user;
    }

    @GET
    @Valid
    @Path(value="/loggedInUser")
    @Operation(operationId="getCurrentLoggedInUser", summary="Get current logged in user", description="Get the user who is authenticated and is currently logged in.", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User not found")})
    public User getCurrentLoggedInUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Context ContainerRequestContext containerRequestContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns,domain,personas,defaultPersona")) @QueryParam(value="fields") String fieldsParam) {
        CatalogSecurityContext catalogSecurityContext = (CatalogSecurityContext)containerRequestContext.getSecurityContext();
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        String currentEmail = ((CatalogPrincipal)catalogSecurityContext.getUserPrincipal()).getEmail();
        User user = ((UserRepository)this.repository).getByEmail(uriInfo, currentEmail, fields);
        ((UserRepository)this.repository).validateLoggedInUserNameAndEmailMatches(securityContext.getUserPrincipal().getName(), currentEmail, user);
        if (Boolean.TRUE.equals(this.authorizerConfiguration.getUseRolesFromProvider()) && Boolean.FALSE.equals(user.getIsBot() != null && user.getIsBot() != false)) {
            UserUtil.reSyncUserRolesFromToken(uriInfo, user, UserUtil.getRolesFromAuthorizationToken(catalogSecurityContext));
        }
        return this.addHref(uriInfo, user);
    }

    @GET
    @Valid
    @Path(value="/loggedInUser/groupTeams")
    @Operation(operationId="getCurrentLoggedInUserGroupTeams", summary="Get group type of teams for current logged in user", description="Get the group type of teams of user who is authenticated and is currently logged in.", responses={@ApiResponse(responseCode="200", description="The teams of type 'Group' that a user belongs to", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EntityReference.class)))}), @ApiResponse(responseCode="404", description="User not found")})
    public List<EntityReference> getCurrentLoggedInUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Context ContainerRequestContext containerRequestContext) {
        CatalogSecurityContext catalogSecurityContext = (CatalogSecurityContext)containerRequestContext.getSecurityContext();
        String currentEmail = ((CatalogPrincipal)catalogSecurityContext.getUserPrincipal()).getEmail();
        return ((UserRepository)this.repository).getGroupTeams(uriInfo, catalogSecurityContext, currentEmail);
    }

    @POST
    @Path(value="/logout")
    @Operation(operationId="logoutUser", summary="Logout a User(Only called for saml and basic Auth)", description="Logout a User(Only called for saml and basic Auth)", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response logoutUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid LogoutRequest request) {
        Date logoutTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        JwtTokenCacheManager.getInstance().markLogoutEventForToken(new LogoutRequest().withUsername(securityContext.getUserPrincipal().getName()).withToken(request.getToken()).withLogoutTime(logoutTime));
        if (this.isBasicAuth() && request.getRefreshToken() != null) {
            this.tokenRepository.deleteToken(request.getRefreshToken());
        }
        return Response.status((int)200).entity((Object)"Logout Successful").build();
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificUserVersion", summary="Get a version of the user", description="Get a version of the user by given `id`", responses={@ApiResponse(responseCode="200", description="user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {id} and version {version} is not found")})
    public User getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="User version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (User)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createUser", summary="Create a user", description="Create a new user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Context ContainerRequestContext containerRequestContext, @Valid CreateUser create) {
        Response createdUserRes;
        User user = UserResource.getUser(securityContext.getUserPrincipal().getName(), create);
        if (Boolean.TRUE.equals(create.getIsBot())) {
            this.addAuthMechanismToBot(user, create, uriInfo);
        }
        try {
            this.validateEmailAlreadyExists(create.getEmail());
            this.addUserAuthForBasic(user, create);
        }
        catch (RuntimeException ex) {
            return Response.status((Response.Status)Response.Status.CONFLICT).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.CONFLICT.getStatusCode(), "Entity already exists")).build();
        }
        this.updateUserRolesIfRequired(user, containerRequestContext);
        try {
            createdUserRes = this.create(uriInfo, securityContext, user);
        }
        catch (EntityNotFoundException ex) {
            if (this.isSelfSignUpEnabled) {
                if (securityContext.getUserPrincipal().getName().equals(create.getName())) {
                    User created = this.addHref(uriInfo, ((UserRepository)this.repository).create(uriInfo, user));
                    createdUserRes = Response.created((URI)created.getHref()).entity((Object)created).build();
                }
                throw new CustomExceptionMessage(Response.Status.FORBIDDEN, "OTHER_USER_SIGN_UP_ERROR", "Self Signup can only create user for self. Only Admin can create other users.");
            }
            throw new CustomExceptionMessage(Response.Status.FORBIDDEN, "SELF_SIGNUP_NOT_ENABLED", "Self Signup is not enabled. Please contact your Administrator for assistance with account creation");
        }
        if (createdUserRes != null) {
            this.sendInviteMailToUserForBasicAuth(uriInfo, user, create);
            this.decryptOrNullify(securityContext, (User)createdUserRes.getEntity());
            return createdUserRes;
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User Cannot be created Successfully.").build();
    }

    private void addUserAuthForBasic(User user, CreateUser create) {
        if (this.isBasicAuth()) {
            user.setName(user.getEmail().split("@")[0]);
            if (Boolean.FALSE.equals(create.getIsBot()) && create.getCreatePasswordType() == CreateUser.CreatePasswordType.ADMIN_CREATE) {
                this.addAuthMechanismToUser(user, create);
            }
        }
    }

    private void updateUserRolesIfRequired(User user, ContainerRequestContext containerRequestContext) {
        CatalogSecurityContext catalogSecurityContext = (CatalogSecurityContext)containerRequestContext.getSecurityContext();
        if (Boolean.TRUE.equals(this.authorizerConfiguration.getUseRolesFromProvider()) && Boolean.FALSE.equals(user.getIsBot() != null && user.getIsBot() != false)) {
            user.setRoles(UserUtil.validateAndGetRolesRef(UserUtil.getRolesFromAuthorizationToken(catalogSecurityContext)));
        }
    }

    private void sendInviteMailToUserForBasicAuth(UriInfo uriInfo, User user, CreateUser create) {
        if (this.isBasicAuth() && this.isEmailServiceEnabled) {
            try {
                this.authHandler.sendInviteMailToUser(uriInfo, user, String.format("Welcome to %s", EmailUtil.getEmailingEntity()), create.getCreatePasswordType(), create.getPassword());
            }
            catch (Exception ex) {
                LOG.error("Error in sending invite to User" + ex.getMessage());
            }
        }
    }

    private boolean isBasicAuth() {
        return this.authenticationConfiguration.getProvider().equals((Object)AuthProvider.BASIC);
    }

    @PUT
    @Operation(summary="Update user", description="Create or Update a user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateUser.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdateUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateUser create) {
        User user = UserResource.getUser(securityContext.getUserPrincipal().getName(), create);
        ((UserRepository)this.repository).prepareInternal(user, true);
        ResourceContext resourceContext = this.getResourceContextByName(user.getFullyQualifiedName());
        if (Boolean.TRUE.equals(create.getIsAdmin()) || Boolean.TRUE.equals(create.getIsBot())) {
            this.authorizer.authorizeAdmin(securityContext);
        } else if (!securityContext.getUserPrincipal().getName().equals(user.getName())) {
            OperationContext createOperationContext = new OperationContext(this.entityType, EntityUtil.createOrUpdateOperation(resourceContext));
            this.authorizer.authorize(securityContext, createOperationContext, resourceContext);
        }
        if (Boolean.TRUE.equals(create.getIsBot())) {
            return this.createOrUpdateBot(user, create, uriInfo, securityContext);
        }
        RestUtil.PutResponse<User> response = ((UserRepository)this.repository).createOrUpdate(uriInfo, user);
        this.addHref(uriInfo, response.getEntity());
        return response.toResponse();
    }

    @PUT
    @Path(value="/generateToken/{id}")
    @Operation(operationId="generateJWTTokenForBotUser", summary="Generate JWT Token for a Bot User", description="Generate JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTTokenExpiry.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response generateToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid GenerateTokenRequest generateTokenRequest) {
        this.authorizer.authorizeAdmin(securityContext);
        User user = (User)((UserRepository)this.repository).get(uriInfo, id, ((UserRepository)this.repository).getFieldsWithUserAuth("*"));
        JWTAuthMechanism jwtAuthMechanism = this.jwtTokenGenerator.generateJWTToken(user, generateTokenRequest.getJWTTokenExpiry());
        AuthenticationMechanism authenticationMechanism = new AuthenticationMechanism().withConfig((Object)jwtAuthMechanism).withAuthType(AuthenticationMechanism.AuthType.JWT);
        user.setAuthenticationMechanism(authenticationMechanism);
        User updatedUser = ((UserRepository)this.repository).createOrUpdate(uriInfo, user).getEntity();
        jwtAuthMechanism = JsonUtils.convertValue(updatedUser.getAuthenticationMechanism().getConfig(), JWTAuthMechanism.class);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jwtAuthMechanism).build();
    }

    @PUT
    @Path(value="/revokeToken")
    @Operation(operationId="revokeJWTTokenForBotUser", summary="Revoke JWT Token for a Bot User", description="Revoke JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTAuthMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response revokeToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RevokeTokenRequest revokeTokenRequest) {
        this.authorizer.authorizeAdmin(securityContext);
        User user = (User)((UserRepository)this.repository).get(uriInfo, revokeTokenRequest.getId(), ((UserRepository)this.repository).getFieldsWithUserAuth("*"));
        if (Boolean.FALSE.equals(user.getIsBot())) {
            throw new IllegalStateException("Revoke Token can only be applied to Bot Users.");
        }
        JWTAuthMechanism jwtAuthMechanism = new JWTAuthMechanism().withJWTToken("");
        AuthenticationMechanism authenticationMechanism = new AuthenticationMechanism().withConfig((Object)jwtAuthMechanism).withAuthType(AuthenticationMechanism.AuthType.JWT);
        user.setAuthenticationMechanism(authenticationMechanism);
        RestUtil.PutResponse<User> response = ((UserRepository)this.repository).createOrUpdate(uriInfo, user);
        this.addHref(uriInfo, response.getEntity());
        BotTokenCache.invalidateToken(user.getName());
        return response.toResponse();
    }

    @GET
    @Path(value="/token/{id}")
    @Operation(operationId="getJWTTokenForBotUser", summary="Get JWT Token for a Bot User", description="Get JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTAuthMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public JWTAuthMechanism getToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        User user = (User)((UserRepository)this.repository).get(uriInfo, id, new EntityUtil.Fields(Set.of(USER_PROTECTED_FIELDS)));
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("JWT token is only supported for bot users");
        }
        this.decryptOrNullify(securityContext, user);
        this.authorizer.authorizeAdmin(securityContext);
        AuthenticationMechanism authenticationMechanism = user.getAuthenticationMechanism();
        if (authenticationMechanism != null && authenticationMechanism.getConfig() != null && authenticationMechanism.getAuthType() == AuthenticationMechanism.AuthType.JWT) {
            return JsonUtils.convertValue(authenticationMechanism.getConfig(), JWTAuthMechanism.class);
        }
        return new JWTAuthMechanism();
    }

    @GET
    @Path(value="/auth-mechanism/{id}")
    @Operation(operationId="getAuthenticationMechanismBotUser", summary="Get Authentication Mechanism for a Bot User", description="Get Authentication Mechanism for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public AuthenticationMechanism getAuthenticationMechanism(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        User user = (User)((UserRepository)this.repository).get(uriInfo, id, new EntityUtil.Fields(Set.of(USER_PROTECTED_FIELDS)));
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("JWT token is only supported for bot users");
        }
        this.decryptOrNullify(securityContext, user);
        this.authorizer.authorizeAdmin(securityContext);
        return user.getAuthenticationMechanism();
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchUser", summary="Update a user", description="Update an existing user using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        for (JsonValue patchOp : patch.toJsonArray()) {
            JsonObject patchOpObject = patchOp.asJsonObject();
            if (!patchOpObject.containsKey((Object)"path") || !patchOpObject.containsKey((Object)"value")) continue;
            String path = patchOpObject.getString("path");
            if (path.equals("/isAdmin") || path.equals("/isBot") || path.contains("/roles")) {
                this.authorizer.authorizeAdmin(securityContext);
                continue;
            }
            if (!patchOpObject.containsKey((Object)"op") || !patchOpObject.getString("op").equals("add") || !path.startsWith("/teams/")) continue;
            JsonObject value = null;
            try {
                value = patchOpObject.getJsonObject("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) continue;
            String teamId = value.getString("id");
            ((UserRepository)this.repository).validateTeamAddition(id, UUID.fromString(teamId));
            if (((UserRepository)this.repository).isTeamJoinable(teamId)) continue;
            this.authorizer.authorizeAdmin(securityContext);
        }
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteUser", summary="Delete a user", description="Users can't be deleted but are soft-deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="User for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the user", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        Response response = this.delete(uriInfo, securityContext, id, false, hardDelete);
        this.decryptOrNullify(securityContext, (User)response.getEntity());
        return response;
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteUserByName", summary="Delete a user", description="Users can't be deleted but are soft-deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="User for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the user", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted User.", description="Restore a soft deleted User.", responses={@ApiResponse(responseCode="200", description="Successfully restored the User ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @POST
    @Path(value="/signup")
    @Operation(operationId="registerUser", summary="Register User", description="Register a new User", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response registerNewUser(@Context UriInfo uriInfo, @Valid RegistrationRequest create) throws IOException {
        User registeredUser = this.authHandler.registerUser(create);
        this.authHandler.sendEmailVerification(uriInfo, registeredUser);
        return Response.status((int)Response.Status.CREATED.getStatusCode(), (String)"User Registration Successful.").entity((Object)registeredUser).build();
    }

    @PUT
    @Path(value="/registrationConfirmation")
    @Operation(operationId="confirmUserEmail", summary="Confirm User Email", description="Confirm User Email", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response confirmUserEmail(@Context UriInfo uriInfo, @Parameter(description="Token sent for Email Confirmation", schema=@Schema(type="string")) @QueryParam(value="token") String token) {
        this.authHandler.confirmEmailRegistration(uriInfo, token);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Verified Successfully").build();
    }

    @PUT
    @Path(value="/resendRegistrationToken")
    @Operation(operationId="resendRegistrationToken", summary="Resend Registration Token", description="Resend Registration Token", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response resendRegistrationToken(@Context UriInfo uriInfo, @Parameter(description="Token sent for Email Confirmation Earlier", schema=@Schema(type="string")) @QueryParam(value="user") String user) throws IOException {
        User registeredUser = ((UserRepository)this.repository).getByName(uriInfo, user, this.getFields("isEmailVerified"));
        if (Boolean.TRUE.equals(registeredUser.getIsEmailVerified())) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Already Verified.").build();
        }
        this.authHandler.resendRegistrationToken(uriInfo, registeredUser);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Verification Mail Sent. Please check your Mailbox.").build();
    }

    @POST
    @Path(value="/generatePasswordResetLink")
    @Operation(operationId="generatePasswordResetLink", summary="Generate Password Reset Link", description="Generate Password Reset Link", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response generateResetPasswordLink(@Context UriInfo uriInfo, @Valid EmailRequest request) {
        User registeredUser;
        String userName = request.getEmail().split("@")[0];
        try {
            registeredUser = ((UserRepository)this.repository).getByName(uriInfo, userName, new EntityUtil.Fields(Set.of(USER_PROTECTED_FIELDS), USER_PROTECTED_FIELDS));
        }
        catch (EntityNotFoundException ex) {
            LOG.error("[GeneratePasswordReset] Got Error while fetching user : {},  error message {}", (Object)userName, (Object)ex.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Please check your mail to for Reset Password Link.").build();
        }
        try {
            this.authHandler.sendPasswordResetLink(uriInfo, registeredUser, EmailUtil.getPasswordResetSubject(), "reset-link.ftl");
        }
        catch (Exception ex) {
            LOG.error("Error in sending mail for reset password" + ex.getMessage());
            return Response.status((int)424).entity((Object)new ErrorMessage(424, "There is some issue in sending the Mail. Please contact your administrator.")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Please check your mail to for Reset Password Link.").build();
    }

    @POST
    @Path(value="/password/reset")
    @Operation(operationId="resetUserPassword", summary="Reset Password For User", description="Reset User Password", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response resetUserPassword(@Context UriInfo uriInfo, @Valid PasswordResetRequest request) throws IOException {
        this.authHandler.resetUserPasswordWithToken(uriInfo, request);
        return Response.status((int)200).entity((Object)"Password Changed Successfully").build();
    }

    @PUT
    @Path(value="/changePassword")
    @Operation(operationId="changeUserPassword", summary="Change Password For User", description="Create a new user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response changeUserPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid ChangePasswordRequest request) throws IOException {
        if (request.getRequestType() == ChangePasswordRequest.RequestType.SELF) {
            this.authHandler.changeUserPwdWithOldPwd(uriInfo, securityContext.getUserPrincipal().getName(), request);
        } else {
            this.authorizer.authorizeAdmin(securityContext);
            this.authHandler.changeUserPwdWithOldPwd(uriInfo, request.getUsername(), request);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Password Updated Successfully").build();
    }

    @POST
    @Path(value="/checkEmailInUse")
    @Operation(operationId="checkEmailInUse", summary="Check if a email is already in use", description="Check if a email is already in use", responses={@ApiResponse(responseCode="200", description="Return true or false", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response checkEmailInUse(@Valid EmailRequest request) {
        boolean emailExists = ((UserRepository)this.repository).checkEmailAlreadyExists(request.getEmail());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)emailExists).build();
    }

    @POST
    @Path(value="/checkEmailVerified")
    @Operation(operationId="checkEmailIsVerified", summary="Check if a mail is verified", description="Check if a mail is already in use", responses={@ApiResponse(responseCode="200", description="Return true or false", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response checkEmailVerified(@Context UriInfo uriInfo, @Valid EmailRequest request) {
        User user = ((UserRepository)this.repository).getByName(uriInfo, request.getEmail().split("@")[0], this.getFields("isEmailVerified"));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)user.getIsEmailVerified()).build();
    }

    @POST
    @Path(value="/login")
    @Operation(operationId="loginUserWithPwd", summary="Login User with email (plain-text) and Password (encoded in base 64)", description="Login User with email(plain-text) and Password (encoded in base 64)", responses={@ApiResponse(responseCode="200", description="Returns the Jwt Token Response ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JwtResponse.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response loginUserWithPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid LoginRequest loginRequest) throws IOException, TemplateException {
        byte[] decodedBytes;
        try {
            decodedBytes = Base64.getDecoder().decode(loginRequest.getPassword());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Password needs to be encoded in Base-64.");
        }
        loginRequest.withPassword(new String(decodedBytes));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.authHandler.loginUser(loginRequest)).build();
    }

    @POST
    @Path(value="/refresh")
    @Operation(operationId="refreshToken", summary="Provide access token to User with refresh token", description="Provide access token to User with refresh token", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JwtResponse.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response refreshToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid TokenRefreshRequest refreshRequest) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.authHandler.getNewAccessToken(refreshRequest)).build();
    }

    @GET
    @Path(value="/security/token")
    @Operation(operationId="getPersonalAccessToken", summary="Get personal access token to User", description="Get a personal access token", responses={@ApiResponse(responseCode="200", description="List Of Personal Access Tokens ", content={@Content(mediaType="application/json", schema=@Schema(implementation=PersonalAccessTokenList.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response getPersonalAccessToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="User Name of the User for which to get. (Default = `false`)") @QueryParam(value="username") String userName) {
        if (userName != null) {
            this.authorizer.authorizeAdmin(securityContext);
        } else {
            userName = securityContext.getUserPrincipal().getName();
        }
        User user = (User)((UserRepository)this.repository).getByName(null, userName, this.getFields("id"), Include.NON_DELETED, true);
        List<TokenInterface> tokens = this.tokenRepository.findByUserIdAndType(user.getId(), TokenType.PERSONAL_ACCESS_TOKEN.value());
        return Response.status((Response.Status)Response.Status.OK).entity(new ResultList<TokenInterface>(tokens)).build();
    }

    @PUT
    @Path(value="/security/token/revoke")
    @Operation(operationId="revokePersonalAccessToken", summary="Revoke personal access token to User", description="Revoke personal access token", responses={@ApiResponse(responseCode="200", description="The Personal access token ", content={@Content(mediaType="application/json", schema=@Schema(implementation=PersonalAccessTokenList.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response revokePersonalAccessToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Username in case admin is revoking. (Default = `false`)") @QueryParam(value="username") String userName, @Parameter(description="Remove All tokens of the user. (Default = `false`)") @QueryParam(value="removeAll") @DefaultValue(value="false") boolean removeAll, @Valid RevokePersonalTokenRequest request) {
        if (!CommonUtil.nullOrEmpty((String)userName)) {
            this.authorizer.authorizeAdmin(securityContext);
        } else {
            userName = securityContext.getUserPrincipal().getName();
        }
        User user = (User)((UserRepository)this.repository).getByName(null, userName, this.getFields("id"), Include.NON_DELETED, false);
        if (removeAll) {
            this.tokenRepository.deleteTokenByUserAndType(user.getId(), TokenType.PERSONAL_ACCESS_TOKEN.value());
        } else {
            List<String> ids = request.getTokenIds().stream().map(UUID::toString).collect(Collectors.toList());
            this.tokenRepository.deleteAllToken(ids);
        }
        UserTokenCache.invalidateToken(user.getName());
        List<TokenInterface> tokens = this.tokenRepository.findByUserIdAndType(user.getId(), TokenType.PERSONAL_ACCESS_TOKEN.value());
        return Response.status((Response.Status)Response.Status.OK).entity(new ResultList<TokenInterface>(tokens)).build();
    }

    @PUT
    @Path(value="/security/token")
    @Operation(operationId="createPersonalAccessToken", summary="Provide access token to User", description="Provide access token to User", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=PersonalAccessToken.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createAccessToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePersonalToken tokenRequest) {
        String userName = securityContext.getUserPrincipal().getName();
        User user = (User)((UserRepository)this.repository).getByName(null, userName, this.getFields("roles,email,isBot"), Include.NON_DELETED, false);
        if (user.getIsBot() == null || Boolean.FALSE.equals(user.getIsBot())) {
            JWTAuthMechanism authMechanism = JWTTokenGenerator.getInstance().getJwtAuthMechanism(userName, UserUtil.getRoleListFromUser(user), user.getIsAdmin(), user.getEmail(), false, ServiceTokenType.PERSONAL_ACCESS, JWTTokenGenerator.getExpiryDate(tokenRequest.getJWTTokenExpiry()), null);
            PersonalAccessToken personalAccessToken = TokenUtil.getPersonalAccessToken(tokenRequest, user, authMechanism);
            this.tokenRepository.insertToken((TokenInterface)personalAccessToken);
            UserTokenCache.invalidateToken(user.getName());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)personalAccessToken).build();
        }
        throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "NO_PERSONAL_TOKEN_FOR_BOTS", "Bots cannot have a Personal Access Token.");
    }

    @GET
    @Path(value="/documentation/csv")
    @Valid
    @Operation(operationId="getCsvDocumentation", summary="Get CSV documentation for user import/export")
    public String getUserCsvDocumentation(@Context SecurityContext securityContext) {
        return JsonUtils.pojoToJson(UserRepository.UserCsv.DOCUMENTATION);
    }

    @GET
    @Path(value="/export")
    @Produces(value={"text/plain"})
    @Valid
    @Operation(operationId="exportUsers", summary="Export users in a team in CSV format", responses={@ApiResponse(responseCode="200", description="Exported csv with user information", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    public String exportUsersCsv(@Context SecurityContext securityContext, @Parameter(description="Name of the team to under which the users are imported to", required=true, schema=@Schema(type="string")) @QueryParam(value="team") String team) throws IOException {
        return this.exportCsvInternal(securityContext, team);
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"text/plain"})
    @Valid
    @Operation(operationId="importTeams", summary="Import from CSV to create, and update teams.", responses={@ApiResponse(responseCode="200", description="Import result", content={@Content(mediaType="application/json", schema=@Schema(implementation=CsvImportResult.class))})})
    public CsvImportResult importCsv(@Context SecurityContext securityContext, @Parameter(description="Name of the team to under which the users are imported to", required=true, schema=@Schema(type="string")) @QueryParam(value="team") String team, @Parameter(description="Dry-run when true is used for validating the CSV without really importing it. (default=true)", schema=@Schema(type="boolean")) @DefaultValue(value="true") @QueryParam(value="dryRun") boolean dryRun, String csv) throws IOException {
        return this.importCsvInternal(securityContext, team, csv, dryRun);
    }

    public static User getUser(String updatedBy, CreateUser create) {
        return new User().withId(UUID.randomUUID()).withName(create.getName()).withFullyQualifiedName(create.getName()).withEmail(create.getEmail()).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withIsBot(create.getIsBot()).withIsAdmin(create.getIsAdmin()).withProfile(create.getProfile()).withPersonas(create.getPersonas()).withDefaultPersona(create.getDefaultPersona()).withTimezone(create.getTimezone()).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTeams(EntityUtil.toEntityReferences(create.getTeams(), "team")).withRoles(EntityUtil.toEntityReferences(create.getRoles(), "role"));
    }

    public void validateEmailAlreadyExists(String email) {
        if (((UserRepository)this.repository).checkEmailAlreadyExists(email)) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "EMAIL_EXISTS", "User with Email Already Exists");
        }
    }

    private Response createOrUpdateBot(User user, CreateUser create, UriInfo uriInfo, SecurityContext securityContext) {
        User original = this.retrieveBotUser(user, uriInfo);
        String botName = create.getBotName();
        EntityInterface bot = this.retrieveBot(botName);
        if (original != null && (original.getIsBot() == null || Boolean.FALSE.equals(original.getIsBot()))) {
            throw new IllegalArgumentException(String.format("User [%s] already exists.", original.getName()));
        }
        if (!this.botHasRelationshipWithUser(bot, original) && original != null && this.userHasRelationshipWithAnyBot(original, bot)) {
            List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(original);
            bot = Entity.getEntityRepository("bot").get(null, ((CollectionDAO.EntityRelationshipRecord)userBotRelationship.stream().findFirst().orElseThrow()).getId(), EntityUtil.Fields.EMPTY_FIELDS);
            throw new IllegalArgumentException(CatalogExceptionMessage.userAlreadyBot(user.getName(), bot.getName()));
        }
        if (original != null) {
            EntityMaskerFactory.getEntityMasker().unmaskAuthenticationMechanism(user.getName(), create.getAuthenticationMechanism(), original.getAuthenticationMechanism());
            user.setRoles(original.getRoles());
        }
        this.addAuthMechanismToBot(user, create, uriInfo);
        RestUtil.PutResponse<User> response = ((UserRepository)this.repository).createOrUpdate(uriInfo, user);
        this.decryptOrNullify(securityContext, response.getEntity());
        return response.toResponse();
    }

    private EntityInterface retrieveBot(String botName) {
        try {
            return Entity.getEntityRepository("bot").getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean userHasRelationshipWithAnyBot(User user, EntityInterface botUser) {
        List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(user);
        return !userBotRelationship.isEmpty() && (botUser == null || userBotRelationship.stream().anyMatch(relationship -> !relationship.getId().equals(botUser.getId())));
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(User user) {
        return ((UserRepository)this.repository).findFromRecords(user.getId(), "user", Relationship.CONTAINS, "bot");
    }

    private boolean botHasRelationshipWithUser(EntityInterface bot, User user) {
        if (bot == null || user == null) {
            return false;
        }
        List<CollectionDAO.EntityRelationshipRecord> botUserRelationships = this.retrieveBotRelationshipsFor(bot);
        return !botUserRelationships.isEmpty() && botUserRelationships.get(0).getId().equals(user.getId());
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(EntityInterface bot) {
        return ((UserRepository)this.repository).findToRecords(bot.getId(), "bot", Relationship.CONTAINS, "user");
    }

    private void addAuthMechanismToBot(User user, @Valid CreateUser create, UriInfo uriInfo) {
        AuthenticationMechanism authMechanism;
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("Authentication mechanism change is only supported for bot users");
        }
        if (this.isValidAuthenticationMechanism(create)) {
            authMechanism = create.getAuthenticationMechanism();
            AuthenticationMechanism.AuthType authType = authMechanism.getAuthType();
            switch (authType) {
                case JWT: {
                    User original = this.retrieveBotUser(user, uriInfo);
                    if (original == null || !this.hasAJWTAuthMechanism(original.getAuthenticationMechanism())) {
                        JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
                        authMechanism.setConfig((Object)this.jwtTokenGenerator.generateJWTToken(user, jwtAuthMechanism.getJWTTokenExpiry()));
                        break;
                    }
                    authMechanism = original.getAuthenticationMechanism();
                    break;
                }
                case SSO: {
                    SSOAuthMechanism ssoAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), SSOAuthMechanism.class);
                    authMechanism.setConfig((Object)ssoAuthMechanism);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authType.value()));
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("Authentication mechanism is empty bot user: [%s]", user.getName()));
        }
        user.setAuthenticationMechanism(authMechanism);
    }

    @Nullable
    private User retrieveBotUser(User user, UriInfo uriInfo) {
        User original;
        try {
            original = ((UserRepository)this.repository).getByName(uriInfo, user.getFullyQualifiedName(), ((UserRepository)this.repository).getFieldsWithUserAuth("*"));
        }
        catch (EntityNotFoundException exc) {
            LOG.debug(String.format("User not found when adding auth mechanism for: [%s]", user.getName()));
            original = null;
        }
        return original;
    }

    private void addAuthMechanismToUser(User user, @Valid CreateUser create) {
        if (!create.getPassword().equals(create.getConfirmPassword())) {
            throw new IllegalArgumentException("Password and Confirm Password should be same.");
        }
        PasswordUtil.validatePassword(create.getPassword());
        String newHashedPwd = BCrypt.withDefaults().hashToString(12, create.getPassword().toCharArray());
        BasicAuthMechanism newAuthForUser = new BasicAuthMechanism().withPassword(newHashedPwd);
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthForUser));
    }

    private boolean hasAJWTAuthMechanism(AuthenticationMechanism authMechanism) {
        if (authMechanism != null && AuthenticationMechanism.AuthType.JWT.equals((Object)authMechanism.getAuthType())) {
            JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
            return jwtAuthMechanism != null && jwtAuthMechanism.getJWTToken() != null && !"".equals(jwtAuthMechanism.getJWTToken());
        }
        return false;
    }

    private boolean isValidAuthenticationMechanism(CreateUser create) {
        if (create.getAuthenticationMechanism() == null) {
            return false;
        }
        if (create.getAuthenticationMechanism().getConfig() != null && create.getAuthenticationMechanism().getAuthType() != null) {
            return true;
        }
        throw new IllegalArgumentException(String.format("Incomplete authentication mechanism parameters for bot user: [%s]", create.getName()));
    }

    private void decryptOrNullify(SecurityContext securityContext, User user) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (Boolean.TRUE.equals(user.getIsBot()) && user.getAuthenticationMechanism() != null) {
            try {
                this.authorizer.authorize(securityContext, new OperationContext(this.entityType, MetadataOperation.VIEW_ALL), this.getResourceContextById(user.getId()));
            }
            catch (AuthorizationException e) {
                user.getAuthenticationMechanism().setConfig(null);
            }
            secretsManager.decryptAuthenticationMechanism(user.getName(), user.getAuthenticationMechanism());
            if (this.authorizer.shouldMaskPasswords(securityContext)) {
                EntityMaskerFactory.getEntityMasker().maskAuthenticationMechanism(user.getName(), user.getAuthenticationMechanism());
            }
        }
        PIIMasker.maskUser(this.authorizer, securityContext, user);
    }

    public static class PersonalAccessTokenList
    extends ResultList<PersonalAccessToken> {
    }

    public static class UserList
    extends ResultList<User> {
    }
}

