/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DataProductIndex(DataProduct dataProduct) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.dataProduct;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.dataProduct, "dataProduct");
        doc.putAll(commonAttributes);
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

