/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class IngestionPipelineIndex
implements SearchIndex {
    final IngestionPipeline ingestionPipeline;
    final Set<String> excludeFields = Set.of("sourceConfig", "openMetadataServerConnection", "airflowConfig");

    public IngestionPipelineIndex(IngestionPipeline ingestionPipeline) {
        this.ingestionPipeline = ingestionPipeline;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getDisplayName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.ingestionPipeline;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludeFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        serviceSuggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getService() != null ? this.ingestionPipeline.getService().getName() : null).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("ingestionPipeline", (EntityInterface)this.ingestionPipeline));
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.ingestionPipeline, "ingestionPipeline");
        doc.putAll(commonAttributes);
        doc.put("name", this.ingestionPipeline.getName() != null ? this.ingestionPipeline.getName() : this.ingestionPipeline.getDisplayName());
        doc.put("displayName", this.ingestionPipeline.getDisplayName() != null ? this.ingestionPipeline.getDisplayName() : this.ingestionPipeline.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("service_suggest", serviceSuggest);
        doc.put("service", this.getEntityWithDisplayName(this.ingestionPipeline.getService()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

