/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class MlModelIndex
implements SearchIndex {
    final MlModel mlModel;

    public MlModelIndex(MlModel mlModel) {
        this.mlModel = mlModel;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.mlModel.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.mlModel.getName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.mlModel;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("mlmodel", (EntityInterface)this.mlModel));
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.mlModel, "mlmodel");
        doc.putAll(commonAttributes);
        doc.put("displayName", this.mlModel.getDisplayName() != null ? this.mlModel.getDisplayName() : this.mlModel.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("serviceType", this.mlModel.getServiceType());
        doc.put("lineage", SearchIndex.getLineageData(this.mlModel.getEntityReference()));
        doc.put("service", this.getEntityWithDisplayName(this.mlModel.getService()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("mlFeatures.name", Float.valueOf(8.0f));
        fields.put("mlFeatures.description", Float.valueOf(1.0f));
        return fields;
    }
}

