/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestPlatform;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.TestSuiteIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record TestCaseIndex(TestCase testCase) implements SearchIndex
{
    private static final Set<String> excludeFields = Set.of("testSuites.changeDescription");

    @Override
    public Object getEntity() {
        return this.testCase;
    }

    @Override
    public Set<String> getExcludedFields() {
        return excludeFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testCase.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testCase.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testCase.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "testCase");
        doc.put("owner", this.getEntityWithDisplayName(this.testCase.getOwner()));
        doc.put("tags", this.testCase.getTags());
        doc.put("testPlatforms", this.getTestDefinitionPlatforms(this.testCase.getTestDefinition().getId()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.testCase.getFollowers()));
        this.setParentRelationships(doc, this.testCase);
        return doc;
    }

    private List<TestPlatform> getTestDefinitionPlatforms(UUID testDefinitionId) {
        TestDefinition testDefinition = (TestDefinition)Entity.getEntity("testDefinition", testDefinitionId, "", Include.ALL);
        return testDefinition.getTestPlatforms();
    }

    private void setParentRelationships(Map<String, Object> doc, TestCase testCase) {
        EntityReference testSuiteEntityReference = testCase.getTestSuite();
        if (testSuiteEntityReference == null) {
            return;
        }
        TestSuite testSuite = (TestSuite)Entity.getEntityOrNull(testSuiteEntityReference, "", Include.ALL);
        EntityReference entityReference = testSuite.getExecutableEntityReference();
        TestSuiteIndex.addTestSuiteParentEntityRelations(entityReference, doc);
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("testSuite.fullyQualifiedName", Float.valueOf(10.0f));
        fields.put("testSuite.name", Float.valueOf(10.0f));
        fields.put("testSuite.description", Float.valueOf(1.0f));
        fields.put("entityLink", Float.valueOf(3.0f));
        fields.put("entityFQN", Float.valueOf(10.0f));
        return fields;
    }
}

