/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.SecretsManagerUpdateException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.jdbi3.WorkflowRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsManagerUpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerUpdateService.class);
    private final SecretsManager secretManager;
    private final SecretsManager oldSecretManager;
    private final UserRepository userRepository;
    private final IngestionPipelineRepository ingestionPipelineRepository;
    private final WorkflowRepository workflowRepository;
    private final Map<Class<? extends ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> connectionTypeRepositoriesMap;

    public SecretsManagerUpdateService(SecretsManager secretsManager, String clusterName) {
        this.secretManager = secretsManager;
        this.connectionTypeRepositoriesMap = this.retrieveConnectionTypeRepositoriesMap();
        this.userRepository = (UserRepository)Entity.getEntityRepository("user");
        this.ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        this.workflowRepository = (WorkflowRepository)Entity.getEntityRepository("workflow");
        this.oldSecretManager = SecretsManagerFactory.createSecretsManager(null, clusterName);
    }

    public void updateEntities() {
        this.updateServices();
        this.updateBotUsers();
        this.updateIngestionPipelines();
        this.updateWorkflows();
    }

    private void updateServices() {
        LOG.info(String.format("Updating services in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveServices().forEach(this::updateService);
    }

    private void updateBotUsers() {
        LOG.info(String.format("Updating bot users in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveBotUsers().forEach(this::updateBotUser);
    }

    private void updateIngestionPipelines() {
        LOG.info(String.format("Updating ingestion pipelines in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveIngestionPipelines().forEach(this::updateIngestionPipeline);
    }

    private void updateWorkflows() {
        LOG.info(String.format("Updating workflows in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveWorkflows().forEach(this::updateWorkflow);
    }

    private void updateService(ServiceEntityInterface serviceEntityInterface) {
        ServiceEntityRepository<?, ?> repository = this.connectionTypeRepositoriesMap.get(serviceEntityInterface.getConnection().getClass());
        try {
            ServiceEntityInterface service = (ServiceEntityInterface)repository.getDao().findEntityById(serviceEntityInterface.getId());
            service.getConnection().setConfig(this.oldSecretManager.decryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), repository.getServiceType()));
            service.getConnection().setConfig(this.secretManager.encryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), repository.getServiceType()));
            repository.getDao().update((EntityInterface)service);
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private List<ServiceEntityInterface> retrieveServices() {
        return this.connectionTypeRepositoriesMap.values().stream().map(this::retrieveServices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ServiceEntityInterface> retrieveServices(ServiceEntityRepository<?, ?> serviceEntityRepository) {
        try {
            return serviceEntityRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(), serviceEntityRepository.getDao().listCount(new ListFilter()), null).getData().stream().map(ServiceEntityInterface.class::cast).filter(service -> !Objects.isNull(service.getConnection()) && !Objects.isNull(service.getConnection().getConfig())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private Map<Class<? extends ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> retrieveConnectionTypeRepositoriesMap() {
        Map<Class<ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> connTypeRepositoriesMap = Entity.getEntityList().stream().map(this::retrieveServiceRepository).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ServiceEntityRepository::getServiceConnectionClass, Function.identity()));
        if (connTypeRepositoriesMap.isEmpty()) {
            throw new SecretsManagerUpdateException("Unexpected error: ServiceRepository not found.");
        }
        return connTypeRepositoriesMap;
    }

    private Optional<ServiceEntityRepository<?, ?>> retrieveServiceRepository(String entityType) {
        try {
            EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
            if (ServiceEntityRepository.class.isAssignableFrom(repository.getClass())) {
                return Optional.of((ServiceEntityRepository)repository);
            }
            return Optional.empty();
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
    }

    private List<User> retrieveBotUsers() {
        try {
            return this.userRepository.listAfter(null, new EntityUtil.Fields(Set.of("authenticationMechanism")), new ListFilter(), this.userRepository.getDao().listCount(new ListFilter()), null).getData().stream().filter(user -> Boolean.TRUE.equals(user.getIsBot())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private void updateBotUser(User botUser) {
        try {
            User user = (User)this.userRepository.getDao().findEntityById(botUser.getId());
            this.oldSecretManager.decryptAuthenticationMechanism(botUser.getName(), user.getAuthenticationMechanism());
            this.secretManager.encryptAuthenticationMechanism(botUser.getName(), user.getAuthenticationMechanism());
            this.userRepository.getDao().update((EntityInterface)user);
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private List<IngestionPipeline> retrieveIngestionPipelines() {
        try {
            return this.ingestionPipelineRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(), this.ingestionPipelineRepository.getDao().listCount(new ListFilter()), null).getData();
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private List<Workflow> retrieveWorkflows() {
        try {
            return this.workflowRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(), this.workflowRepository.getDao().listCount(new ListFilter()), null).getData();
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private void updateIngestionPipeline(IngestionPipeline ingestionPipeline) {
        try {
            IngestionPipeline ingestion = (IngestionPipeline)this.ingestionPipelineRepository.getDao().findEntityById(ingestionPipeline.getId());
            this.oldSecretManager.decryptIngestionPipeline(ingestionPipeline);
            this.secretManager.encryptIngestionPipeline(ingestionPipeline);
            this.ingestionPipelineRepository.getDao().update((EntityInterface)ingestion);
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private void updateWorkflow(Workflow workflow) {
        try {
            Workflow workflowObject = (Workflow)this.workflowRepository.getDao().findEntityById(workflow.getId());
            workflowObject = this.oldSecretManager.decryptWorkflow(workflowObject);
            workflowObject = this.secretManager.encryptWorkflow(workflowObject);
            this.ingestionPipelineRepository.getDao().update((EntityInterface)workflowObject);
        }
        catch (Exception e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }
}

