/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.service.security.SecurityUtil;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/auth/login"})
public class AuthLoginServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AuthLoginServlet.class);
    public static final String OIDC_CREDENTIAL_PROFILE = "oidcCredentialProfile";
    private final OidcClient client;
    private final List<String> claimsOrder;
    private final Map<String, String> claimsMapping;
    private final String serverUrl;
    private final String principalDomain;

    public AuthLoginServlet(OidcClient oidcClient, AuthenticationConfiguration authenticationConfiguration, AuthorizerConfiguration authorizerConfiguration) {
        this.client = oidcClient;
        this.serverUrl = authenticationConfiguration.getOidcConfiguration().getServerUrl();
        this.claimsOrder = authenticationConfiguration.getJwtPrincipalClaims();
        this.claimsMapping = CommonUtil.listOrEmpty((List)authenticationConfiguration.getJwtPrincipalClaimsMapping()).stream().map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
        SecurityUtil.validatePrincipalClaimsMapping(this.claimsMapping);
        this.principalDomain = authorizerConfiguration.getPrincipalDomain();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOG.debug("Performing Auth Login For User Session: {} ", (Object)req.getSession().getId());
            Optional<OidcCredentials> credentials = SecurityUtil.getUserCredentialsFromSession(req, this.client);
            if (credentials.isPresent()) {
                LOG.debug("Auth Tokens Located from Session: {} ", (Object)req.getSession().getId());
                SecurityUtil.sendRedirectWithToken(resp, credentials.get(), this.serverUrl, this.claimsMapping, this.claimsOrder, this.principalDomain);
            } else {
                LOG.debug("Performing Auth Code Flow to Idp: {} ", (Object)req.getSession().getId());
                Map<String, String> params = this.buildParams();
                params.put("redirect_uri", this.client.getCallbackUrl());
                this.addStateAndNonceParameters(req, params);
                if (this.client instanceof GoogleOidcClient) {
                    params.put("prompt", "consent");
                } else {
                    params.put("prompt", "login");
                }
                params.put("max_age", "0");
                String location = this.buildAuthenticationRequestUrl(params);
                LOG.debug("Authentication request url: {}", (Object)location);
                resp.sendRedirect(location);
            }
        }
        catch (Exception e) {
            SecurityUtil.getErrorMessage(resp, (Exception)new TechnicalException((Throwable)e));
        }
    }

    protected Map<String, String> buildParams() {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("scope", this.client.getConfiguration().getScope());
        authParams.put("response_type", this.client.getConfiguration().getResponseType());
        authParams.put("response_mode", "query");
        authParams.putAll(this.client.getConfiguration().getCustomParams());
        authParams.put("client_id", this.client.getConfiguration().getClientId());
        return new HashMap<String, String>(authParams);
    }

    protected void addStateAndNonceParameters(HttpServletRequest request, Map<String, String> params) {
        CodeChallengeMethod pkceMethod;
        if (this.client.getConfiguration().isWithState()) {
            State state = new State(CommonHelper.randomString((int)10));
            params.put("state", state.getValue());
            request.getSession().setAttribute(this.client.getStateSessionAttributeName(), (Object)state);
        }
        if (this.client.getConfiguration().isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            request.getSession().setAttribute(this.client.getNonceSessionAttributeName(), (Object)nonce.getValue());
        }
        if ((pkceMethod = this.client.getConfiguration().findPkceMethod()) == null && !this.client.getConfiguration().isDisablePkce()) {
            pkceMethod = CodeChallengeMethod.S256;
        }
        if (pkceMethod != null) {
            CodeVerifier verfifier = new CodeVerifier(CommonHelper.randomString((int)43));
            request.getSession().setAttribute(this.client.getCodeVerifierSessionAttributeName(), (Object)verfifier);
            params.put("code_challenge", CodeChallenge.compute((CodeChallengeMethod)pkceMethod, (CodeVerifier)verfifier).getValue());
            params.put("code_challenge_method", pkceMethod.getValue());
        }
    }

    protected String buildAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            queryString = AuthenticationRequest.parse(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList((String)e.getValue())))).toQueryString();
        }
        catch (Exception e2) {
            throw new TechnicalException((Throwable)e2);
        }
        return this.client.getConfiguration().getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
    }

    public static void writeJsonResponse(HttpServletResponse response, String message) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().print(message);
        response.getOutputStream().flush();
        response.setStatus(200);
    }
}

