/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import java.util.HashSet;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.service.security.CatalogPrincipal;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NoopFilter.class);
    @Context
    private UriInfo uriInfo;

    public NoopFilter(AuthenticationConfiguration authenticationConfiguration, AuthorizerConfiguration authorizerConfiguration) {
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        CatalogPrincipal catalogPrincipal = new CatalogPrincipal("anonymous", "anonymous@openmetadata.org");
        String scheme = containerRequestContext.getUriInfo().getRequestUri().getScheme();
        CatalogSecurityContext catalogSecurityContext = new CatalogSecurityContext(catalogPrincipal, scheme, "BASIC", new HashSet<String>());
        LOG.debug("SecurityContext {}", (Object)catalogSecurityContext);
        containerRequestContext.setSecurityContext((SecurityContext)catalogSecurityContext);
    }
}

