/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.EntityInfo;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FeedUtils.class);

    private FeedUtils() {
    }

    public static List<Thread> getThreadWithMessage(MessageDecorator<?> messageDecorator, ChangeEvent changeEvent) {
        if (changeEvent == null || changeEvent.getEntity() == null) {
            return Collections.emptyList();
        }
        if (changeEvent.getEntityType().equals("THREAD")) {
            return Collections.emptyList();
        }
        if (Entity.getEntityList().contains(changeEvent.getEntityType())) {
            return FeedUtils.populateMessageForDataAssets(messageDecorator, changeEvent);
        }
        LOG.error("Invalid Entity Type: {}, Currently Change Events are expected as Thread or Data Assets", (Object)changeEvent.getEntityType());
        return Collections.emptyList();
    }

    private static List<Thread> populateMessageForDataAssets(MessageDecorator<?> messageDecorator, ChangeEvent changeEvent) {
        EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(changeEvent);
        MessageParser.EntityLink about = new MessageParser.EntityLink(changeEvent.getEntityType(), entityInterface.getFullyQualifiedName(), null, null, null);
        Thread thread = FeedUtils.getThread(messageDecorator, entityInterface, about.getLinkString(), changeEvent.getEntityType(), changeEvent.getUserName());
        return switch (changeEvent.getEventType()) {
            case EventType.ENTITY_CREATED -> {
                String message = String.format("Created **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                FeedUtils.addEntityInfoToThread(thread, Thread.CardStyle.ENTITY_CREATED, message, entityInterface);
                yield List.of(thread.withMessage(message));
            }
            case EventType.ENTITY_UPDATED -> FormatterUtil.getFormattedMessages(messageDecorator, thread, changeEvent.getChangeDescription());
            case EventType.ENTITY_SOFT_DELETED -> {
                String message = String.format("Soft deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                FeedUtils.addEntityInfoToThread(thread, Thread.CardStyle.ENTITY_SOFT_DELETED, message, entityInterface);
                yield List.of(thread.withMessage(message));
            }
            case EventType.ENTITY_DELETED -> {
                String message = String.format("Permanently Deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                FeedUtils.addEntityInfoToThread(thread, Thread.CardStyle.ENTITY_DELETED, message, entityInterface);
                yield List.of(thread.withMessage(message));
            }
            case EventType.LOGICAL_TEST_CASE_ADDED -> {
                String message = String.format("Added Logical Test Cases to **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                FeedUtils.addEntityInfoToThread(thread, Thread.CardStyle.LOGICAL_TEST_CASE_ADDED, message, entityInterface);
                yield List.of(thread.withMessage(message));
            }
            default -> changeEvent.getChangeDescription() == null ? Collections.emptyList() : FormatterUtil.getFormattedMessages(messageDecorator, thread, changeEvent.getChangeDescription());
        };
    }

    private static void addEntityInfoToThread(Thread thread, Thread.CardStyle cardStyle, String message, EntityInterface entityInterface) {
        thread.withMessage(message);
        thread.withCardStyle(cardStyle);
        thread.withFieldOperation(Thread.FieldOperation.NONE);
        thread.withFeedInfo(new FeedInfo().withFieldName(null).withHeaderMessage(message).withEntitySpecificInfo((Object)new EntityInfo().withEntity((Object)entityInterface)));
    }

    public static Thread getThread(MessageDecorator<?> decorator, EntityInterface entityInterface, String linkString, String entityType, String loggedInUserName) {
        return new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withCreatedBy(loggedInUserName).withAbout(linkString).withEntityId(entityInterface.getId()).withEntityType(entityType).withReactions(Collections.emptyList()).withUpdatedBy(loggedInUserName).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withGeneratedBy(Thread.GeneratedBy.SYSTEM).withEntityUrlLink(decorator.buildEntityUrl(entityType, entityInterface));
    }
}

