/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Profile;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.schema.type.profile.SubscriptionConfig;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionUtil.class);

    private SubscriptionUtil() {
    }

    public static Set<String> getAdminsData(SubscriptionDestination.SubscriptionType type) {
        HashSet<String> data = new HashSet<String>();
        UserRepository userEntityRepository = (UserRepository)Entity.getEntityRepository("user");
        ListFilter listFilter = new ListFilter(Include.ALL);
        listFilter.addQueryParam("isAdmin", "true");
        String after = null;
        try {
            ResultList result;
            do {
                result = userEntityRepository.listAfter(null, userEntityRepository.getFields("email,profile"), listFilter, 50, after);
                data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(result.getData(), type));
            } while ((after = result.getPaging().getAfter()) != null);
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Users , Reason", (Throwable)ex);
        }
        return data;
    }

    public static Set<String> getEmailOrWebhookEndpointForUsers(List<User> users, SubscriptionDestination.SubscriptionType type) {
        if (type == SubscriptionDestination.SubscriptionType.EMAIL) {
            return users.stream().map(User::getEmail).collect(Collectors.toSet());
        }
        return users.stream().map(user -> SubscriptionUtil.getWebhookUrlFromProfile(user.getProfile(), user.getId(), "user", type)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static Set<String> getEmailOrWebhookEndpointForTeams(List<Team> users, SubscriptionDestination.SubscriptionType type) {
        if (type == SubscriptionDestination.SubscriptionType.EMAIL) {
            return users.stream().map(Team::getEmail).collect(Collectors.toSet());
        }
        return users.stream().map(team -> SubscriptionUtil.getWebhookUrlFromProfile(team.getProfile(), team.getId(), "team", type)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static Set<String> getOwnerOrFollowers(SubscriptionDestination.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType, Relationship relationship) {
        HashSet<String> data = new HashSet<String>();
        try {
            List<CollectionDAO.EntityRelationshipRecord> ownerOrFollowers = daoCollection.relationshipDAO().findFrom(entityId, entityType, relationship.ordinal());
            List<User> users = ownerOrFollowers.stream().filter(e -> "user".equals(e.getType())).map(user -> (User)Entity.getEntity("user", user.getId(), "", Include.NON_DELETED)).toList();
            data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users, type));
            List<Team> teams = ownerOrFollowers.stream().filter(e -> "team".equals(e.getType())).map(team -> (Team)Entity.getEntity("team", team.getId(), "", Include.NON_DELETED)).toList();
            data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams, type));
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Owners/Followers, Reason : ", (Throwable)ex);
        }
        return data;
    }

    private static Set<String> getTaskAssignees(SubscriptionDestination.SubscriptionCategory category, SubscriptionDestination.SubscriptionType type, ChangeEvent event) {
        Thread thread = AlertsRuleEvaluator.getThread(event);
        HashSet<String> receiversList = new HashSet<String>();
        HashMap<UUID, Team> teams = new HashMap<UUID, Team>();
        HashMap<UUID, User> users = new HashMap<UUID, User>();
        Team tempTeamVar = null;
        User tempUserVar = null;
        if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.ASSIGNEES)) {
            List assignees = thread.getTask().getAssignees();
            if (!CommonUtil.nullOrEmpty((List)assignees)) {
                for (EntityReference reference : assignees) {
                    if ("user".equals(reference.getType())) {
                        tempUserVar = (User)Entity.getEntity("user", reference.getId(), "profile", Include.NON_DELETED);
                        users.put(tempUserVar.getId(), tempUserVar);
                        continue;
                    }
                    if (!"team".equals(reference.getType())) continue;
                    tempTeamVar = (Team)Entity.getEntity("team", reference.getId(), "profile", Include.NON_DELETED);
                    teams.put(tempTeamVar.getId(), tempTeamVar);
                }
            }
            for (Post post : thread.getPosts()) {
                tempUserVar = (User)Entity.getEntityByName("user", post.getFrom(), "profile", Include.NON_DELETED);
                users.put(tempUserVar.getId(), tempUserVar);
                List<MessageParser.EntityLink> mentions = MessageParser.getEntityLinks(post.getMessage());
                for (MessageParser.EntityLink link : mentions) {
                    if ("user".equals(link.getEntityType())) {
                        tempUserVar = (User)Entity.getEntity(link, "profile", Include.NON_DELETED);
                        users.put(tempUserVar.getId(), tempUserVar);
                        continue;
                    }
                    if (!"team".equals(link.getEntityType())) continue;
                    tempTeamVar = (Team)Entity.getEntity(link, "profile", Include.NON_DELETED);
                    teams.put(tempTeamVar.getId(), tempTeamVar);
                }
            }
        }
        if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.OWNERS)) {
            try {
                tempUserVar = (User)Entity.getEntityByName("user", thread.getCreatedBy(), "profile", Include.NON_DELETED);
                users.put(tempUserVar.getId(), tempUserVar);
            }
            catch (Exception ex) {
                LOG.warn("Thread created by unknown user: {}", (Object)thread.getCreatedBy());
            }
        }
        receiversList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users.values().stream().toList(), type));
        receiversList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams.values().stream().toList(), type));
        return receiversList;
    }

    public static Set<String> handleConversationNotification(SubscriptionDestination.SubscriptionCategory category, SubscriptionDestination.SubscriptionType type, ChangeEvent event) {
        Thread thread = AlertsRuleEvaluator.getThread(event);
        HashSet<String> receiversList = new HashSet<String>();
        HashMap<UUID, Team> teams = new HashMap<UUID, Team>();
        HashMap<UUID, User> users = new HashMap<UUID, User>();
        Team tempTeamVar = null;
        User tempUserVar = null;
        if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.MENTIONS)) {
            List<MessageParser.EntityLink> mentions = MessageParser.getEntityLinks(thread.getMessage());
            for (MessageParser.EntityLink link : mentions) {
                if ("user".equals(link.getEntityType())) {
                    tempUserVar = (User)Entity.getEntity(link, "profile", Include.NON_DELETED);
                    users.put(tempUserVar.getId(), tempUserVar);
                    continue;
                }
                if (!"team".equals(link.getEntityType())) continue;
                tempTeamVar = (Team)Entity.getEntity(link, "", Include.NON_DELETED);
                teams.put(tempTeamVar.getId(), tempTeamVar);
            }
            for (Post post : thread.getPosts()) {
                tempUserVar = (User)Entity.getEntityByName("user", post.getFrom(), "profile", Include.NON_DELETED);
                users.put(tempUserVar.getId(), tempUserVar);
                mentions = MessageParser.getEntityLinks(post.getMessage());
                for (MessageParser.EntityLink link : mentions) {
                    if ("user".equals(link.getEntityType())) {
                        tempUserVar = (User)Entity.getEntity(link, "profile", Include.NON_DELETED);
                        users.put(tempUserVar.getId(), tempUserVar);
                        continue;
                    }
                    if (!"team".equals(link.getEntityType())) continue;
                    tempTeamVar = (Team)Entity.getEntity(link, "profile", Include.NON_DELETED);
                    teams.put(tempTeamVar.getId(), tempTeamVar);
                }
            }
        }
        if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.OWNERS)) {
            try {
                tempUserVar = (User)Entity.getEntityByName("user", thread.getCreatedBy(), "profile", Include.NON_DELETED);
                users.put(tempUserVar.getId(), tempUserVar);
            }
            catch (Exception ex) {
                LOG.warn("Thread created by unknown user: {}", (Object)thread.getCreatedBy());
            }
        }
        receiversList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users.values().stream().toList(), type));
        receiversList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams.values().stream().toList(), type));
        return receiversList;
    }

    private static Optional<String> getWebhookUrlFromProfile(Profile profile, UUID id, String entityType, SubscriptionDestination.SubscriptionType type) {
        SubscriptionConfig subscriptionConfig;
        if (profile != null && (subscriptionConfig = profile.getSubscription()) != null) {
            Webhook webhookConfig;
            switch (type) {
                case SLACK: {
                    Webhook webhook = profile.getSubscription().getSlack();
                    break;
                }
                case MS_TEAMS: {
                    Webhook webhook = profile.getSubscription().getMsTeams();
                    break;
                }
                case G_CHAT: {
                    Webhook webhook = profile.getSubscription().getgChat();
                    break;
                }
                case WEBHOOK: {
                    Webhook webhook = profile.getSubscription().getGeneric();
                    break;
                }
                default: {
                    Webhook webhook = webhookConfig = null;
                }
            }
            if (webhookConfig != null && !CommonUtil.nullOrEmpty((Object)webhookConfig.getEndpoint())) {
                return Optional.of(webhookConfig.getEndpoint().toString());
            }
            LOG.debug("[GetWebhookUrlsFromProfile] Owner with id {} type {}, will not get any Notification as not webhook config is missing for type {}, webhookConfig {} ", new Object[]{id, entityType, type.value(), webhookConfig});
        }
        LOG.debug("[GetWebhookUrlsFromProfile] Failed to Get Profile for Owner with ID : {} and type {} ", (Object)id, (Object)type);
        return Optional.empty();
    }

    public static Set<String> buildReceiversListFromActions(SubscriptionAction action, SubscriptionDestination.SubscriptionCategory category, SubscriptionDestination.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType) {
        HashSet<String> receiverList = new HashSet<String>();
        if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.USERS)) {
            if (CommonUtil.nullOrEmpty((Object)action.getReceivers())) {
                throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings. Emtpy or Null Users Recipients List");
            }
            List<User> users = action.getReceivers().stream().map(user -> (User)Entity.getEntityByName("user", user, "", Include.NON_DELETED)).toList();
            receiverList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users, type));
        } else if (category.equals((Object)SubscriptionDestination.SubscriptionCategory.TEAMS)) {
            if (CommonUtil.nullOrEmpty((Object)action.getReceivers())) {
                throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings. Emtpy or Null Teams Recipients List");
            }
            List<Team> teams = action.getReceivers().stream().map(team -> (Team)Entity.getEntityByName("team", team, "", Include.NON_DELETED)).toList();
            receiverList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams, type));
        } else {
            Set<String> set = receiverList = action.getReceivers() == null ? receiverList : action.getReceivers();
        }
        if (Boolean.TRUE.equals(action.getSendToAdmins())) {
            receiverList.addAll(SubscriptionUtil.getAdminsData(type));
        }
        if (Boolean.TRUE.equals(action.getSendToOwners())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.OWNS));
        }
        if (Boolean.TRUE.equals(action.getSendToFollowers())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.FOLLOWS));
        }
        return receiverList;
    }

    public static Set<String> getTargetsForAlert(SubscriptionAction action, SubscriptionDestination.SubscriptionCategory category, SubscriptionDestination.SubscriptionType type, ChangeEvent event) {
        HashSet<String> receiverUrls = new HashSet<String>();
        if (event.getEntityType().equals("THREAD")) {
            Thread thread = AlertsRuleEvaluator.getThread(event);
            switch (thread.getType()) {
                case Task: {
                    receiverUrls.addAll(SubscriptionUtil.getTaskAssignees(category, type, event));
                    break;
                }
                case Conversation: {
                    receiverUrls.addAll(SubscriptionUtil.handleConversationNotification(category, type, event));
                }
            }
        } else {
            EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(event);
            receiverUrls.addAll(SubscriptionUtil.buildReceiversListFromActions(action, category, type, Entity.getCollectionDAO(), entityInterface.getId(), event.getEntityType()));
        }
        return receiverUrls;
    }

    public static List<Invocation.Builder> getTargetsForWebhookAlert(SubscriptionAction action, SubscriptionDestination.SubscriptionCategory category, SubscriptionDestination.SubscriptionType type, Client client, ChangeEvent event) {
        ArrayList<Invocation.Builder> targets = new ArrayList<Invocation.Builder>();
        for (String url : SubscriptionUtil.getTargetsForAlert(action, category, type, event)) {
            targets.add(client.target(url).request());
        }
        return targets;
    }

    public static void postWebhookMessage(Destination<ChangeEvent> destination, Invocation.Builder target, Object message) {
        long attemptTime = System.currentTimeMillis();
        Response response = target.post(javax.ws.rs.client.Entity.entity((Object)message, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        LOG.debug("Subscription Destination Posted Message {}:{} received response {}", new Object[]{destination.getSubscriptionDestination().getId(), message, response.getStatusInfo()});
        if (response.getStatus() >= 300 && response.getStatus() < 400) {
            destination.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
        } else if (response.getStatus() >= 400 && response.getStatus() < 600) {
            destination.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
        } else if (response.getStatus() == 200) {
            destination.setSuccessStatus(System.currentTimeMillis());
        }
    }

    public static Client getClient(int connectTimeout, int readTimeout) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)connectTimeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)readTimeout, TimeUnit.SECONDS);
        return clientBuilder.build();
    }
}

