/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UserUtil.class);

    private UserUtil() {
    }

    public static void addUsers(AuthProvider authProvider, Set<String> adminUsers, String domain, Boolean isAdmin) {
        try {
            for (String username : adminUsers) {
                UserUtil.createOrUpdateUser(authProvider, username, domain, isAdmin);
            }
        }
        catch (Exception ex) {
            LOG.error("[BootstrapUser] Encountered Exception while bootstrapping admin user", (Throwable)ex);
        }
    }

    private static void createOrUpdateUser(AuthProvider authProvider, String username, String domain, Boolean isAdmin) {
        User updatedUser;
        block9: {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            updatedUser = null;
            try {
                HashSet<String> fieldList = new HashSet<String>(userRepository.getPatchFields().getFieldList());
                fieldList.add("authenticationMechanism");
                User originalUser = userRepository.getByName(null, username, new EntityUtil.Fields(fieldList));
                if (Boolean.FALSE.equals(originalUser.getIsBot()) && Boolean.FALSE.equals(originalUser.getIsAdmin())) {
                    updatedUser = originalUser;
                    if (authProvider.equals((Object)AuthProvider.BASIC)) {
                        if (originalUser.getAuthenticationMechanism() == null || originalUser.getAuthenticationMechanism().equals((Object)new AuthenticationMechanism())) {
                            String randomPwd = UserUtil.getPassword(username);
                            UserUtil.updateUserWithHashedPwd(updatedUser, randomPwd);
                            EmailUtil.sendInviteMailToAdmin(updatedUser, randomPwd);
                        }
                    } else {
                        updatedUser.setAuthenticationMechanism(new AuthenticationMechanism());
                    }
                    updatedUser.setIsAdmin(isAdmin);
                    updatedUser.setEmail(String.format("%s@%s", username, domain));
                } else if (Boolean.TRUE.equals(originalUser.getIsBot())) {
                    LOG.error(String.format("You configured bot user %s in initialAdmins config. Bot user cannot be promoted to be an admin.", originalUser.getName()));
                }
            }
            catch (EntityNotFoundException e) {
                updatedUser = UserUtil.user(username, domain, username).withIsAdmin(isAdmin).withIsEmailVerified(Boolean.valueOf(true));
                if (!authProvider.equals((Object)AuthProvider.BASIC)) break block9;
                String randomPwd = UserUtil.getPassword(username);
                UserUtil.updateUserWithHashedPwd(updatedUser, randomPwd);
                EmailUtil.sendInviteMailToAdmin(updatedUser, randomPwd);
            }
        }
        if (updatedUser != null) {
            UserUtil.addOrUpdateUser(updatedUser);
        }
    }

    private static String getPassword(String username) {
        try {
            if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer()) && !"admin".equals(username)) {
                EmailUtil.testConnection();
                return PasswordUtil.generateRandomPassword();
            }
        }
        catch (Exception ex) {
            LOG.info("Password set to Default.");
        }
        return "admin";
    }

    public static void updateUserWithHashedPwd(User user, String pwd) {
        String hashedPwd = BCrypt.withDefaults().hashToString(12, pwd.toCharArray());
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)new BasicAuthMechanism().withPassword(hashedPwd)));
    }

    public static User addOrUpdateUser(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            RestUtil.PutResponse<User> addedUser = userRepository.createOrUpdate(null, user);
            LOG.debug("Added user entry: {}", (Object)addedUser.getEntity().getName());
            return addedUser.getEntity();
        }
        catch (Exception exception) {
            LOG.debug("Caught exception", (Throwable)exception);
            user.setAuthenticationMechanism(null);
            return null;
        }
    }

    public static User user(String name, String domain, String updatedBy) {
        return new User().withId(UUID.randomUUID()).withName(name).withFullyQualifiedName(EntityInterfaceUtil.quoteName((String)name)).withEmail(name + "@" + domain).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsBot(Boolean.valueOf(false));
    }

    public static User addOrUpdateBotUser(User user) {
        AuthenticationMechanism authMechanism;
        User originalUser = UserUtil.retrieveWithAuthMechanism(user);
        AuthenticationMechanism authenticationMechanism = authMechanism = originalUser != null ? originalUser.getAuthenticationMechanism() : null;
        if (authMechanism == null) {
            authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(null, user));
        }
        user.setAuthenticationMechanism(authMechanism);
        user.setDescription(user.getDescription());
        user.setDisplayName(user.getDisplayName());
        return UserUtil.addOrUpdateUser(user);
    }

    private static JWTAuthMechanism buildJWTAuthMechanism(OpenMetadataJWTClientConfig jwtClientConfig, User user) {
        return Objects.isNull(jwtClientConfig) || CommonUtil.nullOrEmpty((String)jwtClientConfig.getJwtToken()) ? JWTTokenGenerator.getInstance().generateJWTToken(user, JWTTokenExpiry.Unlimited) : new JWTAuthMechanism().withJWTToken(jwtClientConfig.getJwtToken()).withJWTTokenExpiry(JWTTokenExpiry.Unlimited);
    }

    private static AuthenticationMechanism buildAuthMechanism(AuthenticationMechanism.AuthType authType, Object config) {
        return new AuthenticationMechanism().withAuthType(authType).withConfig(config);
    }

    private static User retrieveWithAuthMechanism(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            return (User)userRepository.getByName(null, user.getName(), new EntityUtil.Fields(Set.of("authenticationMechanism")));
        }
        catch (EntityNotFoundException e) {
            LOG.debug("Bot entity: {} does not exists.", (Object)user);
            return null;
        }
    }

    public static EntityReference getUserOrBot(String name) {
        EntityReference userOrBot;
        try {
            userOrBot = Entity.getEntityReferenceByName("user", name, Include.NON_DELETED);
        }
        catch (EntityNotFoundException e) {
            userOrBot = Entity.getEntityReferenceByName("bot", name, Include.NON_DELETED);
        }
        return userOrBot;
    }

    public static Set<String> getRoleListFromUser(User user) {
        if (CommonUtil.nullOrEmpty((List)user.getRoles())) {
            return new HashSet<String>();
        }
        return CommonUtil.listOrEmpty((List)user.getRoles()).stream().map(EntityReference::getName).collect(Collectors.toSet());
    }

    public static List<EntityReference> validateAndGetRolesRef(Set<String> rolesList) {
        if (CommonUtil.nullOrEmpty(rolesList)) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> references = new ArrayList<EntityReference>();
        for (String role : rolesList) {
            if (role.equals("Admin")) continue;
            try {
                Role fetchedRole = (Role)Entity.getEntityByName("role", role, "id", Include.NON_DELETED, true);
                references.add(fetchedRole.getEntityReference());
            }
            catch (EntityNotFoundException ex) {
                LOG.error("[ReSyncRoles] Role not found: {}", (Object)role, (Object)ex);
            }
        }
        return references;
    }

    public static Set<String> getRolesFromAuthorizationToken(CatalogSecurityContext catalogSecurityContext) {
        return catalogSecurityContext.getUserRoles();
    }

    public static boolean isRolesSyncNeeded(Set<String> fromToken, Set<String> fromDB) {
        for (String role : fromToken) {
            if (fromDB.contains(role)) continue;
            return true;
        }
        for (String role : fromDB) {
            if (fromToken.contains(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean reSyncUserRolesFromToken(UriInfo uriInfo, User user, Set<String> rolesFromToken) {
        boolean syncUser = false;
        User updatedUser = JsonUtils.deepCopy(user, User.class);
        if (rolesFromToken.contains("Admin")) {
            if (Boolean.FALSE.equals(user.getIsAdmin())) {
                syncUser = true;
                updatedUser.setIsAdmin(Boolean.valueOf(true));
            }
            rolesFromToken.remove("Admin");
        }
        Set<String> rolesFromUser = UserUtil.getRoleListFromUser(user);
        if (!CommonUtil.nullOrEmpty(rolesFromToken) && UserUtil.isRolesSyncNeeded(rolesFromToken, rolesFromUser)) {
            syncUser = true;
            List<EntityReference> rolesReferenceFromToken = UserUtil.validateAndGetRolesRef(rolesFromToken);
            updatedUser.setRoles(rolesReferenceFromToken);
        }
        if (syncUser) {
            LOG.info("Syncing User Roles for User: {}", (Object)user.getName());
            JsonPatch patch = JsonUtils.getJsonPatch(user, updatedUser);
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            userRepository.patch(uriInfo, user.getId(), user.getName(), patch);
            user.setRoles(updatedUser.getRoles());
        }
        return syncUser;
    }
}

