/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.validation.ValidationCode;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

public abstract class BaseJsonValidator<O extends OAI>
implements JsonValidator {
    private static final String VALIDATION_ERR_MSG = "Schema validation failed";
    private final JsonNode schemaNode;
    private final JsonNode schemaParentNode;
    private final SchemaValidator parentSchema;
    protected final ValidationContext<O> context;

    protected BaseJsonValidator(ValidationContext<O> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        this.context = context;
        this.schemaNode = schemaNode;
        this.schemaParentNode = schemaParentNode;
        this.parentSchema = parentSchema;
    }

    @Override
    public void validate(JsonNode valueNode) throws ValidationException {
        ValidationData validation = new ValidationData();
        this.validate(valueNode, validation);
        if (!validation.isValid()) {
            throw new ValidationException(VALIDATION_ERR_MSG, validation.results());
        }
    }

    protected void validate(ValidationCode code) {
        try {
            code.validate();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonNode getParentSchemaNode() {
        return this.schemaParentNode;
    }

    public SchemaValidator getParentSchema() {
        return this.parentSchema;
    }
}

