/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MinimumValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult EXCLUSIVE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1014), "Excluded minimum is '%s', found '%s'.");
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1015), "Minimum is '%s', found '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("minimum", true);
    private final BigDecimal minimum;
    private final boolean excludeEqual;

    MinimumValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.minimum = schemaNode.isNumber() ? schemaNode.decimalValue() : null;
        JsonNode exclusiveMaximumNode = schemaParentNode.get("exclusiveMinimum");
        this.excludeEqual = exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean() ? exclusiveMaximumNode.booleanValue() : false;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.minimum == null || !valueNode.isNumber()) {
            return false;
        }
        BigDecimal value = valueNode.decimalValue();
        int compResult = value.compareTo(this.minimum);
        if (this.excludeEqual && compResult == 0) {
            validation.add(CRUMB_INFO, EXCLUSIVE_ERR, this.minimum, value);
        } else if (compResult < 0) {
            validation.add(CRUMB_INFO, ERR, this.minimum, value);
        }
        return false;
    }
}

