/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class PropertiesValidator
extends BaseJsonValidator<OAI3> {
    private final Map<String, SchemaValidator> schemas = new HashMap<String, SchemaValidator>();

    PropertiesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        Iterator it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            this.schemas.put(pname, new SchemaValidator(context, new ValidationResults.CrumbInfo(pname, false), schemaNode.get(pname), schemaParentNode, parentSchema));
        }
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        this.validate(() -> {
            for (Map.Entry<String, SchemaValidator> entry : this.schemas.entrySet()) {
                SchemaValidator propertySchema = entry.getValue();
                JsonNode propertyNode = valueNode.get(entry.getKey());
                if (propertyNode == null) continue;
                propertySchema.validateWithContext(propertyNode, validation);
            }
        });
        return false;
    }
}

