/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class TypeValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1027), "Type expected '%s', found '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("type", true);
    private static final String TYPE_NULL = "null";
    private final String type;

    TypeValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.type = schemaNode.textValue();
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        String valueType = this.getTypeFromValue(valueNode);
        if (!valueType.equals(this.type)) {
            if ("number".equals(this.type) && "integer".equals(valueType)) {
                return false;
            }
            if (!TYPE_NULL.equals(valueType)) {
                validation.add(CRUMB_INFO, ERR, this.type, valueType);
            }
        }
        return false;
    }

    private String getTypeFromValue(JsonNode valueNode) {
        if (valueNode.isContainerNode()) {
            return valueNode.isObject() ? "object" : "array";
        }
        if (valueNode.isTextual()) {
            return "string";
        }
        if (valueNode.isIntegralNumber()) {
            return "integer";
        }
        if (valueNode.isNumber()) {
            return "number";
        }
        if (valueNode.isBoolean()) {
            return "boolean";
        }
        return TYPE_NULL;
    }
}

