/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class UniqueItemsValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1028), "Uniqueness is not respected '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("uniqueItems", true);
    private final boolean unique;

    UniqueItemsValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.unique = schemaNode.isBoolean() && schemaNode.booleanValue();
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (!this.unique) {
            return false;
        }
        HashSet<JsonNode> set = new HashSet<JsonNode>();
        for (JsonNode n : valueNode) {
            if (set.add(n)) continue;
            validation.add(CRUMB_INFO, ERR, n.asText());
        }
        return false;
    }
}

