/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.GzipFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.mustache.CaseFormatLambda;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
GzipFeatures {
    static final String MEDIA_TYPE = "mediaType";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaClientCodegen.class);
    public static final String USE_RX_JAVA = "useRxJava";
    public static final String USE_RX_JAVA2 = "useRxJava2";
    public static final String DO_NOT_USE_RX = "doNotUseRx";
    public static final String USE_PLAY_WS = "usePlayWS";
    public static final String PLAY_VERSION = "playVersion";
    public static final String PARCELABLE_MODEL = "parcelableModel";
    public static final String USE_RUNTIME_EXCEPTION = "useRuntimeException";
    public static final String PLAY_24 = "play24";
    public static final String PLAY_25 = "play25";
    public static final String PLAY_26 = "play26";
    public static final String FEIGN = "feign";
    public static final String GOOGLE_API_CLIENT = "google-api-client";
    public static final String JERSEY1 = "jersey1";
    public static final String JERSEY2 = "jersey2";
    public static final String OKHTTP_GSON = "okhttp-gson";
    public static final String RESTEASY = "resteasy";
    public static final String RESTTEMPLATE = "resttemplate";
    public static final String WEBCLIENT = "webclient";
    public static final String REST_ASSURED = "rest-assured";
    public static final String RETROFIT_1 = "retrofit";
    public static final String RETROFIT_2 = "retrofit2";
    public static final String VERTX = "vertx";
    protected String gradleWrapperPackage = "gradle.wrapper";
    protected boolean useRxJava = false;
    protected boolean useRxJava2 = false;
    protected boolean doNotUseRx = true;
    protected boolean usePlayWS = false;
    protected String playVersion = "play25";
    protected boolean parcelableModel = false;
    protected boolean useBeanValidation = false;
    protected boolean performBeanValidation = false;
    protected boolean useGzipFeature = false;
    protected boolean useRuntimeException = false;
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final Pattern JSON_VENDOR_MIME_PATTERN = Pattern.compile("(?i)application\\/vnd.(.*)+json(;.*)?");

    public JavaClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "java";
        this.templateDir = "Java";
        this.embeddedTemplateDir = "Java";
        this.invokerPackage = "org.openapitools.client";
        this.artifactId = "openapi-java-client";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA, "Whether to use the RxJava adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA2, "Whether to use the RxJava2 adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(PARCELABLE_MODEL, "Whether to generate models for Android that implement Parcelable with the okhttp-gson library."));
        this.cliOptions.add(CliOption.newBoolean(USE_PLAY_WS, "Use Play! Async HTTP client (Play WS API)"));
        this.cliOptions.add(CliOption.newString(PLAY_VERSION, "Version of Play! Framework (possible values \"play24\", \"play25\")"));
        this.cliOptions.add(CliOption.newBoolean("supportJava6", "Whether to support Java6 with the Jersey1 library."));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Perform BeanValidation"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeature", "Send gzip-encoded requests"));
        this.cliOptions.add(CliOption.newBoolean(USE_RUNTIME_EXCEPTION, "Use RuntimeException instead of Exception"));
        this.supportedLibraries.put(JERSEY1, "HTTP client: Jersey client 1.19.4. JSON processing: Jackson 2.8.9. Enable Java6 support using '-DsupportJava6=true'. Enable gzip request encoding using '-DuseGzipFeature=true'.");
        this.supportedLibraries.put(FEIGN, "HTTP client: OpenFeign 9.4.0. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(JERSEY2, "HTTP client: Jersey client 2.25.1. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(OKHTTP_GSON, "HTTP client: OkHttp 2.7.5. JSON processing: Gson 2.8.1. Enable Parcelable models on Android using '-DparcelableModel=true'. Enable gzip request encoding using '-DuseGzipFeature=true'.");
        this.supportedLibraries.put(RETROFIT_1, "HTTP client: OkHttp 2.7.5. JSON processing: Gson 2.3.1 (Retrofit 1.9.0). IMPORTANT NOTE: retrofit1.x is no longer actively maintained so please upgrade to 'retrofit2' instead.");
        this.supportedLibraries.put(RETROFIT_2, "HTTP client: OkHttp 3.8.0. JSON processing: Gson 2.6.1 (Retrofit 2.3.0). Enable the RxJava adapter using '-DuseRxJava[2]=true'. (RxJava 1.x or 2.x)");
        this.supportedLibraries.put(RESTTEMPLATE, "HTTP client: Spring RestTemplate 4.3.9-RELEASE. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(WEBCLIENT, "HTTP client: Spring WebClient 5.0.7-RELEASE. JSON processing: Jackson 2.9.5");
        this.supportedLibraries.put(RESTEASY, "HTTP client: Resteasy client 3.1.3.Final. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(VERTX, "HTTP client: VertX client 3.2.4. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(GOOGLE_API_CLIENT, "HTTP client: Google API client 1.23.0. JSON processing: Jackson 2.8.9");
        this.supportedLibraries.put(REST_ASSURED, "HTTP client: rest-assured : 3.1.0. JSON processing: Gson 2.6.1. Only for Java8");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(OKHTTP_GSON);
        this.cliOptions.add(libraryOption);
        this.setLibrary(OKHTTP_GSON);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public String getHelp() {
        return "Generates a Java client library.";
    }

    @Override
    public void processOpts() {
        if (WEBCLIENT.equals(this.getLibrary()) && "threetenbp".equals(this.dateLibrary)) {
            this.dateLibrary = "java8";
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(USE_RX_JAVA) && this.additionalProperties.containsKey(USE_RX_JAVA2)) {
            LOGGER.warn("You specified both RxJava versions 1 and 2 but they are mutually exclusive. Defaulting to v2.");
        } else if (this.additionalProperties.containsKey(USE_RX_JAVA)) {
            this.setUseRxJava(Boolean.valueOf(this.additionalProperties.get(USE_RX_JAVA).toString()));
        }
        if (this.additionalProperties.containsKey(USE_RX_JAVA2)) {
            this.setUseRxJava2(Boolean.valueOf(this.additionalProperties.get(USE_RX_JAVA2).toString()));
        }
        if (!this.useRxJava && !this.useRxJava2) {
            this.additionalProperties.put(DO_NOT_USE_RX, true);
        }
        if (this.additionalProperties.containsKey(USE_PLAY_WS)) {
            this.setUsePlayWS(Boolean.valueOf(this.additionalProperties.get(USE_PLAY_WS).toString()));
        }
        this.additionalProperties.put(USE_PLAY_WS, this.usePlayWS);
        if (this.additionalProperties.containsKey(PLAY_VERSION)) {
            this.setPlayVersion(this.additionalProperties.get(PLAY_VERSION).toString());
        }
        this.additionalProperties.put(PLAY_VERSION, this.playVersion);
        if (this.additionalProperties.containsKey(PARCELABLE_MODEL)) {
            this.setParcelableModel(Boolean.valueOf(this.additionalProperties.get(PARCELABLE_MODEL).toString()));
        }
        this.additionalProperties.put(PARCELABLE_MODEL, this.parcelableModel);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBooleanAndWriteBack("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("performBeanValidation")) {
            this.setPerformBeanValidation(this.convertPropertyToBooleanAndWriteBack("performBeanValidation"));
        }
        if (this.additionalProperties.containsKey("useGzipFeature")) {
            this.setUseGzipFeature(this.convertPropertyToBooleanAndWriteBack("useGzipFeature"));
        }
        if (this.additionalProperties.containsKey(USE_RUNTIME_EXCEPTION)) {
            this.setUseRuntimeException(this.convertPropertyToBooleanAndWriteBack(USE_RUNTIME_EXCEPTION));
        }
        String invokerFolder = (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/");
        String authFolder = (this.sourceFolder + '/' + this.invokerPackage + ".auth").replace(".", "/");
        String apiFolder = (this.sourceFolder + '/' + this.apiPackage).replace(".", "/");
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.writeOptional(this.outputFolder, new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.properties.mustache", "", "gradle.properties"));
        this.writeOptional(this.outputFolder, new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", invokerFolder, "ApiClient.java"));
        if (!RESTTEMPLATE.equals(this.getLibrary()) && !REST_ASSURED.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("StringUtil.mustache", invokerFolder, "StringUtil.java"));
        }
        if (!GOOGLE_API_CLIENT.equals(this.getLibrary()) && !REST_ASSURED.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.mustache", authFolder, "HttpBasicAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.mustache", authFolder, "ApiKeyAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/OAuth.mustache", authFolder, "OAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/OAuthFlow.mustache", authFolder, "OAuthFlow.java"));
        }
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.jar"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.performBeanValidation) {
            this.supportingFiles.add(new SupportingFile("BeanValidationException.mustache", invokerFolder, "BeanValidationException.java"));
        }
        if (FEIGN.equals(this.getLibrary()) || RETROFIT_1.equals(this.getLibrary())) {
            this.modelDocTemplateFiles.remove("model_doc.mustache");
            this.apiDocTemplateFiles.remove("api_doc.mustache");
        }
        if (!(FEIGN.equals(this.getLibrary()) || RESTTEMPLATE.equals(this.getLibrary()) || this.usesAnyRetrofitLibrary() || GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("apiException.mustache", invokerFolder, "ApiException.java"));
            this.supportingFiles.add(new SupportingFile("Configuration.mustache", invokerFolder, "Configuration.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", authFolder, "Authentication.java"));
        }
        if (FEIGN.equals(this.getLibrary())) {
            this.additionalProperties.put("jackson", "true");
            this.supportingFiles.add(new SupportingFile("ParamExpander.mustache", invokerFolder, "ParamExpander.java"));
            this.supportingFiles.add(new SupportingFile("EncodingUtils.mustache", invokerFolder, "EncodingUtils.java"));
        } else if (OKHTTP_GSON.equals(this.getLibrary()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("ApiCallback.mustache", invokerFolder, "ApiCallback.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ProgressRequestBody.mustache", invokerFolder, "ProgressRequestBody.java"));
            this.supportingFiles.add(new SupportingFile("ProgressResponseBody.mustache", invokerFolder, "ProgressResponseBody.java"));
            this.supportingFiles.add(new SupportingFile("GzipRequestInterceptor.mustache", invokerFolder, "GzipRequestInterceptor.java"));
            this.additionalProperties.put("gson", "true");
        } else if (this.usesAnyRetrofitLibrary()) {
            this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.mustache", authFolder, "OAuthOkHttpClient.java"));
            this.supportingFiles.add(new SupportingFile("CollectionFormats.mustache", invokerFolder, "CollectionFormats.java"));
            this.additionalProperties.put("gson", "true");
            if (RETROFIT_2.equals(this.getLibrary()) && !this.usePlayWS) {
                this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            }
        } else if (JERSEY2.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.additionalProperties.put("jackson", "true");
        } else if (RESTEASY.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.additionalProperties.put("jackson", "true");
        } else if (JERSEY1.equals(this.getLibrary())) {
            this.additionalProperties.put("jackson", "true");
        } else if (RESTTEMPLATE.equals(this.getLibrary())) {
            this.additionalProperties.put("jackson", "true");
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", authFolder, "Authentication.java"));
        } else if (WEBCLIENT.equals(this.getLibrary())) {
            this.setJava8Mode(true);
            this.additionalProperties.put("java8", "true");
            this.additionalProperties.put("jackson", "true");
        } else if (VERTX.equals(this.getLibrary())) {
            this.typeMapping.put("file", "AsyncFile");
            this.importMapping.put("AsyncFile", "io.vertx.core.file.AsyncFile");
            this.setJava8Mode(true);
            this.additionalProperties.put("java8", "true");
            this.additionalProperties.put("jackson", "true");
            this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
            this.apiTemplateFiles.put("rxApiImpl.mustache", ".java");
            this.supportingFiles.remove(new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        } else if (GOOGLE_API_CLIENT.equals(this.getLibrary())) {
            this.additionalProperties.put("jackson", "true");
        } else if (REST_ASSURED.equals(this.getLibrary())) {
            this.additionalProperties.put("gson", "true");
            this.additionalProperties.put("convert", new CaseFormatLambda(CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_UNDERSCORE));
            this.apiTemplateFiles.put("api.mustache", ".java");
            this.supportingFiles.add(new SupportingFile("ResponseSpecBuilders.mustache", invokerFolder, "ResponseSpecBuilders.java"));
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("GsonObjectMapper.mustache", invokerFolder, "GsonObjectMapper.java"));
        } else {
            LOGGER.error("Unknown library option (-l/--library): " + this.getLibrary());
        }
        if (this.usePlayWS) {
            Iterator iter = this.supportingFiles.iterator();
            while (iter.hasNext()) {
                SupportingFile sf = (SupportingFile)iter.next();
                if (!sf.templateFile.startsWith("auth/")) continue;
                iter.remove();
            }
            this.apiTemplateFiles.remove("api.mustache");
            if (PLAY_24.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_24, true);
                this.apiTemplateFiles.put("play24/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play24/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play24/Play24CallFactory.mustache", invokerFolder, "Play24CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play24/Play24CallAdapterFactory.mustache", invokerFolder, "Play24CallAdapterFactory.java"));
            }
            if (PLAY_25.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_25, true);
                this.apiTemplateFiles.put("play25/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play25/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play25/Play25CallFactory.mustache", invokerFolder, "Play25CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play25/Play25CallAdapterFactory.mustache", invokerFolder, "Play25CallAdapterFactory.java"));
                this.additionalProperties.put("java8", "true");
            }
            if (PLAY_26.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_26, true);
                this.apiTemplateFiles.put("play26/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play26/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play26/Play26CallFactory.mustache", invokerFolder, "Play26CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play26/Play26CallAdapterFactory.mustache", invokerFolder, "Play26CallAdapterFactory.java"));
                this.additionalProperties.put("java8", "true");
            }
            this.supportingFiles.add(new SupportingFile("play-common/auth/ApiKeyAuth.mustache", authFolder, "ApiKeyAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", authFolder, "Authentication.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
            this.additionalProperties.put("jackson", "true");
            this.additionalProperties.remove("gson");
        }
        if (this.additionalProperties.containsKey("jackson")) {
            this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", invokerFolder, "RFC3339DateFormat.java"));
            if ("threetenbp".equals(this.dateLibrary) && !this.usePlayWS) {
                this.supportingFiles.add(new SupportingFile("CustomInstantDeserializer.mustache", invokerFolder, "CustomInstantDeserializer.java"));
            }
        }
    }

    private boolean usesAnyRetrofitLibrary() {
        return this.getLibrary() != null && this.getLibrary().contains(RETROFIT_1);
    }

    private boolean usesRetrofit2Library() {
        return this.getLibrary() != null && this.getLibrary().contains(RETROFIT_2);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (this.usesAnyRetrofitLibrary() && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.hasConsumes == Boolean.TRUE) {
                    if (JavaClientCodegen.isMultipartType(operation.consumes)) {
                        operation.isMultipart = Boolean.TRUE;
                    } else {
                        operation.prioritizedContentTypes = JavaClientCodegen.prioritizeContentTypes(operation.consumes);
                    }
                }
                if (this.usesRetrofit2Library() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)operation.path) && operation.path.startsWith("/")) {
                    operation.path = operation.path.substring(1);
                }
                if (operation.allParams == null) continue;
                Collections.sort(operation.allParams, new Comparator<CodegenParameter>(){

                    @Override
                    public int compare(CodegenParameter one, CodegenParameter another) {
                        if (one.isPathParam && another.isQueryParam) {
                            return -1;
                        }
                        if (one.isQueryParam && another.isPathParam) {
                            return 1;
                        }
                        return 0;
                    }
                });
                Iterator<CodegenParameter> iterator = operation.allParams.iterator();
                while (iterator.hasNext()) {
                    CodegenParameter param = iterator.next();
                    param.hasMore = iterator.hasNext();
                }
            }
        }
        if (FEIGN.equals(this.getLibrary())) {
            operations = (Map)objs.get("operations");
            List operationList = (List)operations.get("operation");
            for (CodegenOperation op : operationList) {
                String path = op.path;
                Object[] items = path.split("/", -1);
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].matches("^\\{(.*)\\}$")) continue;
                    items[i] = "{" + StringUtils.camelize(((String)items[i]).substring(1, ((String)items[i]).length() - 1), true) + "}";
                }
                op.path = org.apache.commons.lang3.StringUtils.join((Object[])items, (String)"/");
            }
        }
        return objs;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        if (VERTX.equals(this.getLibrary())) {
            String suffix = this.apiTemplateFiles().get(templateName);
            String subFolder = "";
            if (templateName.startsWith("rx")) {
                subFolder = "/rxjava";
            }
            return this.apiFileFolder() + subFolder + '/' + this.toApiFilename(tag) + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    static List<Map<String, String>> prioritizeContentTypes(List<Map<String, String>> consumes) {
        if (consumes.size() <= 1) {
            return consumes;
        }
        ArrayList<Map<String, String>> prioritizedContentTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonVendorMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        for (Map<String, String> consume : consumes) {
            if (JavaClientCodegen.isJsonVendorMimeType(consume.get(MEDIA_TYPE))) {
                jsonVendorMimeTypes.add(consume);
            } else if (JavaClientCodegen.isJsonMimeType(consume.get(MEDIA_TYPE))) {
                jsonMimeTypes.add(consume);
            } else {
                prioritizedContentTypes.add(consume);
            }
            consume.put("hasMore", "true");
        }
        prioritizedContentTypes.addAll(0, jsonMimeTypes);
        prioritizedContentTypes.addAll(0, jsonVendorMimeTypes);
        ((Map)prioritizedContentTypes.get(prioritizedContentTypes.size() - 1)).put("hasMore", null);
        return prioritizedContentTypes;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        return firstType != null && "multipart/form-data".equals(firstType.get(MEDIA_TYPE));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            if (this.additionalProperties.containsKey("jackson")) {
                model.imports.add("JsonProperty");
                model.imports.add("JsonValue");
            }
            if (this.additionalProperties.containsKey("gson")) {
                model.imports.add("SerializedName");
                model.imports.add("TypeAdapter");
                model.imports.add("JsonAdapter");
                model.imports.add("JsonReader");
                model.imports.add("JsonWriter");
                model.imports.add("IOException");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        if (this.additionalProperties.containsKey("gson")) {
            List imports = (List)objs.get("imports");
            List models = (List)objs.get("models");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
                cm.imports.add((String)this.importMapping.get("SerializedName"));
                HashMap item = new HashMap();
                item.put("import", this.importMapping.get("SerializedName"));
                imports.add(item);
            }
        }
        return objs;
    }

    public void setUseRxJava(boolean useRxJava) {
        this.useRxJava = useRxJava;
        this.doNotUseRx = false;
    }

    public void setUseRxJava2(boolean useRxJava2) {
        this.useRxJava2 = useRxJava2;
        this.doNotUseRx = false;
    }

    public void setDoNotUseRx(boolean doNotUseRx) {
        this.doNotUseRx = doNotUseRx;
    }

    public void setUsePlayWS(boolean usePlayWS) {
        this.usePlayWS = usePlayWS;
    }

    public void setPlayVersion(String playVersion) {
        this.playVersion = playVersion;
    }

    public void setParcelableModel(boolean parcelableModel) {
        this.parcelableModel = parcelableModel;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    @Override
    public void setUseGzipFeature(boolean useGzipFeature) {
        this.useGzipFeature = useGzipFeature;
    }

    public void setUseRuntimeException(boolean useRuntimeException) {
        this.useRuntimeException = useRuntimeException;
    }

    static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    static boolean isJsonVendorMimeType(String mime) {
        return mime != null && JSON_VENDOR_MIME_PATTERN.matcher(mime).matches();
    }
}

