/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonClientCodegen.class);
    public static final String PACKAGE_URL = "packageUrl";
    public static final String DEFAULT_LIBRARY = "urllib3";
    protected String packageName;
    protected String packageVersion;
    protected String projectName;
    protected String packageUrl;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected Map<Character, String> regexModifiers;
    private String testFolder;

    public PythonClientCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.modelTestTemplateFiles.put("model_test.mustache", ".py");
        this.apiTestTemplateFiles.put("api_test.mustache", ".py");
        this.templateDir = "python";
        this.embeddedTemplateDir = "python";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.testFolder = "test";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("object");
        this.languageSpecificPrimitives.add("file");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("binary", "str");
        this.typeMapping.put("ByteArray", "str");
        this.typeMapping.put("UUID", "str");
        this.setReservedWordsLowerCase(Arrays.asList("all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("projectName", "python project name in setup.py (e.g. petstore-api)."));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(PACKAGE_URL, "python package URL."));
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("generateSourceCodeOnly", "Specifies that only a library source code is to be generated.").defaultValue(Boolean.FALSE.toString()));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "urllib3-based client");
        this.supportedLibraries.put("asyncio", "Asyncio-based client (python 3.5+)");
        this.supportedLibraries.put("tornado", "tornado-based client");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use: asyncio, tornado, urllib3");
        libraryOption.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(DEFAULT_LIBRARY);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = Boolean.valueOf(this.additionalProperties.get("excludeTests").toString());
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi_client");
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.setProjectName(this.packageName.replaceAll("_", "-"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = true;
        }
        this.additionalProperties.put("projectName", this.projectName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        if (generateSourceCodeOnly.booleanValue()) {
            this.testFolder = this.packageName + File.separatorChar + this.testFolder;
            this.apiDocPath = this.packageName + File.separatorChar + this.apiDocPath;
            this.modelDocPath = this.packageName + File.separatorChar + this.modelDocPath;
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.additionalProperties.containsKey(PACKAGE_URL)) {
            this.setPackageUrl((String)this.additionalProperties.get(PACKAGE_URL));
        }
        String readmePath = "README.md";
        String readmeTemplate = "README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packageName + "_" + readmePath;
            readmeTemplate = "README_onlypackage.mustache";
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tox.mustache", "", "tox.ini"));
            this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
            this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
            this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
        }
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.packageName, "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", this.packageName, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.packageName + File.separatorChar + this.modelPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", this.packageName + File.separatorChar + this.apiPackage, "__init__.py"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("__init__test.mustache", this.testFolder, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.packageName, "api_client.py"));
        if ("asyncio".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("asyncio/rest.mustache", this.packageName, "rest.py"));
            this.additionalProperties.put("asyncio", "true");
        } else if ("tornado".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("tornado/rest.mustache", this.packageName, "rest.py"));
            this.additionalProperties.put("tornado", "true");
        } else {
            this.supportingFiles.add(new SupportingFile("rest.mustache", this.packageName, "rest.py"));
        }
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.apiPackage = this.packageName + "." + this.apiPackage;
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public String toModelImport(String name) {
        String modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = modelImport + this.modelPackage() + ".";
            }
            modelImport = modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + "/" + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + "/" + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "(str, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(openAPIType);
        }
        return type;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        name = StringUtils.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "param_callback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(PythonClientCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_api";
        }
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String generatePackageName(String packageName) {
        return StringUtils.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (p.getDefault().toString().equalsIgnoreCase("false")) {
                    return "False";
                }
                return "True";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
                if (Pattern.compile("\r\n|\r|\n").matcher((String)p.getDefault()).find()) {
                    return "'''" + p.getDefault() + "'''";
                }
                return "'" + p.getDefault() + "'";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.packageName + "." + type + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "NULL";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key': " + example + "}";
        }
        p.example = example;
    }

    @Override
    public String sanitizeTag(String tag) {
        return this.sanitizeName(tag);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }
}

